/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import com.replaymod.core.events.KeyBindingEventCallback;
import com.replaymod.core.events.KeyEventCallback;
import com.replaymod.core.events.PreRenderCallback;
import com.replaymod.core.mixin.KeyBindingAccessor;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@EventBusSubscriber(modid="replaymod", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class KeyBindingRegistry
extends EventRegistrations {
    private static final String CATEGORY = "replaymod.title";
    private final Map<String, Binding> bindings = new HashMap<String, Binding>();
    private Set<KeyMapping> onlyInReplay = new HashSet<KeyMapping>();
    private Multimap<Integer, Supplier<Boolean>> rawHandlers = ArrayListMultimap.create();
    private static List<KeyMapping> keybinds = new ArrayList<KeyMapping>();

    public KeyBindingRegistry() {
        this.on(PreRenderCallback.EVENT, this::handleRepeatedKeyBindings);
        this.on(KeyBindingEventCallback.EVENT, this::handleKeyBindings);
        this.on(KeyEventCallback.EVENT, (keyCode, scanCode, action, modifiers) -> this.handleRaw(keyCode, action));
    }

    public Binding registerKeyBinding(String name, int keyCode, Runnable whenPressed, boolean onlyInRepay) {
        Binding binding = this.registerKeyBinding(name, keyCode, onlyInRepay);
        binding.handlers.add(whenPressed);
        return binding;
    }

    public Binding registerRepeatedKeyBinding(String name, int keyCode, Runnable whenPressed, boolean onlyInRepay) {
        Binding binding = this.registerKeyBinding(name, keyCode, onlyInRepay);
        binding.repeatedHandlers.add(whenPressed);
        return binding;
    }

    private Binding registerKeyBinding(String name, int keyCode, boolean onlyInRepay) {
        Binding binding = this.bindings.get(name);
        if (binding == null) {
            if (keyCode == 0) {
                keyCode = -1;
            }
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"replaymod", (String)name.substring("replaymod.input.".length()));
            String key = String.format("key.%s.%s", id.getNamespace(), id.getPath());
            KeyMapping keyBinding = new KeyMapping(key, InputConstants.Type.KEYSYM, keyCode, CATEGORY);
            keybinds.add(keyBinding);
            binding = new Binding(name, keyBinding);
            this.bindings.put(name, binding);
            if (onlyInRepay) {
                this.onlyInReplay.add(keyBinding);
            }
        } else if (!onlyInRepay) {
            this.onlyInReplay.remove(binding.keyBinding);
        }
        return binding;
    }

    public void registerRaw(int keyCode, Supplier<Boolean> whenPressed) {
        this.rawHandlers.put((Object)keyCode, whenPressed);
    }

    public Map<String, Binding> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    public Set<KeyMapping> getOnlyInReplay() {
        return Collections.unmodifiableSet(this.onlyInReplay);
    }

    public void handleRepeatedKeyBindings() {
        for (Binding binding : this.bindings.values()) {
            if (!binding.keyBinding.isDown()) continue;
            this.invokeKeyBindingHandlers(binding, binding.repeatedHandlers);
        }
    }

    private void handleKeyBindings() {
        for (Binding binding : this.bindings.values()) {
            while (binding.keyBinding.consumeClick()) {
                this.invokeKeyBindingHandlers(binding, binding.handlers);
                this.invokeKeyBindingHandlers(binding, binding.repeatedHandlers);
            }
        }
    }

    private void invokeKeyBindingHandlers(Binding binding, Collection<Runnable> handlers) {
        for (Runnable runnable : handlers) {
            try {
                runnable.run();
            }
            catch (Throwable cause) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)cause, (String)"Handling Key Binding");
                CrashReportCategory category = crashReport.addCategory("Key Binding");
                category.setDetail("Key Binding", () -> binding.name);
                category.setDetail("Handler", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Runnable)runnable));
                throw new ReportedException(crashReport);
            }
        }
    }

    private boolean handleRaw(int keyCode, int action) {
        if (action != 1) {
            return false;
        }
        for (Supplier handler : this.rawHandlers.get((Object)keyCode)) {
            try {
                if (!((Boolean)handler.get()).booleanValue()) continue;
                return true;
            }
            catch (Throwable cause) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)cause, (String)"Handling Raw Key Binding");
                CrashReportCategory category = crashReport.addCategory("Key Binding");
                category.setDetail("Key Code", () -> "" + keyCode);
                category.setDetail("Handler", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Supplier)handler));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        for (KeyMapping binding : keybinds) {
            event.register(binding);
        }
    }

    public class Binding {
        public final String name;
        public final KeyMapping keyBinding;
        private final List<Runnable> handlers = new ArrayList<Runnable>();
        private final List<Runnable> repeatedHandlers = new ArrayList<Runnable>();
        private boolean autoActivation;
        private Consumer<Boolean> autoActivationUpdate;

        public Binding(String name, KeyMapping keyBinding) {
            this.name = name;
            this.keyBinding = keyBinding;
        }

        public String getBoundKey() {
            try {
                return this.keyBinding.getTranslatedKeyMessage().getString();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return "Unknown";
            }
        }

        public boolean isBound() {
            return !this.keyBinding.isUnbound();
        }

        public void trigger() {
            KeyBindingAccessor acc = (KeyBindingAccessor)this.keyBinding;
            acc.setPressTime(acc.getPressTime() + 1);
            KeyBindingRegistry.this.handleKeyBindings();
        }

        public void registerAutoActivationSupport(boolean active, Consumer<Boolean> update) {
            this.autoActivation = active;
            this.autoActivationUpdate = update;
        }

        public boolean supportsAutoActivation() {
            return this.autoActivationUpdate != null;
        }

        public boolean isAutoActivating() {
            return this.supportsAutoActivation() && this.autoActivation;
        }

        public void setAutoActivating(boolean active) {
            if (this.autoActivation == active) {
                return;
            }
            this.autoActivation = active;
            this.autoActivationUpdate.accept(active);
        }
    }
}

