/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.gui;

import com.replaymod.core.SettingsRegistry;
import de.johni0702.minecraft.gui.container.AbstractGuiScreen;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.GuiToggleButton;
import de.johni0702.minecraft.gui.element.advanced.GuiDropdownMenu;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import de.johni0702.minecraft.gui.utils.Consumer;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;

public class GuiReplaySettings
extends AbstractGuiScreen<GuiReplaySettings> {
    public GuiReplaySettings(final Screen parent, final SettingsRegistry settingsRegistry) {
        final GuiButton doneButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton(this).setI18nLabel("gui.done", new Object[0])).setSize(200, 20)).onClick(new Runnable(){

            @Override
            public void run() {
                GuiReplaySettings.this.getMinecraft().setScreen(parent);
            }
        });
        final GuiPanel allElements = (GuiPanel)new GuiPanel(this).setLayout(new HorizontalLayout().setSpacing(10));
        GuiPanel leftColumn = (GuiPanel)new GuiPanel().setLayout(new VerticalLayout().setSpacing(4));
        GuiPanel rightColumn = (GuiPanel)new GuiPanel().setLayout(new VerticalLayout().setSpacing(4));
        allElements.addElements(new VerticalLayout.Data(0.0), new GuiElement[]{leftColumn, rightColumn});
        HorizontalLayout.Data leftHorizontalData = new HorizontalLayout.Data(1.0);
        HorizontalLayout.Data rightHorizontalData = new HorizontalLayout.Data(0.0);
        int i = 0;
        for (SettingsRegistry.SettingKey<?> key : settingsRegistry.getSettings()) {
            GuiElement element;
            if (key.getDisplayString() == null) continue;
            if (key.getDefault() instanceof Boolean) {
                final SettingsRegistry.SettingKey<?> booleanKey = key;
                final GuiToggleButton button = (GuiToggleButton)((GuiToggleButton)((GuiToggleButton)((GuiToggleButton)new GuiToggleButton().setSize(150, 20)).setI18nLabel(key.getDisplayString(), new Object[0])).setSelected((Boolean)settingsRegistry.get(booleanKey) != false ? 0 : 1)).setValues(new Object[]{I18n.get((String)"options.on", (Object[])new Object[0]), I18n.get((String)"options.off", (Object[])new Object[0])});
                element = button.onClick(new Runnable(){

                    @Override
                    public void run() {
                        settingsRegistry.set(booleanKey, button.getSelected() == 0);
                        settingsRegistry.save();
                    }
                });
            } else if (key instanceof SettingsRegistry.MultipleChoiceSettingKey) {
                final SettingsRegistry.MultipleChoiceSettingKey multipleChoiceKey = (SettingsRegistry.MultipleChoiceSettingKey)key;
                List values = multipleChoiceKey.getChoices();
                Object[] entries = new MultipleChoiceDropdownEntry[values.size()];
                int selected = 0;
                Object currentValue = settingsRegistry.get(multipleChoiceKey);
                for (int j = 0; j < entries.length; ++j) {
                    Object value = values.get(j);
                    entries[j] = new MultipleChoiceDropdownEntry(value, I18n.get((String)multipleChoiceKey.getDisplayString(), (Object[])new Object[0]) + ": " + I18n.get((String)value.toString(), (Object[])new Object[0]));
                    if (!currentValue.equals(value)) continue;
                    selected = j;
                }
                final GuiDropdownMenu menu = (GuiDropdownMenu)((GuiDropdownMenu)new GuiDropdownMenu<MultipleChoiceDropdownEntry>(this){

                    @Override
                    protected ReadableDimension calcMinSize() {
                        ReadableDimension size = super.calcMinSize();
                        if (size.getWidth() > 150) {
                            return new Dimension(150, size.getHeight());
                        }
                        return size;
                    }
                }.setSize(150, 20)).setValues(entries);
                ((GuiDropdownMenu)menu.setSelected(selected)).onSelection((Consumer)new Consumer<Integer>(){

                    @Override
                    public void consume(Integer obj) {
                        settingsRegistry.set(multipleChoiceKey, ((MultipleChoiceDropdownEntry)menu.getSelectedValue()).value);
                        settingsRegistry.save();
                    }
                });
                element = menu;
            } else {
                throw new IllegalArgumentException("Type " + String.valueOf(key.getDefault().getClass()) + " not supported.");
            }
            if (i++ % 2 == 0) {
                leftColumn.addElements(leftHorizontalData, new GuiElement[]{element});
                continue;
            }
            rightColumn.addElements(rightHorizontalData, new GuiElement[]{element});
        }
        this.setLayout(new CustomLayout<GuiReplaySettings>(this){

            @Override
            protected void layout(GuiReplaySettings container, int width, int height) {
                this.pos(allElements, width / 2 - 155, height / 6);
                this.pos(doneButton, width / 2 - 100, height - 27);
            }
        });
        this.setTitle((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.settings.title", new Object[0]));
    }

    @Override
    protected GuiReplaySettings getThis() {
        return this;
    }

    private static class MultipleChoiceDropdownEntry {
        private final Object value;
        private final String text;

        public MultipleChoiceDropdownEntry(Object value, String text) {
            this.value = value;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

