/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.versions.scheduler;

import com.replaymod.core.mixin.MinecraftAccessor;
import com.replaymod.core.versions.scheduler.Scheduler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;

public class SchedulerImpl
implements Scheduler {
    private static final Minecraft mc = Minecraft.getInstance();
    private boolean inRunLater = false;
    private boolean inRenderTaskQueue = false;
    public final ReplayModExecutor executor = new ReplayModExecutor("Client/ReplayMod");

    @Override
    public void runSync(Runnable runnable) throws InterruptedException, ExecutionException, TimeoutException {
        if (mc.isSameThread()) {
            runnable.run();
        } else {
            this.executor.submit(() -> {
                runnable.run();
                return null;
            }).get(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void runPostStartup(final Runnable runnable) {
        this.runLater(new Runnable(){

            @Override
            public void run() {
                if (mc.getOverlay() != null) {
                    SchedulerImpl.this.runLater(this);
                    return;
                }
                runnable.run();
            }
        });
    }

    @Override
    public void runTasks() {
        this.executor.runAllTasks();
    }

    @Override
    public void runLaterWithoutLock(Runnable runnable) {
        this.runLater(runnable);
    }

    @Override
    public void runLater(Runnable runnable) {
        this.runLater(runnable, () -> this.runLater(runnable));
    }

    private void runLater(Runnable runnable, Runnable defer) {
        if (mc.isSameThread() && this.inRunLater && !this.inRenderTaskQueue) {
            ((MinecraftAccessor)mc).getProgressTasks().offer(() -> {
                this.inRenderTaskQueue = true;
                try {
                    defer.run();
                }
                finally {
                    this.inRenderTaskQueue = false;
                }
            });
        } else {
            this.executor.tell(() -> {
                this.inRunLater = true;
                try {
                    runnable.run();
                }
                catch (ReportedException e) {
                    e.printStackTrace();
                    System.err.println(e.getReport().getFriendlyReport(ReportType.CRASH));
                    mc.delayCrashRaw(e.getReport());
                }
                finally {
                    this.inRunLater = false;
                }
            });
        }
    }

    public static class ReplayModExecutor
    extends ReentrantBlockableEventLoop<Runnable> {
        private final Thread mcThread = Thread.currentThread();

        private ReplayModExecutor(String string_1) {
            super(string_1);
        }

        protected Runnable wrapRunnable(Runnable runnable) {
            return runnable;
        }

        protected boolean shouldRun(Runnable runnable) {
            return true;
        }

        protected Thread getRunningThread() {
            return this.mcThread;
        }

        public void runAllTasks() {
            super.runAllTasks();
        }
    }
}

