/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.mixin;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Map;
import net.minecraft.network.Connection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public abstract class MixinClientConnection {
    @Shadow
    private Channel channel;

    @Inject(method={"setupCompression(IZ)V"}, at={@At(value="RETURN")})
    private void ensureReplayModRecorderIsAfterDecompress(CallbackInfo ci) {
        ChannelHandler recorder = null;
        for (Map.Entry entry : this.channel.pipeline()) {
            String key = (String)entry.getKey();
            if ("replay_recorder_raw".equals(key)) {
                recorder = (ChannelHandler)entry.getValue();
            }
            if (!"decompress".equals(key) || recorder == null) continue;
            this.channel.pipeline().remove(recorder);
            this.channel.pipeline().addBefore("decoder", "replay_recorder_raw", recorder);
            return;
        }
    }
}

