/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.mixin;

import com.github.steveice10.netty.buffer.Unpooled;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.replaymod.core.versions.MCVer;
import com.replaymod.recording.ReplayModRecording;
import com.replaymod.recording.packet.PacketListener;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientConfigurationPacketListenerImpl.class})
public abstract class MixinNetHandlerConfigClient {
    @Inject(method={"handleConfigurationFinished(Lnet/minecraft/network/protocol/configuration/ClientboundFinishConfigurationPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/Connection;setupInboundProtocol(Lnet/minecraft/network/ProtocolInfo;Lnet/minecraft/network/PacketListener;)V")})
    public void recordEnabledPackData(CallbackInfo ci, @Local RegistryAccess.Frozen registryManager) {
        PacketListener packetListener = ReplayModRecording.instance.getConnectionEventHandler().getPacketListener();
        if (packetListener == null) {
            return;
        }
        ByteBuf byteBuf = io.netty.buffer.Unpooled.buffer();
        FriendlyByteBuf buf = new FriendlyByteBuf(byteBuf);
        buf.writeUtf("replaymod:enabled_packs_data");
        buf.writeVarInt(1);
        this.write(buf, registryManager.registryOrThrow(Registries.DIMENSION_TYPE), DimensionType.DIRECT_CODEC);
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        byteBuf.release();
        PacketTypeRegistry registry = MCVer.getPacketTypeRegistry(State.CONFIGURATION);
        packetListener.save(new Packet(registry, PacketType.ConfigCustomPayload, Unpooled.wrappedBuffer(bytes)));
        packetListener.save(new Packet(registry, PacketType.ConfigFinish));
    }

    @Unique
    private <T> void write(FriendlyByteBuf buf, Registry<T> registry, Codec<T> codec) {
        buf.writeUtf(registry.key().location().toString());
        buf.writeVarInt(registry.size());
        for (Map.Entry entry : registry.entrySet()) {
            buf.writeUtf(((ResourceKey)entry.getKey()).location().toString());
            buf.writeNbt((Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, entry.getValue()).getOrThrow());
        }
    }
}

