/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.mixin;

import com.replaymod.core.versions.MCVer;
import com.replaymod.recording.handler.RecordingEventHandler;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinNetHandlerPlayClient {
    private static Minecraft mcStatic = MCVer.getMinecraft();
    @Shadow
    private Map<UUID, PlayerInfo> playerInfoMap;

    public RecordingEventHandler getRecordingEventHandler() {
        return ((RecordingEventHandler.RecordingEventSender)MixinNetHandlerPlayClient.mcStatic.levelRenderer).getRecordingEventHandler();
    }

    @Inject(method={"handlePlayerInfoUpdate(Lnet/minecraft/network/protocol/game/ClientboundPlayerInfoUpdatePacket;)V"}, at={@At(value="HEAD")})
    public void recordOwnJoin(ClientboundPlayerInfoUpdatePacket packet, CallbackInfo ci) {
        if (!mcStatic.isSameThread()) {
            return;
        }
        if (MixinNetHandlerPlayClient.mcStatic.player == null) {
            return;
        }
        RecordingEventHandler handler = this.getRecordingEventHandler();
        if (handler != null && packet.actions().contains(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER)) {
            for (ClientboundPlayerInfoUpdatePacket.Entry entry : packet.entries()) {
                UUID uuid = entry.profileId();
                if (!uuid.equals(MixinNetHandlerPlayClient.mcStatic.player.getGameProfile().getId()) || this.playerInfoMap.containsKey(uuid)) continue;
                handler.spawnRecordingPlayer();
            }
        }
    }

    @Inject(method={"handleRespawn(Lnet/minecraft/network/protocol/game/ClientboundRespawnPacket;)V"}, at={@At(value="RETURN")})
    public void recordOwnRespawn(ClientboundRespawnPacket packet, CallbackInfo ci) {
        RecordingEventHandler handler = this.getRecordingEventHandler();
        if (handler != null) {
            handler.spawnRecordingPlayer();
        }
    }
}

