/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.blend;

import com.replaymod.render.ReplayModRender;
import com.replaymod.render.blend.BlendMaterials;
import com.replaymod.render.blend.Exporter;
import com.replaymod.render.blend.data.DScene;
import com.replaymod.render.blend.data.Serializer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import org.apache.commons.io.output.NullOutputStream;
import org.blender.utils.BlenderFactory;
import org.cakelab.blender.io.BlenderFile;

public class BlendState
implements Exporter {
    private static BlendState currentState;
    private final List<Exporter> exporters = new ArrayList<Exporter>();
    private final BlenderFile blenderFile;
    private final BlenderFactory factory;
    private final DScene scene = new DScene();
    private final BlendMaterials materials = new BlendMaterials();

    public static void setState(BlendState state) {
        currentState = state;
    }

    public static BlendState getState() {
        return currentState;
    }

    public BlendState(File file) throws IOException {
        this.blenderFile = BlenderFactory.newBlenderFile((File)file);
        this.factory = new BlenderFactory(this.blenderFile);
    }

    public void register(Exporter exporter) {
        this.exporters.add(exporter);
    }

    public <T extends Exporter> T get(Class<T> clazz) {
        for (Exporter exporter : this.exporters) {
            if (!clazz.isInstance(exporter)) continue;
            return (T)((Exporter)clazz.cast(exporter));
        }
        throw new NoSuchElementException("No exporter of type " + String.valueOf(clazz));
    }

    @Override
    public void setup() {
        for (Exporter exporter : this.exporters) {
            try {
                exporter.setup();
            }
            catch (IOException e) {
                CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Setup of blend exporter");
                CrashReportCategory category = report.addCategory("Exporter");
                category.setDetail("Exporter", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Exporter)exporter));
                throw new ReportedException(report);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        for (Exporter exporter : this.exporters) {
            try {
                exporter.tearDown();
            }
            catch (IOException e) {
                CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Tear down of blend exporter");
                CrashReportCategory category = report.addCategory("Exporter");
                category.setDetail("Exporter", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Exporter)exporter));
                throw new ReportedException(report);
            }
        }
        try {
            Serializer serializer = new Serializer();
            this.scene.serialize(serializer);
            PrintStream sysout = System.out;
            try {
                System.setOut(new PrintStream((OutputStream)new NullOutputStream()));
                this.blenderFile.write();
            }
            finally {
                System.setOut(sysout);
            }
        }
        catch (IOException e) {
            ReplayModRender.LOGGER.error("Exception writing blend file: ", (Throwable)e);
        }
        finally {
            try {
                this.blenderFile.close();
            }
            catch (IOException e) {
                ReplayModRender.LOGGER.error("Exception closing blend file: ", (Throwable)e);
            }
        }
    }

    @Override
    public void preFrame(int frame) {
        for (Exporter exporter : this.exporters) {
            try {
                exporter.preFrame(frame);
            }
            catch (IOException e) {
                CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Pre frame of blend exporter");
                CrashReportCategory category = report.addCategory("Exporter");
                category.setDetail("Exporter", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Exporter)exporter));
                category.setDetail("Frame", () -> String.valueOf(frame));
                throw new ReportedException(report);
            }
        }
    }

    @Override
    public void postFrame(int frame) {
        for (Exporter exporter : this.exporters) {
            try {
                exporter.postFrame(frame);
            }
            catch (IOException e) {
                CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Post frame of blend exporter");
                CrashReportCategory category = report.addCategory("Exporter");
                category.setDetail("Exporter", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Exporter)exporter));
                category.setDetail("Frame", () -> String.valueOf(frame));
                throw new ReportedException(report);
            }
        }
        this.scene.endFrame = frame;
    }

    public BlenderFile getBlenderFile() {
        return this.blenderFile;
    }

    public BlenderFactory getFactory() {
        return this.factory;
    }

    public DScene getScene() {
        return this.scene;
    }

    public BlendMaterials getMaterials() {
        return this.materials;
    }
}

