/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.blend.data;

import com.replaymod.render.blend.data.DId;
import com.replaymod.render.blend.data.DObject;
import com.replaymod.render.blend.data.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.blender.dna.Base;
import org.blender.dna.BlenderObject;
import org.blender.dna.RenderData;
import org.blender.dna.Scene;
import org.blender.dna.ToolSettings;
import org.cakelab.blender.io.block.BlockCodes;
import org.cakelab.blender.nio.CPointer;

public class DScene {
    public final DId id = new DId(BlockCodes.ID_SCE, "Scene");
    public final List<DObject> base = new ArrayList<DObject>();
    public int endFrame;

    private Set<DObject> findAllObjects(DObject curr, Set<DObject> set) {
        for (DObject child : curr == null ? this.base : curr.getChildren()) {
            if (!child.isValid()) continue;
            this.findAllObjects(child, set);
            set.add(child);
        }
        return set;
    }

    public CPointer<Scene> serialize(Serializer serializer) throws IOException {
        return serializer.maybeMajor(this, this.id, Scene.class, () -> {
            Set<DObject> allObjects = this.findAllObjects(null, new LinkedHashSet<DObject>());
            ArrayList<CPointer<BlenderObject>> bases = new ArrayList<CPointer<BlenderObject>>(allObjects.size());
            for (DObject dObject : allObjects) {
                bases.add(dObject.serialize(serializer));
            }
            return scene -> {
                serializer.writeDataList(Base.class, scene.getBase(), bases.size(), (i, base) -> {
                    CPointer objPointer = (CPointer)bases.get((int)i);
                    base.setLay(((BlenderObject)objPointer.get()).getLay());
                    base.setObject(objPointer);
                });
                RenderData renderData = scene.getR();
                renderData.setXsch(1920);
                renderData.setYsch(1080);
                renderData.setSize((short)100);
                renderData.setXasp(1.0f);
                renderData.setYasp(1.0f);
                renderData.setTilex(64);
                renderData.setTiley(64);
                renderData.setEfra(this.endFrame);
                renderData.setFrame_step(1);
                renderData.setFramapto(100);
                renderData.setImages(100);
                ToolSettings toolSettings = serializer.writeData(ToolSettings.class);
                scene.setToolsettings(toolSettings.__io__addressof());
            };
        });
    }
}

