/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.frame;

import com.replaymod.render.frame.OpenGlFrame;
import com.replaymod.render.rendering.Frame;
import org.apache.commons.lang3.Validate;

public class CubicOpenGlFrame
implements Frame {
    private final OpenGlFrame left;
    private final OpenGlFrame right;
    private final OpenGlFrame front;
    private final OpenGlFrame back;
    private final OpenGlFrame top;
    private final OpenGlFrame bottom;

    public CubicOpenGlFrame(OpenGlFrame left, OpenGlFrame right, OpenGlFrame front, OpenGlFrame back, OpenGlFrame top, OpenGlFrame bottom) {
        Validate.isTrue((left.getFrameId() == right.getFrameId() && right.getFrameId() == front.getFrameId() && front.getFrameId() == back.getFrameId() && back.getFrameId() == top.getFrameId() && top.getFrameId() == bottom.getFrameId() ? 1 : 0) != 0, (String)"Frame ids do not match.", (Object[])new Object[0]);
        Validate.isTrue((left.getByteBuffer().remaining() == right.getByteBuffer().remaining() && right.getByteBuffer().remaining() == front.getByteBuffer().remaining() && front.getByteBuffer().remaining() == back.getByteBuffer().remaining() && back.getByteBuffer().remaining() == top.getByteBuffer().remaining() && top.getByteBuffer().remaining() == bottom.getByteBuffer().remaining() ? 1 : 0) != 0, (String)"Buffer size does not match.", (Object[])new Object[0]);
        this.left = left;
        this.right = right;
        this.front = front;
        this.back = back;
        this.top = top;
        this.bottom = bottom;
    }

    @Override
    public int getFrameId() {
        return this.left.getFrameId();
    }

    public OpenGlFrame getLeft() {
        return this.left;
    }

    public OpenGlFrame getRight() {
        return this.right;
    }

    public OpenGlFrame getFront() {
        return this.front;
    }

    public OpenGlFrame getBack() {
        return this.back;
    }

    public OpenGlFrame getTop() {
        return this.top;
    }

    public OpenGlFrame getBottom() {
        return this.bottom;
    }
}

