/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.rendering;

import com.replaymod.core.mixin.MinecraftAccessor;
import com.replaymod.core.versions.MCVer;
import com.replaymod.render.capturer.WorldRenderer;
import com.replaymod.render.frame.BitmapFrame;
import com.replaymod.render.processor.GlToAbsoluteDepthProcessor;
import com.replaymod.render.rendering.Channel;
import com.replaymod.render.rendering.Frame;
import com.replaymod.render.rendering.FrameCapturer;
import com.replaymod.render.rendering.FrameConsumer;
import com.replaymod.render.rendering.FrameProcessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;

public class Pipeline<R extends Frame, P extends Frame>
implements Runnable {
    private final WorldRenderer worldRenderer;
    private final FrameCapturer<R> capturer;
    private final FrameProcessor<R, P> processor;
    private final GlToAbsoluteDepthProcessor depthProcessor;
    private final FrameConsumer<P> consumer;
    private volatile boolean abort;

    public Pipeline(WorldRenderer worldRenderer, FrameCapturer<R> capturer, FrameProcessor<R, P> processor, FrameConsumer<P> consumer) {
        this.worldRenderer = worldRenderer;
        this.capturer = capturer;
        this.processor = processor;
        this.consumer = new ParallelSafeConsumer<P>(consumer);
        float near = 0.05f;
        float far = (Integer)MCVer.getMinecraft().options.renderDistance().get() * 16 * 4;
        this.depthProcessor = new GlToAbsoluteDepthProcessor(near, far);
    }

    @Override
    public synchronized void run() {
        int processors = Runtime.getRuntime().availableProcessors();
        int processThreads = Math.max(1, processors - 2);
        ThreadPoolExecutor processService = new ThreadPoolExecutor(processThreads, processThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue<Runnable>(2){

            @Override
            public boolean offer(Runnable runnable) {
                try {
                    this.put(runnable);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                return true;
            }
        }, new ThreadPoolExecutor.DiscardPolicy());
        Minecraft mc = MCVer.getMinecraft();
        while (!this.capturer.isDone() && !this.abort) {
            if (GLFW.glfwWindowShouldClose((long)mc.getWindow().getWindow()) || ((MinecraftAccessor)mc).getCrashReporter() != null) {
                processService.shutdown();
                return;
            }
            Map<Channel, R> rawFrame = this.capturer.process();
            if (rawFrame == null) continue;
            processService.submit(new ProcessTask(rawFrame));
        }
        processService.shutdown();
        try {
            processService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.worldRenderer.close();
            this.capturer.close();
            this.processor.close();
            this.consumer.close();
        }
        catch (Throwable t) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)t, (String)"Cleaning up rendering pipeline");
            throw new ReportedException(crashReport);
        }
    }

    public void cancel() {
        this.abort = true;
    }

    private static class ParallelSafeConsumer<P extends Frame>
    implements FrameConsumer<P> {
        private final FrameConsumer<P> inner;
        private int nextFrame;
        private final Object lock = new Object();

        private ParallelSafeConsumer(FrameConsumer<P> inner) {
            this.inner = inner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Map<Channel, P> channels) {
            if (this.inner.isParallelCapable()) {
                this.inner.consume(channels);
            } else {
                int frameId = ((Frame)channels.values().iterator().next()).getFrameId();
                Object object = this.lock;
                synchronized (object) {
                    while (this.nextFrame != frameId) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.inner.consume(channels);
                    ++this.nextFrame;
                    this.lock.notifyAll();
                }
            }
        }

        @Override
        public boolean isParallelCapable() {
            return true;
        }

        @Override
        public void close() throws IOException {
            this.inner.close();
        }
    }

    private class ProcessTask
    implements Runnable {
        private final Map<Channel, R> rawChannels;

        public ProcessTask(Map<Channel, R> rawChannels) {
            this.rawChannels = rawChannels;
        }

        @Override
        public void run() {
            try {
                HashMap processedChannels = new HashMap();
                for (Map.Entry entry : this.rawChannels.entrySet()) {
                    Object processedFrame = Pipeline.this.processor.process((Frame)entry.getValue());
                    if (entry.getKey() == Channel.DEPTH && processedFrame instanceof BitmapFrame) {
                        Pipeline.this.depthProcessor.process((BitmapFrame)processedFrame);
                    }
                    processedChannels.put(entry.getKey(), processedFrame);
                }
                if (processedChannels.isEmpty()) {
                    return;
                }
                Pipeline.this.consumer.consume(processedChannels);
            }
            catch (Throwable t) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)t, (String)"Processing frame");
                MCVer.getMinecraft().delayCrashRaw(crashReport);
            }
        }
    }
}

