/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.utils;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.replaymod.render.RenderSettings;
import com.replaymod.replaystudio.lib.guava.base.Optional;
import com.replaymod.replaystudio.pathing.PathingRegistry;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.pathing.serialize.TimelineSerialization;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.simplepathing.SPTimeline;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RenderJob {
    private Timeline timeline;
    private RenderSettings settings;

    public String getName() {
        return this.settings.getOutputFile().getName();
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public RenderSettings getSettings() {
        return this.settings;
    }

    public void setTimeline(Timeline timeline) {
        this.timeline = timeline;
    }

    public void setSettings(RenderSettings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderJob renderJob = (RenderJob)o;
        return this.timeline.equals(renderJob.timeline) && this.settings.equals(renderJob.settings);
    }

    public int hashCode() {
        return Objects.hash(this.timeline, this.settings);
    }

    public String toString() {
        return "RenderJob{timeline=" + String.valueOf(this.timeline) + ", settings=" + String.valueOf(this.settings) + "}";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<RenderJob> readQueue(ReplayFile replayFile) throws IOException {
        ReplayFile replayFile2 = replayFile;
        synchronized (replayFile2) {
            Optional<InputStream> optIn = replayFile.get("renderQueue.json");
            if (!optIn.isPresent()) {
                return new ArrayList<RenderJob>();
            }
            try (InputStream in = optIn.get();){
                ArrayList<RenderJob> arrayList;
                try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    ArrayList<RenderJob> jobs = (ArrayList<RenderJob>)new GsonBuilder().registerTypeAdapter(Timeline.class, (Object)new TimelineTypeAdapter()).create().fromJson((Reader)reader, new TypeToken<List<RenderJob>>(){}.getType());
                    if (jobs == null) {
                        jobs = new ArrayList<RenderJob>();
                    }
                    arrayList = jobs;
                }
                return arrayList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeQueue(ReplayFile replayFile, List<RenderJob> renderQueue) throws IOException {
        ReplayFile replayFile2 = replayFile;
        synchronized (replayFile2) {
            try (OutputStream out = replayFile.write("renderQueue.json");
                 OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
                new GsonBuilder().registerTypeAdapter(Timeline.class, (Object)new TimelineTypeAdapter()).create().toJson(renderQueue, (Appendable)writer);
            }
        }
    }

    private static class TimelineTypeAdapter
    extends TypeAdapter<Timeline> {
        private final TimelineSerialization serialization;

        public TimelineTypeAdapter(TimelineSerialization serialization) {
            this.serialization = serialization;
        }

        public TimelineTypeAdapter(PathingRegistry registry) {
            this(new TimelineSerialization(registry, null));
        }

        public TimelineTypeAdapter() {
            this(new SPTimeline());
        }

        public void write(JsonWriter out, Timeline value) throws IOException {
            out.value(this.serialization.serialize(Collections.singletonMap("", value)));
        }

        public Timeline read(JsonReader in) throws IOException {
            return this.serialization.deserialize(in.nextString()).get("");
        }
    }
}

