/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.Unpooled;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetOutput;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.mixin.MinecraftAccessor;
import com.replaymod.core.mixin.TimerAccessor;
import com.replaymod.core.utils.Restrictions;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.ReplaySender;
import com.replaymod.replay.Setting;
import com.replaymod.replay.camera.CameraEntity;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.util.Utils;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.versions.callbacks.PreTickCallback;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.payload.AdvancedOpenScreenPayload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@ChannelHandler.Sharable
public class FullReplaySender
extends ChannelInboundHandlerAdapter
implements ReplaySender {
    private static final List<Class> BAD_PACKETS = Arrays.asList(ClientboundBlockChangedAckPacket.class, ClientboundOpenBookPacket.class, ClientboundOpenScreenPacket.class, ClientboundUpdateRecipesPacket.class, ClientboundUpdateAdvancementsPacket.class, ClientboundSelectAdvancementsTabPacket.class, ClientboundSetCameraPacket.class, ClientboundSetTitleTextPacket.class, ClientboundSetHealthPacket.class, ClientboundHorseScreenOpenPacket.class, ClientboundContainerClosePacket.class, ClientboundContainerSetSlotPacket.class, ClientboundContainerSetDataPacket.class, ClientboundOpenSignEditorPacket.class, ClientboundAwardStatsPacket.class, ClientboundSetExperiencePacket.class, ClientboundPlayerAbilitiesPacket.class);
    private static int TP_DISTANCE_LIMIT = 128;
    private final ReplayHandler replayHandler;
    protected boolean asyncMode;
    protected int lastTimeStamp;
    protected int currentTimeStamp;
    protected ReplayFile replayFile;
    protected Channel channel;
    protected ReplayInputStream replayIn;
    protected PacketData nextPacket;
    private PacketTypeRegistry registry = MCVer.getPacketTypeRegistry(State.LOGIN);
    protected boolean startFromBeginning = true;
    protected boolean terminate;
    protected double replaySpeed = 1.0;
    protected boolean hasWorldLoaded;
    protected boolean inBundle;
    protected Minecraft mc = MCVer.getMinecraft();
    protected final int replayLength;
    protected int actualID = -1;
    protected boolean allowMovement;
    private final File tempResourcePackFolder = Files.createTempDir();
    private final EventHandler events = new EventHandler(this);
    private long realTimeStart;
    private double realTimeStartSpeed;
    private long desiredTimeStamp = -1L;
    private Runnable asyncSender = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!FullReplaySender.this.terminate) {
                    FullReplaySender fullReplaySender = FullReplaySender.this;
                    synchronized (fullReplaySender) {
                        if (FullReplaySender.this.replayIn == null) {
                            FullReplaySender.this.replayIn = FullReplaySender.this.replayFile.getPacketData(MCVer.getPacketTypeRegistry(State.LOGIN));
                        }
                        block8: while (true) {
                            try {
                                while (true) {
                                    long now;
                                    long expectedTime;
                                    if (FullReplaySender.this.paused() && FullReplaySender.this.hasWorldLoaded && !FullReplaySender.this.inBundle && !FullReplaySender.this.terminate && !FullReplaySender.this.startFromBeginning && FullReplaySender.this.desiredTimeStamp == -1L) {
                                        Thread.sleep(10L);
                                        continue;
                                    }
                                    if (FullReplaySender.this.terminate && !FullReplaySender.this.inBundle) {
                                        return;
                                    }
                                    if (FullReplaySender.this.startFromBeginning) break block8;
                                    if (FullReplaySender.this.nextPacket == null) {
                                        FullReplaySender.this.nextPacket = new PacketData(FullReplaySender.this.replayIn);
                                    }
                                    int nextTimeStamp = FullReplaySender.this.nextPacket.timestamp;
                                    if (!FullReplaySender.this.isHurrying() && FullReplaySender.this.hasWorldLoaded && !FullReplaySender.this.inBundle && (expectedTime = FullReplaySender.this.realTimeStart + (long)((double)nextTimeStamp / FullReplaySender.this.replaySpeed)) > (now = System.currentTimeMillis())) {
                                        Thread.sleep(expectedTime - now);
                                    }
                                    if (FullReplaySender.this.nextPacket.type == PacketType.Bundle) {
                                        FullReplaySender.this.inBundle = !FullReplaySender.this.inBundle;
                                    }
                                    FullReplaySender.this.channel.pipeline().fireChannelRead((Object)io.netty.buffer.Unpooled.wrappedBuffer((byte[])FullReplaySender.this.nextPacket.bytes));
                                    FullReplaySender.this.nextPacket = null;
                                    FullReplaySender.this.lastTimeStamp = nextTimeStamp;
                                    while (!FullReplaySender.this.channel.config().isAutoRead()) {
                                        Thread.sleep(0L, 100000);
                                    }
                                    if (!FullReplaySender.this.isHurrying() || (long)FullReplaySender.this.lastTimeStamp <= FullReplaySender.this.desiredTimeStamp || FullReplaySender.this.startFromBeginning) continue;
                                    FullReplaySender.this.desiredTimeStamp = -1L;
                                    FullReplaySender.this.replayHandler.moveCameraToTargetPosition();
                                    FullReplaySender.this.setReplaySpeed(0.0);
                                }
                            }
                            catch (EOFException eof) {
                                FullReplaySender.this.setReplaySpeed(0.0);
                                while (FullReplaySender.this.paused() && FullReplaySender.this.hasWorldLoaded && FullReplaySender.this.desiredTimeStamp == -1L && !FullReplaySender.this.terminate) {
                                    Thread.sleep(10L);
                                }
                                if (!FullReplaySender.this.terminate) break;
                                return;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                        FullReplaySender.this.hasWorldLoaded = false;
                        FullReplaySender.this.inBundle = false;
                        FullReplaySender.this.lastTimeStamp = 0;
                        FullReplaySender.this.registry = MCVer.getPacketTypeRegistry(State.LOGIN);
                        FullReplaySender.this.startFromBeginning = false;
                        FullReplaySender.this.nextPacket = null;
                        FullReplaySender.this.realTimeStart = System.currentTimeMillis();
                        if (FullReplaySender.this.replayIn != null) {
                            FullReplaySender.this.replayIn.close();
                            FullReplaySender.this.replayIn = null;
                        }
                        ReplayMod.instance.runSync(FullReplaySender.this.replayHandler::restartedReplay);
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private final ExecutorService syncSender = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "replaymod-sync-sender"));

    public FullReplaySender(ReplayHandler replayHandler, ReplayFile file) throws IOException {
        this.replayHandler = replayHandler;
        this.replayFile = file;
        this.replayLength = file.getMetaData().getDuration();
        this.events.register();
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    public void setAsyncMode(boolean asyncMode) {
        if (this.asyncMode == asyncMode) {
            return;
        }
        this.asyncMode = asyncMode;
        if (asyncMode) {
            this.terminate = false;
            new Thread(this.asyncSender, "replaymod-async-sender").start();
        } else {
            this.terminate = true;
        }
    }

    @Override
    public boolean isAsyncMode() {
        return this.asyncMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncModeAndWait() {
        if (!this.asyncMode) {
            return;
        }
        this.asyncMode = false;
        this.terminate = true;
        FullReplaySender fullReplaySender = this;
        synchronized (fullReplaySender) {
        }
    }

    @Override
    public int currentTimeStamp() {
        if (this.asyncMode && !this.paused()) {
            return (int)((double)(System.currentTimeMillis() - this.realTimeStart) * this.realTimeStartSpeed);
        }
        return this.lastTimeStamp;
    }

    public void terminateReplay() {
        if (this.terminate) {
            return;
        }
        this.terminate = true;
        this.syncSender.shutdown();
        this.events.unregister();
        try {
            this.channel.pipeline().fireChannelInactive();
            this.channel.pipeline().close();
            FileUtils.deleteDirectory((File)this.tempResourcePackFolder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.terminate && this.asyncMode) {
            return;
        }
        if (msg instanceof net.minecraft.network.protocol.Packet) {
            try {
                net.minecraft.network.protocol.Packet p = (net.minecraft.network.protocol.Packet)msg;
                if (p != null) {
                    if ((p = this.processPacket(p)) != null) {
                        super.channelRead(ctx, (Object)p);
                    }
                    this.maybeRemoveDeadEntities(p);
                    if (p instanceof ClientboundLevelChunkWithLightPacket) {
                        Runnable doLightUpdates = () -> {
                            ClientLevel world = this.mc.level;
                            if (world != null) {
                                while (!world.isLightUpdateQueueEmpty()) {
                                    world.pollLightUpdates();
                                }
                                LevelLightEngine provider = world.getChunkSource().getLightEngine();
                                while (provider.hasLightWork()) {
                                    provider.runLightUpdates();
                                }
                            }
                        };
                        if (this.mc.isSameThread()) {
                            doLightUpdates.run();
                        } else {
                            this.mc.tell(doLightUpdates);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void maybeRemoveDeadEntities(net.minecraft.network.protocol.Packet packet) {
        boolean relevantPacket;
        if (this.asyncMode) {
            return;
        }
        boolean bl = relevantPacket = packet instanceof ClientboundAddEntityPacket || packet instanceof ClientboundAddExperienceOrbPacket || packet instanceof ClientboundRemoveEntitiesPacket;
        if (!relevantPacket) {
            return;
        }
        this.mc.tell(() -> {
            ClientLevel world = this.mc.level;
            if (world != null) {
                this.removeDeadEntities(world);
            }
        });
    }

    private void removeDeadEntities(ClientLevel world) {
    }

    protected net.minecraft.network.protocol.Packet processPacket(net.minecraft.network.protocol.Packet p) throws Exception {
        String url;
        Component reason;
        String message;
        ClientboundCustomPayloadPacket packet;
        if (p instanceof ClientboundGameProfilePacket) {
            this.registry = this.registry.withLoginSuccess();
            return p;
        }
        if (p instanceof ClientboundFinishConfigurationPacket) {
            this.registry = this.registry.withState(State.PLAY);
            return p;
        }
        if (p instanceof ClientboundStartConfigurationPacket) {
            this.registry = this.registry.withState(State.CONFIGURATION);
            this.hasWorldLoaded = false;
            return p;
        }
        if (p instanceof ClientboundCustomPayloadPacket && Restrictions.PLUGIN_CHANNEL.equals((Object)(packet = (ClientboundCustomPayloadPacket)p).payload().type().id())) {
            String unknown = this.replayHandler.getRestrictions().handle(packet);
            if (unknown == null) {
                return null;
            }
            this.terminateReplay();
            ReplayMod.instance.runLater(() -> {
                try {
                    this.replayHandler.endReplay();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.mc.setScreen((Screen)new AlertScreen(() -> this.mc.setScreen(null), (Component)Component.translatable((String)"replaymod.error.unknownrestriction1"), (Component)Component.translatable((String)"replaymod.error.unknownrestriction2", (Object[])new Object[]{unknown})));
            });
        }
        if (p instanceof ClientboundDisconnectPacket && "Please update to view this replay.".equals(message = (reason = ((ClientboundDisconnectPacket)p).reason()).getString())) {
            return null;
        }
        if (BAD_PACKETS.contains(p.getClass())) {
            return null;
        }
        if (p instanceof ClientboundCustomPayloadPacket) {
            packet = (ClientboundCustomPayloadPacket)p;
            ResourceLocation channelName = packet.payload().type().id();
            String channelNameStr = channelName.toString();
            if (channelNameStr.startsWith("fabric-screen-handler-api-v")) {
                return null;
            }
            if (packet.payload() instanceof AdvancedOpenScreenPayload) {
                return null;
            }
        }
        if (p instanceof ClientboundResourcePackPushPacket && (url = (packet = (ClientboundResourcePackPushPacket)p).url()).startsWith("replay://")) {
            String hash;
            int id = Integer.parseInt(url.substring("replay://".length()));
            Map<Integer, String> index = this.replayFile.getResourcePackIndex();
            if (index != null && (hash = index.get(id)) != null) {
                File file = new File(this.tempResourcePackFolder, hash + ".zip");
                if (!file.exists()) {
                    IOUtils.copy((InputStream)this.replayFile.getResourcePack(hash).get(), (OutputStream)new FileOutputStream(file));
                }
                this.schedulePacketHandler(() -> this.lambda$processPacket$4((ClientboundResourcePackPushPacket)packet, file));
            }
            return null;
        }
        if (p instanceof ClientboundLoginPacket) {
            packet = (ClientboundLoginPacket)p;
            int entId = packet.playerId();
            this.schedulePacketHandler(() -> {
                this.allowMovement = true;
            });
            this.actualID = entId;
            entId = -1789435;
            p = new ClientboundLoginPacket(entId, packet.hardcore(), packet.levels(), packet.maxPlayers(), packet.chunkRadius(), packet.simulationDistance(), packet.reducedDebugInfo(), packet.showDeathScreen(), packet.doLimitedCrafting(), this.withSpectatorMode(packet.commonPlayerSpawnInfo()), packet.enforcesSecureChat());
        }
        if (p instanceof ClientboundRespawnPacket) {
            ClientboundRespawnPacket respawn = (ClientboundRespawnPacket)p;
            p = new ClientboundRespawnPacket(this.withSpectatorMode(respawn.commonPlayerSpawnInfo()), 0);
            this.schedulePacketHandler(() -> {
                this.allowMovement = true;
            });
        }
        if (p instanceof ClientboundPlayerPositionPacket) {
            final ClientboundPlayerPositionPacket ppl = (ClientboundPlayerPositionPacket)p;
            if (!this.hasWorldLoaded) {
                this.hasWorldLoaded = true;
            }
            ReplayMod.instance.runLater(() -> {
                if (this.mc.screen instanceof ReceivingLevelScreen) {
                    this.mc.setScreen(null);
                }
            });
            if (this.replayHandler.shouldSuppressCameraMovements()) {
                return null;
            }
            for (RelativeMovement relative : ppl.getRelativeArguments()) {
                if (relative != RelativeMovement.X && relative != RelativeMovement.Y && relative != RelativeMovement.Z) continue;
                return null;
            }
            this.schedulePacketHandler(new Runnable(){

                @Override
                public void run() {
                    if (FullReplaySender.this.mc.level == null || !FullReplaySender.this.mc.isSameThread()) {
                        ReplayMod.instance.runLater(this);
                        return;
                    }
                    CameraEntity cent = FullReplaySender.this.replayHandler.getCameraEntity();
                    if (!(FullReplaySender.this.allowMovement || Math.abs(cent.getX() - ppl.getX()) > (double)TP_DISTANCE_LIMIT || Math.abs(cent.getZ() - ppl.getZ()) > (double)TP_DISTANCE_LIMIT)) {
                        return;
                    }
                    FullReplaySender.this.allowMovement = false;
                    cent.setCameraPosition(ppl.getX(), ppl.getY(), ppl.getZ());
                    cent.setCameraRotation(ppl.getYRot(), ppl.getXRot(), cent.roll);
                }
            });
            return null;
        }
        if (p instanceof ClientboundGameEventPacket) {
            ClientboundGameEventPacket pg = (ClientboundGameEventPacket)p;
            if (!Arrays.asList(ClientboundGameEventPacket.START_RAINING, ClientboundGameEventPacket.STOP_RAINING, ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE).contains(pg.getEvent())) {
                return null;
            }
        }
        if ((p instanceof ClientboundSystemChatPacket || p instanceof ClientboundPlayerChatPacket || p instanceof ClientboundDisguisedChatPacket) && !ReplayModReplay.instance.getCore().getSettingsRegistry().get(Setting.SHOW_CHAT).booleanValue()) {
            return null;
        }
        if (this.asyncMode) {
            return this.processPacketAsync(p);
        }
        net.minecraft.network.protocol.Packet fp = p;
        this.mc.tell(() -> this.processPacketSync(fp));
        return p;
    }

    private CommonPlayerSpawnInfo withSpectatorMode(CommonPlayerSpawnInfo org) {
        return new CommonPlayerSpawnInfo(org.dimensionType(), org.dimension(), org.seed(), GameType.SPECTATOR, GameType.SPECTATOR, org.isDebug(), org.isFlat(), org.lastDeathLocation(), org.portalCooldown());
    }

    @Override
    public double getReplaySpeed() {
        if (!this.paused()) {
            return this.replaySpeed;
        }
        return 0.0;
    }

    @Override
    public void setReplaySpeed(double d) {
        if (d != 0.0) {
            this.replaySpeed = d;
            this.realTimeStartSpeed = d;
            this.realTimeStart = System.currentTimeMillis() - (long)((double)this.lastTimeStamp / d);
        }
        TimerAccessor timer = (TimerAccessor)((MinecraftAccessor)this.mc).getTimer();
        timer.setTickLength(50.0f / (float)d);
    }

    public boolean isHurrying() {
        return this.desiredTimeStamp != -1L;
    }

    public void stopHurrying() {
        this.desiredTimeStamp = -1L;
    }

    public long getDesiredTimestamp() {
        return this.desiredTimeStamp;
    }

    @Override
    public void jumpToTime(int millis) {
        Preconditions.checkState((boolean)this.asyncMode, (Object)"Can only jump in async mode. Use sendPacketsTill(int) instead.");
        if (millis < this.lastTimeStamp && !this.isHurrying()) {
            this.startFromBeginning = true;
        }
        this.desiredTimeStamp = millis;
    }

    protected net.minecraft.network.protocol.Packet processPacketAsync(net.minecraft.network.protocol.Packet p) {
        if (this.desiredTimeStamp - (long)this.lastTimeStamp > 1000L) {
            ClientboundAddEntityPacket pso;
            if (p instanceof ClientboundLevelParticlesPacket) {
                return null;
            }
            if (p instanceof ClientboundAddEntityPacket && (pso = (ClientboundAddEntityPacket)p).getType() == EntityType.FIREWORK_ROCKET) {
                return null;
            }
        }
        return p;
    }

    @Override
    public void sendPacketsTill(int timestamp) {
        Preconditions.checkState((!this.asyncMode ? 1 : 0) != 0, (Object)"This method cannot be used in async mode. Use jumpToTime(int) instead.");
        AtomicBoolean doneSending = new AtomicBoolean();
        this.syncSender.submit(() -> {
            try {
                this.doSendPacketsTill(timestamp);
            }
            finally {
                doneSending.set(true);
            }
        });
        while (!doneSending.get()) {
            this.executeTaskQueue();
            try {
                Thread.sleep(0L, 100000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        this.executeTaskQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendPacketsTill(int timestamp) {
        try {
            FullReplaySender fullReplaySender = this;
            synchronized (fullReplaySender) {
                if (timestamp == this.lastTimeStamp) {
                    return;
                }
                if (timestamp < this.lastTimeStamp) {
                    this.hasWorldLoaded = false;
                    this.inBundle = false;
                    this.lastTimeStamp = 0;
                    if (this.replayIn != null) {
                        this.replayIn.close();
                        this.replayIn = null;
                    }
                    this.registry = MCVer.getPacketTypeRegistry(State.LOGIN);
                    this.startFromBeginning = false;
                    this.nextPacket = null;
                    ReplayMod.instance.runSync(this.replayHandler::restartedReplay);
                }
                if (this.replayIn == null) {
                    this.replayIn = this.replayFile.getPacketData(MCVer.getPacketTypeRegistry(State.LOGIN));
                }
                block8: while (true) {
                    try {
                        block9: while (true) {
                            PacketData pd;
                            if (this.nextPacket != null) {
                                pd = this.nextPacket;
                                this.nextPacket = null;
                            } else {
                                pd = new PacketData(this.replayIn);
                            }
                            int nextTimeStamp = pd.timestamp;
                            if (nextTimeStamp > timestamp && !this.inBundle) {
                                this.nextPacket = pd;
                                break block8;
                            }
                            if (pd.type == PacketType.Bundle) {
                                this.inBundle = !this.inBundle;
                            }
                            this.channel.pipeline().fireChannelRead((Object)io.netty.buffer.Unpooled.wrappedBuffer((byte[])pd.bytes));
                            while (true) {
                                if (this.channel.config().isAutoRead()) continue block9;
                                Thread.sleep(0L, 100000);
                            }
                            break;
                        }
                    }
                    catch (EOFException eof) {
                        this.replayIn = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
                this.realTimeStart = System.currentTimeMillis() - (long)((double)timestamp / this.replaySpeed);
                this.lastTimeStamp = timestamp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeTaskQueue() {
        ((MCVer.MinecraftMethodAccessor)this.mc).replayModExecuteTaskQueue();
        ReplayMod.instance.runTasks();
    }

    private void schedulePacketHandler(Runnable runnable) {
        if (this.mc.isSameThread()) {
            runnable.run();
        } else {
            this.mc.execute(runnable);
        }
    }

    protected void processPacketSync(net.minecraft.network.protocol.Packet p) {
        if (p instanceof ClientboundForgetLevelChunkPacket) {
            ClientboundForgetLevelChunkPacket packet = (ClientboundForgetLevelChunkPacket)p;
            int x = packet.pos().x;
            int z = packet.pos().z;
            ClientLevel world = this.mc.level;
            ClientChunkCache chunkProvider = world.getChunkSource();
            LevelChunk chunk = chunkProvider.getChunkNow(x, z);
            if (chunk != null) {
                ArrayList<Entity> entitiesInChunk = new ArrayList<Entity>();
                for (Entity entity : this.mc.level.entitiesForRendering()) {
                    if (!entity.chunkPosition().equals((Object)chunk.getPos())) continue;
                    entitiesInChunk.add(entity);
                }
                for (Entity entity : entitiesInChunk) {
                    this.forcePositionForVehicleAndSelf(entity);
                }
            }
        }
    }

    private void forcePositionForVehicleAndSelf(Entity entity) {
        Vec3 prevPos;
        Entity vehicle = entity.getVehicle();
        if (vehicle != null) {
            this.forcePositionForVehicleAndSelf(vehicle);
        }
        int ticks = 0;
        do {
            prevPos = entity.position();
            if (vehicle != null) {
                entity.rideTick();
                continue;
            }
            entity.tick();
        } while (prevPos.distanceToSqr(entity.position()) > 1.0E-4 && ticks++ < 100);
    }

    private /* synthetic */ void lambda$processPacket$4(ClientboundResourcePackPushPacket packet, File file) {
        this.mc.getDownloadedPackSource().pushLocalPack(packet.id(), file.toPath());
    }

    private class EventHandler
    extends EventRegistrations {
        private EventHandler(FullReplaySender fullReplaySender) {
            this.on(PreTickCallback.EVENT, this::onWorldTick);
        }

        private void onWorldTick() {
        }
    }

    private static final class PacketData {
        private static final ByteBuf byteBuf = Unpooled.buffer();
        private static final NetOutput netOutput = new ByteBufNetOutput(byteBuf);
        private final int timestamp;
        private final byte[] bytes;
        private final PacketType type;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PacketData(ReplayInputStream in) throws IOException {
            if (ReplayMod.isMinimalMode()) {
                this.timestamp = Utils.readInt(in);
                int length = Utils.readInt(in);
                if (this.timestamp == -1 || length == -1) {
                    throw new EOFException();
                }
                this.bytes = new byte[length];
                IOUtils.readFully((InputStream)in, (byte[])this.bytes);
                this.type = PacketType.UnknownLogin;
            } else {
                com.replaymod.replaystudio.PacketData data = in.readPacket();
                if (data == null) {
                    throw new EOFException();
                }
                this.timestamp = (int)data.getTime();
                Packet packet = data.getPacket();
                this.type = packet.getType();
                if (packet.getId() == -1) {
                    this.bytes = new byte[0];
                    return;
                }
                ByteBuf byteBuf = PacketData.byteBuf;
                synchronized (byteBuf) {
                    PacketData.byteBuf.markReaderIndex();
                    PacketData.byteBuf.markWriterIndex();
                    netOutput.writeVarInt(packet.getId());
                    int idSize = PacketData.byteBuf.readableBytes();
                    int contentSize = packet.getBuf().readableBytes();
                    this.bytes = new byte[idSize + contentSize];
                    PacketData.byteBuf.readBytes(this.bytes, 0, idSize);
                    packet.getBuf().readBytes(this.bytes, idSize, contentSize);
                    PacketData.byteBuf.resetReaderIndex();
                    PacketData.byteBuf.resetWriterIndex();
                }
                packet.getBuf().release();
            }
        }
    }
}

