/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.versions.MCVer;
import de.johni0702.minecraft.gui.versions.Image;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;

public class NoGuiScreenshot {
    private final Image image;
    private final int width;
    private final int height;

    private NoGuiScreenshot(Image image, int width, int height) {
        this.image = image;
        this.width = width;
        this.height = height;
    }

    public Image getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static ListenableFuture<NoGuiScreenshot> take(final Minecraft mc, final int width, final int height) {
        final SettableFuture future = SettableFuture.create();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (future.isCancelled()) {
                    return;
                }
                int frameWidth = mc.getWindow().getWidth();
                int frameHeight = mc.getWindow().getHeight();
                boolean guiHidden = mc.options.hideGui;
                try {
                    mc.options.hideGui = true;
                    MCVer.pushMatrix();
                    RenderSystem.clear((int)16640, (boolean)true);
                    mc.getMainRenderTarget().bindWrite(true);
                    mc.gameRenderer.renderLevel(DeltaTracker.ONE);
                    mc.getMainRenderTarget().unbindWrite();
                    MCVer.popMatrix();
                    MCVer.pushMatrix();
                    mc.getMainRenderTarget().blitToScreen(frameWidth, frameHeight);
                    MCVer.popMatrix();
                }
                catch (Throwable t) {
                    future.setException(t);
                    return;
                }
                finally {
                    mc.options.hideGui = guiHidden;
                }
                try {
                    Image image = new Image(Screenshot.takeScreenshot((RenderTarget)mc.getMainRenderTarget()));
                    int imageWidth = image.getWidth();
                    int imageHeight = image.getHeight();
                    float scaleFactor = Math.max((float)width / (float)imageWidth, (float)height / (float)imageHeight);
                    int croppedWidth = Math.min(Math.max(0, (int)((float)width / scaleFactor)), imageWidth);
                    int croppedHeight = Math.min(Math.max(0, (int)((float)height / scaleFactor)), imageHeight);
                    int offsetX = (imageWidth - croppedWidth) / 2;
                    int offsetY = (imageHeight - croppedHeight) / 2;
                    image = image.scaledSubRect(offsetX, offsetY, croppedWidth, croppedHeight, width, height);
                    future.set((Object)new NoGuiScreenshot(image, width, height));
                }
                catch (Throwable t) {
                    future.setException(t);
                }
            }
        };
        ReplayMod.instance.runLater(runnable);
        return future;
    }
}

