/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay.camera;

import com.replaymod.replay.camera.CameraController;
import com.replaymod.replay.camera.CameraEntity;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector3f;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;

public class VanillaCameraController
implements CameraController {
    private static final int MAX_SPEED = 2000;
    private static final int MIN_SPEED = -1000;
    private static final Vector3f[] DIRECTIONS = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};
    private final KeyMapping[] bindings = new KeyMapping[6];
    private final CameraEntity camera;
    private int speed;

    public VanillaCameraController(Minecraft mc, CameraEntity camera) {
        this.camera = camera;
        Options gameSettings = mc.options;
        this.bindings[0] = gameSettings.keyUp;
        this.bindings[1] = gameSettings.keyDown;
        this.bindings[2] = gameSettings.keyLeft;
        this.bindings[3] = gameSettings.keyRight;
        this.bindings[4] = gameSettings.keyJump;
        this.bindings[5] = gameSettings.keyShift;
    }

    @Override
    public void update(float partialTicksPassed) {
        if (partialTicksPassed == 0.0f) {
            return;
        }
        Vector3f direction = new Vector3f(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < 6; ++i) {
            if (!this.bindings[i].isDown()) continue;
            Vector3f.add((Vector3f)direction, (Vector3f)DIRECTIONS[i], (Vector3f)direction);
        }
        if (direction.length() == 0.0f) {
            return;
        }
        direction.normalise(direction);
        double yawRadians = Math.toRadians(this.camera.getYRot());
        float yawSin = (float)Math.sin(yawRadians);
        float yawCos = (float)Math.cos(yawRadians);
        direction.set(direction.x * yawCos - direction.z * yawSin, direction.y, direction.x * yawSin + direction.z * yawCos);
        direction.scale((float)Math.pow(2.0, (double)this.speed / 300.0 + 1.0));
        direction.scale(partialTicksPassed / 20.0f);
        this.camera.moveCamera(direction.x, direction.y, direction.z);
    }

    @Override
    public void increaseSpeed() {
        this.speed = Math.min(2000, this.speed + 1);
    }

    @Override
    public void decreaseSpeed() {
        this.speed = Math.max(-1000, this.speed - 1);
    }
}

