/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.filter;

import com.google.gson.JsonObject;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.Studio;
import com.replaymod.replaystudio.filter.StreamFilter;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.packets.PacketJoinGame;
import com.replaymod.replaystudio.protocol.packets.PacketRespawn;
import com.replaymod.replaystudio.protocol.registry.DimensionType;
import com.replaymod.replaystudio.protocol.registry.Registries;
import com.replaymod.replaystudio.protocol.registry.RegistriesBuilder;
import com.replaymod.replaystudio.stream.PacketStream;
import java.io.IOException;

public class DimensionTracker
implements StreamFilter {
    private final RegistriesBuilder registriesBuilder = new RegistriesBuilder();
    public Registries registries = new Registries();
    public String dimension;
    public DimensionType dimensionType;

    @Override
    public void onStart(PacketStream stream) {
    }

    @Override
    public boolean onPacket(PacketStream stream, PacketData data) throws IOException {
        Packet packet = data.getPacket();
        PacketType type = packet.getType();
        switch (type) {
            case ConfigCustomPayload: 
            case ConfigSelectKnownPacks: 
            case ConfigRegistries: 
            case ConfigFinish: {
                this.registries = this.registriesBuilder.update(packet, this.registries);
                break;
            }
            case Respawn: {
                PacketRespawn packetRespawn = PacketRespawn.read(packet, this.registries);
                this.dimension = packetRespawn.dimension;
                this.dimensionType = packetRespawn.dimensionType;
                break;
            }
            case JoinGame: {
                PacketJoinGame packetJoinGame = PacketJoinGame.read(packet, this.registries);
                this.registries = packetJoinGame.registries;
                this.dimension = packetJoinGame.dimension;
                this.dimensionType = packetJoinGame.dimensionType;
                break;
            }
        }
        return true;
    }

    @Override
    public void onEnd(PacketStream stream, long timestamp) throws IOException {
    }

    @Override
    public String getName() {
        return "track_dimension";
    }

    @Override
    public void init(Studio studio, JsonObject config) {
    }
}

