/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata.EntityDataType;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EntityData {
    private int id;
    private EntityDataType metaType;
    private Object value;

    public EntityData(int id, EntityDataType metaType, @Nullable Object value) {
        this.id = id;
        this.metaType = metaType;
        this.value = this.checkValue(metaType, value);
    }

    public int id() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public EntityDataType dataType() {
        return this.metaType;
    }

    public void setDataType(EntityDataType metaType) {
        this.checkValue(metaType, this.value);
        this.metaType = metaType;
    }

    public <T> @Nullable T value() {
        return (T)this.value;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public void setValue(@Nullable Object value) {
        this.value = this.checkValue(this.metaType, value);
    }

    public void setTypeAndValue(EntityDataType metaType, @Nullable Object value) {
        this.value = this.checkValue(metaType, value);
        this.metaType = metaType;
    }

    private Object checkValue(EntityDataType metaType, @Nullable Object value) {
        Preconditions.checkNotNull(metaType);
        if (value != null && !metaType.type().getOutputClass().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(EntityData.jvmdowngrader$concat$checkValue$1(metaType, value, value.getClass().getSimpleName()));
        }
        return value;
    }

    @Deprecated
    public void setDataTypeUnsafe(EntityDataType type) {
        this.metaType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityData metadata = (EntityData)o;
        if (this.id != metadata.id) {
            return false;
        }
        if (this.metaType != metadata.metaType) {
            return false;
        }
        return Objects.equals(this.value, metadata.value);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.metaType.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return EntityData.jvmdowngrader$concat$toString$1(this.id, this.metaType, this.value);
    }

    private static String jvmdowngrader$concat$checkValue$1(EntityDataType entityDataType, Object object, String string) {
        return "Metadata value and metaType are incompatible. Type=" + entityDataType + ", value=" + object + " (" + string + ")";
    }

    private static String jvmdowngrader$concat$toString$1(int n, EntityDataType entityDataType, Object object) {
        return "Metadata{id=" + n + ", metaType=" + entityDataType + ", value=" + object + "}";
    }
}

