/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.data;

import Lcom.replaymod.replaystudio.lib.viaversion.libs.fastutil.ints.Int2ObjectMap;;
import Lcom.viaversion.nbt.tag.Tag;;
import Ljava.lang.String;;
import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.misc.HolderType;
import com.replaymod.replaystudio.lib.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.replaymod.replaystudio.lib.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.replaymod.replaystudio.lib.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.replaymod.replaystudio.lib.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import com.viaversion.nbt.tag.Tag;
import java.util.Arrays;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="assetName", type=String;.class), @RecordComponents.Value(name="itemId", type=I.class), @RecordComponents.Value(name="itemModelIndex", type=F.class), @RecordComponents.Value(name="overrideArmorMaterials", type=Int2ObjectMap;.class), @RecordComponents.Value(name="description", type=Tag;.class)})
@NestMembers(value={1.class})
public final class ArmorTrimMaterial
extends J_L_Record {
    private final String assetName;
    private final int itemId;
    private final float itemModelIndex;
    private final Int2ObjectMap<String> overrideArmorMaterials;
    private final Tag description;
    public static final HolderType<ArmorTrimMaterial> TYPE = new HolderType<ArmorTrimMaterial>(){

        @Override
        public ArmorTrimMaterial readDirect(ByteBuf buffer) {
            String assetName = (String)Types.STRING.read(buffer);
            int item = Types.VAR_INT.readPrimitive(buffer);
            float itemModelIndex = buffer.readFloat();
            int overrideArmorMaterialsSize = Types.VAR_INT.readPrimitive(buffer);
            Int2ObjectOpenHashMap<String> overrideArmorMaterials = new Int2ObjectOpenHashMap<String>(overrideArmorMaterialsSize);
            for (int i = 0; i < overrideArmorMaterialsSize; ++i) {
                int key = Types.VAR_INT.readPrimitive(buffer);
                String value = (String)Types.STRING.read(buffer);
                overrideArmorMaterials.put(key, value);
            }
            Tag description = (Tag)Types.TAG.read(buffer);
            return new ArmorTrimMaterial(assetName, item, itemModelIndex, overrideArmorMaterials, description);
        }

        @Override
        public void writeDirect(ByteBuf buffer, ArmorTrimMaterial value) {
            Types.STRING.write(buffer, value.assetName());
            Types.VAR_INT.writePrimitive(buffer, value.itemId());
            buffer.writeFloat(value.itemModelIndex());
            Types.VAR_INT.writePrimitive(buffer, value.overrideArmorMaterials().size());
            for (Int2ObjectMap.Entry entry : value.overrideArmorMaterials().int2ObjectEntrySet()) {
                Types.VAR_INT.writePrimitive(buffer, entry.getIntKey());
                Types.STRING.write(buffer, (String)entry.getValue());
            }
            Types.TAG.write(buffer, value.description());
        }
    };

    public ArmorTrimMaterial(String assetName, int itemId, float itemModelIndex, Int2ObjectMap<String> overrideArmorMaterials, Tag description) {
        this.assetName = assetName;
        this.itemId = itemId;
        this.itemModelIndex = itemModelIndex;
        this.overrideArmorMaterials = overrideArmorMaterials;
        this.description = description;
    }

    public ArmorTrimMaterial rewrite(Int2IntFunction idRewriteFunction) {
        return new ArmorTrimMaterial(this.assetName, idRewriteFunction.applyAsInt(this.itemId), this.itemModelIndex, this.overrideArmorMaterials, this.description);
    }

    @Override
    public final String toString() {
        return ArmorTrimMaterial.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return ArmorTrimMaterial.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return ArmorTrimMaterial.jvmdowngrader$equals$equals(this, o);
    }

    public String assetName() {
        return this.assetName;
    }

    public int itemId() {
        return this.itemId;
    }

    public float itemModelIndex() {
        return this.itemModelIndex;
    }

    public Int2ObjectMap<String> overrideArmorMaterials() {
        return this.overrideArmorMaterials;
    }

    public Tag description() {
        return this.description;
    }

    private static String jvmdowngrader$toString$toString(ArmorTrimMaterial armorTrimMaterial) {
        ArmorTrimMaterial armorTrimMaterial2 = armorTrimMaterial;
        return "ArmorTrimMaterial[" + "assetName=" + armorTrimMaterial.assetName + ", " + "itemId=" + armorTrimMaterial.itemId + ", " + "itemModelIndex=" + armorTrimMaterial.itemModelIndex + ", " + "overrideArmorMaterials=" + armorTrimMaterial.overrideArmorMaterials + ", " + "description=" + armorTrimMaterial.description + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(ArmorTrimMaterial armorTrimMaterial) {
        Object[] objectArray = new Object[]{armorTrimMaterial.assetName, armorTrimMaterial.itemId, Float.valueOf(armorTrimMaterial.itemModelIndex), armorTrimMaterial.overrideArmorMaterials, armorTrimMaterial.description};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(ArmorTrimMaterial armorTrimMaterial, Object object) {
        if (armorTrimMaterial == object) {
            return true;
        }
        if (object != null && object instanceof ArmorTrimMaterial) {
            ArmorTrimMaterial armorTrimMaterial2 = (ArmorTrimMaterial)object;
            if (Objects.equals(armorTrimMaterial.assetName, armorTrimMaterial2.assetName) && armorTrimMaterial.itemId == armorTrimMaterial2.itemId && armorTrimMaterial.itemModelIndex == armorTrimMaterial2.itemModelIndex && Objects.equals(armorTrimMaterial.overrideArmorMaterials, armorTrimMaterial2.overrideArmorMaterials) && Objects.equals(armorTrimMaterial.description, armorTrimMaterial2.description)) {
                return true;
            }
        }
        return false;
    }
}

