/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.data;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.data.ToolRule;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.replaymod.replaystudio.lib.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import java.util.Arrays;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="rules", type=ToolRule[].class), @RecordComponents.Value(name="defaultMiningSpeed", type=F.class), @RecordComponents.Value(name="damagePerBlock", type=I.class)})
@NestMembers(value={1.class})
public final class ToolProperties
extends J_L_Record {
    private final ToolRule[] rules;
    private final float defaultMiningSpeed;
    private final int damagePerBlock;
    public static final Type<ToolProperties> TYPE = new Type<ToolProperties>(ToolProperties.class){

        @Override
        public ToolProperties read(ByteBuf buffer) {
            ToolRule[] rules = (ToolRule[])ToolRule.ARRAY_TYPE.read(buffer);
            float defaultMiningSpeed = buffer.readFloat();
            int damagePerBlock = Types.VAR_INT.readPrimitive(buffer);
            return new ToolProperties(rules, defaultMiningSpeed, damagePerBlock);
        }

        @Override
        public void write(ByteBuf buffer, ToolProperties value) {
            ToolRule.ARRAY_TYPE.write(buffer, value.rules());
            buffer.writeFloat(value.defaultMiningSpeed());
            Types.VAR_INT.writePrimitive(buffer, value.damagePerBlock());
        }
    };

    public ToolProperties(ToolRule[] rules, float defaultMiningSpeed, int damagePerBlock) {
        this.rules = rules;
        this.defaultMiningSpeed = defaultMiningSpeed;
        this.damagePerBlock = damagePerBlock;
    }

    public ToolProperties rewrite(Int2IntFunction blockIdRewriter) {
        ToolRule[] rules = new ToolRule[this.rules.length];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = this.rules[i].rewrite(blockIdRewriter);
        }
        return new ToolProperties(rules, this.defaultMiningSpeed, this.damagePerBlock);
    }

    @Override
    public final String toString() {
        return ToolProperties.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return ToolProperties.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return ToolProperties.jvmdowngrader$equals$equals(this, o);
    }

    public ToolRule[] rules() {
        return this.rules;
    }

    public float defaultMiningSpeed() {
        return this.defaultMiningSpeed;
    }

    public int damagePerBlock() {
        return this.damagePerBlock;
    }

    private static String jvmdowngrader$toString$toString(ToolProperties toolProperties) {
        ToolProperties toolProperties2 = toolProperties;
        return "ToolProperties[" + "rules=" + toolProperties.rules + ", " + "defaultMiningSpeed=" + toolProperties.defaultMiningSpeed + ", " + "damagePerBlock=" + toolProperties.damagePerBlock + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(ToolProperties toolProperties) {
        Object[] objectArray = new Object[]{toolProperties.rules, Float.valueOf(toolProperties.defaultMiningSpeed), toolProperties.damagePerBlock};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(ToolProperties toolProperties, Object object) {
        if (toolProperties == object) {
            return true;
        }
        if (object != null && object instanceof ToolProperties) {
            ToolProperties toolProperties2 = (ToolProperties)object;
            if (Objects.equals(toolProperties.rules, toolProperties2.rules) && toolProperties.defaultMiningSpeed == toolProperties2.defaultMiningSpeed && toolProperties.damagePerBlock == toolProperties2.damagePerBlock) {
                return true;
            }
        }
        return false;
    }
}

