/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.type.types;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;

public class IntArrayType
extends Type<int[]> {
    private final int length;

    public IntArrayType(int length) {
        super(int[].class);
        this.length = length;
    }

    public IntArrayType() {
        super(int[].class);
        this.length = -1;
    }

    @Override
    public void write(ByteBuf buffer, int[] object) {
        if (this.length != -1) {
            Preconditions.checkArgument(this.length == object.length, "Length does not match expected length");
        } else {
            Types.VAR_INT.writePrimitive(buffer, object.length);
        }
        for (int i : object) {
            buffer.writeInt(i);
        }
    }

    @Override
    public int[] read(ByteBuf buffer) {
        int length = this.length == -1 ? Types.VAR_INT.readPrimitive(buffer) : this.length;
        Preconditions.checkArgument(buffer.isReadable(length), "Length is fewer than readable bytes");
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = buffer.readInt();
        }
        return array;
    }
}

