/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.type.types;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.api.type.TypeConverter;

public class VarLongType
extends Type<Long>
implements TypeConverter<Long> {
    public VarLongType() {
        super("VarLong", Long.class);
    }

    public long readPrimitive(ByteBuf buffer) {
        byte in;
        long out = 0L;
        int bytes = 0;
        do {
            in = buffer.readByte();
            out |= (long)(in & 0x7F) << bytes++ * 7;
            if (bytes <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((in & 0x80) == 128);
        return out;
    }

    public void writePrimitive(ByteBuf buffer, long object) {
        do {
            int part = (int)(object & 0x7FL);
            if ((object >>>= 7) != 0L) {
                part |= 0x80;
            }
            buffer.writeByte(part);
        } while (object != 0L);
    }

    @Override
    @Deprecated
    public Long read(ByteBuf buffer) {
        return this.readPrimitive(buffer);
    }

    @Override
    @Deprecated
    public void write(ByteBuf buffer, Long object) {
        this.writePrimitive(buffer, object);
    }

    @Override
    public Long from(Object o) {
        if (o instanceof Number) {
            Number number = (Number)o;
            return number.longValue();
        }
        if (o instanceof Boolean) {
            Boolean boo = (Boolean)o;
            return boo != false ? 1L : 0L;
        }
        throw new UnsupportedOperationException();
    }
}

