/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.protocols.v1_18_2to1_19.rewriter;

import com.replaymod.replaystudio.lib.guava.collect.Maps;
import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.data.ParticleMappings;
import com.replaymod.replaystudio.lib.viaversion.api.data.entity.DimensionData;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.BlockPosition;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.Particle;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entities.EntityType;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entities.EntityTypes1_19;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata.EntityData;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.remapper.PacketHandler;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.remapper.PacketHandlers;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.version.Types1_18;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.version.Types1_19;
import com.replaymod.replaystudio.lib.viaversion.data.entity.DimensionDataImpl;
import com.replaymod.replaystudio.lib.viaversion.libs.gson.JsonElement;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_17_1to1_18.packet.ClientboundPackets1_18;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_18_2to1_19.Protocol1_18_2To1_19;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_18_2to1_19.packet.ClientboundPackets1_19;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_18_2to1_19.storage.DimensionRegistryStorage;
import com.replaymod.replaystudio.lib.viaversion.rewriter.EntityRewriter;
import com.replaymod.replaystudio.lib.viaversion.util.Key;
import com.replaymod.replaystudio.lib.viaversion.util.Pair;
import com.replaymod.replaystudio.lib.viaversion.util.TagUtil;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.NumberTag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={6.class, 5.class, 4.class, 3.class, 2.class, 1.class})
public final class EntityPacketRewriter1_19
extends EntityRewriter<ClientboundPackets1_18, Protocol1_18_2To1_19> {
    public EntityPacketRewriter1_19(Protocol1_18_2To1_19 protocol) {
        super(protocol);
    }

    @Override
    public void registerPackets() {
        this.registerTracker(ClientboundPackets1_18.ADD_PLAYER, EntityTypes1_19.PLAYER);
        this.registerSetEntityData(ClientboundPackets1_18.SET_ENTITY_DATA, Types1_18.ENTITY_DATA_LIST, Types1_19.ENTITY_DATA_LIST);
        this.registerRemoveEntities(ClientboundPackets1_18.REMOVE_ENTITIES);
        ((Protocol1_18_2To1_19)this.protocol).registerClientbound(ClientboundPackets1_18.ADD_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.map(Types.UUID);
                this.map(Types.VAR_INT);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.BYTE);
                this.map(Types.BYTE);
                this.handler(wrapper -> {
                    byte yaw = wrapper.get(Types.BYTE, 1);
                    wrapper.write(Types.BYTE, yaw);
                });
                this.map((Type)Types.INT, Types.VAR_INT);
                this.handler(EntityPacketRewriter1_19.this.trackerHandler());
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Types.VAR_INT, 0);
                    EntityType entityType = EntityPacketRewriter1_19.this.tracker(wrapper.user()).entityType(entityId);
                    if (entityType == EntityTypes1_19.FALLING_BLOCK) {
                        wrapper.set(Types.VAR_INT, 2, ((Protocol1_18_2To1_19)EntityPacketRewriter1_19.this.protocol).getMappingData().getNewBlockStateId(wrapper.get(Types.VAR_INT, 2)));
                    }
                });
            }
        });
        ((Protocol1_18_2To1_19)this.protocol).registerClientbound(ClientboundPackets1_18.ADD_PAINTING, ClientboundPackets1_19.ADD_ENTITY, (PacketHandler)new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.map(Types.UUID);
                this.handler(wrapper -> {
                    wrapper.write(Types.VAR_INT, EntityTypes1_19.PAINTING.getId());
                    int motive = wrapper.read(Types.VAR_INT);
                    BlockPosition blockPosition = wrapper.read(Types.BLOCK_POSITION1_14);
                    byte direction = wrapper.read(Types.BYTE);
                    wrapper.write(Types.DOUBLE, (double)blockPosition.x() + 0.5);
                    wrapper.write(Types.DOUBLE, (double)blockPosition.y() + 0.5);
                    wrapper.write(Types.DOUBLE, (double)blockPosition.z() + 0.5);
                    wrapper.write(Types.BYTE, (byte)0);
                    wrapper.write(Types.BYTE, (byte)0);
                    wrapper.write(Types.BYTE, (byte)0);
                    wrapper.write(Types.VAR_INT, EntityPacketRewriter1_19.this.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_18_2to1_19_rewriter_EntityPacketRewriter1_19$to3dId(direction));
                    wrapper.write(Types.SHORT, (short)0);
                    wrapper.write(Types.SHORT, (short)0);
                    wrapper.write(Types.SHORT, (short)0);
                    wrapper.send(Protocol1_18_2To1_19.class);
                    wrapper.cancel();
                    PacketWrapper metaPacket = wrapper.create(ClientboundPackets1_19.SET_ENTITY_DATA);
                    metaPacket.write(Types.VAR_INT, wrapper.get(Types.VAR_INT, 0));
                    ArrayList<EntityData> metadata = new ArrayList<EntityData>();
                    metadata.add(new EntityData(8, Types1_19.ENTITY_DATA_TYPES.paintingVariantType, ((Protocol1_18_2To1_19)EntityPacketRewriter1_19.this.protocol).getMappingData().getPaintingMappings().getNewIdOrDefault(motive, 0)));
                    metaPacket.write(Types1_19.ENTITY_DATA_LIST, metadata);
                    metaPacket.send(Protocol1_18_2To1_19.class);
                });
            }
        });
        ((Protocol1_18_2To1_19)this.protocol).registerClientbound(ClientboundPackets1_18.ADD_MOB, ClientboundPackets1_19.ADD_ENTITY, (PacketHandler)new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.map(Types.UUID);
                this.map(Types.VAR_INT);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.handler(wrapper -> {
                    byte yaw = wrapper.read(Types.BYTE);
                    byte pitch = wrapper.read(Types.BYTE);
                    wrapper.write(Types.BYTE, pitch);
                    wrapper.write(Types.BYTE, yaw);
                });
                this.map(Types.BYTE);
                this.create(Types.VAR_INT, 0);
                this.map(Types.SHORT);
                this.map(Types.SHORT);
                this.map(Types.SHORT);
                this.handler(EntityPacketRewriter1_19.this.trackerHandler());
            }
        });
        ((Protocol1_18_2To1_19)this.protocol).registerClientbound(ClientboundPackets1_18.UPDATE_MOB_EFFECT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.map(Types.VAR_INT);
                this.map(Types.BYTE);
                this.map(Types.VAR_INT);
                this.map(Types.BYTE);
                this.create(Types.OPTIONAL_NAMED_COMPOUND_TAG, null);
            }
        });
        ((Protocol1_18_2To1_19)this.protocol).registerClientbound(ClientboundPackets1_18.LOGIN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.INT);
                this.map(Types.BOOLEAN);
                this.map(Types.BYTE);
                this.map(Types.BYTE);
                this.map(Types.STRING_ARRAY);
                this.map(Types.NAMED_COMPOUND_TAG);
                this.handler(wrapper -> {
                    CompoundTag tag = wrapper.get(Types.NAMED_COMPOUND_TAG, 0);
                    tag.put("minecraft:chat_type", ((Protocol1_18_2To1_19)EntityPacketRewriter1_19.this.protocol).getMappingData().chatRegistry());
                    ListTag<CompoundTag> dimensions = TagUtil.getRegistryEntries(tag, "dimension_type");
                    HashMap<String, DimensionData> dimensionDataMap = new HashMap<String, DimensionData>(dimensions.size());
                    HashMap<CompoundTag, String> dimensionsMap = new HashMap<CompoundTag, String>(dimensions.size());
                    for (CompoundTag dimension : dimensions) {
                        NumberTag idTag = dimension.getNumberTag("id");
                        CompoundTag element = dimension.getCompoundTag("element");
                        String name = dimension.getStringTag("name").getValue();
                        EntityPacketRewriter1_19.this.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_18_2to1_19_rewriter_EntityPacketRewriter1_19$addMonsterSpawnData(element);
                        dimensionDataMap.put(Key.stripMinecraftNamespace(name), new DimensionDataImpl(idTag.asInt(), element));
                        dimensionsMap.put(element.copy(), name);
                    }
                    EntityPacketRewriter1_19.this.tracker(wrapper.user()).setDimensions(dimensionDataMap);
                    DimensionRegistryStorage registryStorage = wrapper.user().get(DimensionRegistryStorage.class);
                    registryStorage.setDimensions(dimensionsMap);
                    EntityPacketRewriter1_19.this.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_18_2to1_19_rewriter_EntityPacketRewriter1_19$writeDimensionKey(wrapper, registryStorage);
                });
                this.map(Types.STRING);
                this.map(Types.LONG);
                this.map(Types.VAR_INT);
                this.map(Types.VAR_INT);
                this.map(Types.VAR_INT);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.create(Types.OPTIONAL_GLOBAL_POSITION, null);
                this.handler(EntityPacketRewriter1_19.this.playerTrackerHandler());
                this.handler(EntityPacketRewriter1_19.this.worldDataTrackerHandlerByKey());
                this.handler(EntityPacketRewriter1_19.this.biomeSizeTracker());
                this.handler(wrapper -> {
                    PacketWrapper displayPreviewPacket = wrapper.create(ClientboundPackets1_19.SET_DISPLAY_CHAT_PREVIEW);
                    displayPreviewPacket.write(Types.BOOLEAN, false);
                    displayPreviewPacket.scheduleSend(Protocol1_18_2To1_19.class);
                });
            }
        });
        ((Protocol1_18_2To1_19)this.protocol).registerClientbound(ClientboundPackets1_18.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> EntityPacketRewriter1_19.this.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_18_2to1_19_rewriter_EntityPacketRewriter1_19$writeDimensionKey(wrapper, wrapper.user().get(DimensionRegistryStorage.class)));
                this.map(Types.STRING);
                this.map(Types.LONG);
                this.map(Types.UNSIGNED_BYTE);
                this.map(Types.BYTE);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.create(Types.OPTIONAL_GLOBAL_POSITION, null);
                this.handler(EntityPacketRewriter1_19.this.worldDataTrackerHandlerByKey());
            }
        });
        ((Protocol1_18_2To1_19)this.protocol).registerClientbound(ClientboundPackets1_18.PLAYER_INFO, wrapper -> {
            int action = wrapper.passthrough(Types.VAR_INT);
            int entries = wrapper.passthrough(Types.VAR_INT);
            for (int i = 0; i < entries; ++i) {
                wrapper.passthrough(Types.UUID);
                if (action == 0) {
                    wrapper.passthrough(Types.STRING);
                    int properties = wrapper.passthrough(Types.VAR_INT);
                    for (int j = 0; j < properties; ++j) {
                        wrapper.passthrough(Types.STRING);
                        wrapper.passthrough(Types.STRING);
                        wrapper.passthrough(Types.OPTIONAL_STRING);
                    }
                    wrapper.passthrough(Types.VAR_INT);
                    wrapper.passthrough(Types.VAR_INT);
                    JsonElement displayName = wrapper.read(Types.OPTIONAL_COMPONENT);
                    if (!Protocol1_18_2To1_19.isTextComponentNull(displayName)) {
                        wrapper.write(Types.OPTIONAL_COMPONENT, displayName);
                    } else {
                        wrapper.write(Types.OPTIONAL_COMPONENT, null);
                    }
                    wrapper.write(Types.OPTIONAL_PROFILE_KEY, null);
                    continue;
                }
                if (action == 1 || action == 2) {
                    wrapper.passthrough(Types.VAR_INT);
                    continue;
                }
                if (action != 3) continue;
                JsonElement displayName = wrapper.read(Types.OPTIONAL_COMPONENT);
                if (!Protocol1_18_2To1_19.isTextComponentNull(displayName)) {
                    wrapper.write(Types.OPTIONAL_COMPONENT, displayName);
                    continue;
                }
                wrapper.write(Types.OPTIONAL_COMPONENT, null);
            }
        });
    }

    private void writeDimensionKey(PacketWrapper wrapper, DimensionRegistryStorage registryStorage) {
        CompoundTag currentDimension = wrapper.read(Types.NAMED_COMPOUND_TAG);
        this.addMonsterSpawnData(currentDimension);
        String dimensionKey = registryStorage.dimensionKey(currentDimension);
        if (dimensionKey == null) {
            if (!Via.getConfig().isSuppressConversionWarnings()) {
                ((Protocol1_18_2To1_19)this.protocol).getLogger().warning(EntityPacketRewriter1_19.jvmdowngrader$concat$writeDimensionKey$1(currentDimension, registryStorage.dimensions()));
            }
            dimensionKey = (String)((Map.Entry)registryStorage.dimensions().entrySet().stream().map(it -> new Pair((Map.Entry)it, Maps.difference(currentDimension.getValue(), ((CompoundTag)it.getKey()).getValue()).entriesInCommon())).filter(it -> ((Map)it.value()).containsKey("min_y") && ((Map)it.value()).containsKey("height")).max(Comparator.comparingInt(it -> ((Map)it.value()).size())).orElseThrow(() -> new IllegalArgumentException(EntityPacketRewriter1_19.jvmdowngrader$concat$lambda$writeDimensionKey$4$1(currentDimension))).key()).getValue();
        }
        wrapper.write(Types.STRING, dimensionKey);
    }

    private int to3dId(int id) {
        int n;
        switch (id) {
            case -1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException(EntityPacketRewriter1_19.jvmdowngrader$concat$to3dId$1(id));
            }
        }
        return n;
    }

    private void addMonsterSpawnData(CompoundTag dimension) {
        dimension.put("monster_spawn_block_light_limit", new IntTag(0));
        dimension.put("monster_spawn_light_level", new IntTag(11));
    }

    @Override
    protected void registerRewrites() {
        this.filter().mapDataType(Types1_19.ENTITY_DATA_TYPES::byId);
        this.filter().dataType(Types1_19.ENTITY_DATA_TYPES.particleType).handler((event, meta) -> {
            Particle particle = (Particle)meta.getValue();
            ParticleMappings particleMappings = ((Protocol1_18_2To1_19)this.protocol).getMappingData().getParticleMappings();
            if (particle.id() == particleMappings.id("vibration")) {
                particle.getArguments().remove(0);
                String resourceLocation = Key.stripMinecraftNamespace((String)particle.getArgument(0).getValue());
                if (resourceLocation.equals("entity")) {
                    particle.getArguments().add(2, new Particle.ParticleData<Float>(Types.FLOAT, Float.valueOf(0.0f)));
                }
            }
            this.rewriteParticle(event.user(), particle);
        });
        this.registerEntityDataTypeHandler(Types1_19.ENTITY_DATA_TYPES.itemType, Types1_19.ENTITY_DATA_TYPES.optionalBlockStateType, null);
        this.registerBlockStateHandler(EntityTypes1_19.ABSTRACT_MINECART, 11);
        this.filter().type(EntityTypes1_19.CAT).index(19).mapDataType(typeId -> Types1_19.ENTITY_DATA_TYPES.catVariantType);
    }

    @Override
    public void onMappingDataLoaded() {
        this.mapTypes();
    }

    @Override
    public EntityType typeFromId(int type) {
        return EntityTypes1_19.getTypeFromId(type);
    }

    void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_18_2to1_19_rewriter_EntityPacketRewriter1_19$writeDimensionKey(PacketWrapper packetWrapper, DimensionRegistryStorage dimensionRegistryStorage) {
        this.writeDimensionKey(packetWrapper, dimensionRegistryStorage);
    }

    int jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_18_2to1_19_rewriter_EntityPacketRewriter1_19$to3dId(int n) {
        return this.to3dId(n);
    }

    void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_18_2to1_19_rewriter_EntityPacketRewriter1_19$addMonsterSpawnData(CompoundTag compoundTag) {
        this.addMonsterSpawnData(compoundTag);
    }

    private static String jvmdowngrader$concat$writeDimensionKey$1(CompoundTag compoundTag, Map map) {
        return "The server tried to send dimension data from a dimension the client wasn't told about on join. Plugins and mods have to make sure they are not creating new dimension types while players are online, and proxies need to make sure they don't scramble dimension data. Received dimension: " + compoundTag + ". Known dimensions: " + map;
    }

    private static String jvmdowngrader$concat$to3dId$1(int n) {
        return "Unknown 2d id: " + n;
    }

    private static String jvmdowngrader$concat$lambda$writeDimensionKey$4$1(CompoundTag compoundTag) {
        return "Dimension not found in registry data from join packet: " + compoundTag;
    }
}

