/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_3to1_20_5.rewriter;

import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.connection.UserConnection;
import com.replaymod.replaystudio.lib.viaversion.api.data.entity.DimensionData;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.Particle;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.RegistryEntry;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entities.EntityType;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entities.EntityTypes1_20_5;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata.EntityData;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.Item;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.remapper.PacketHandlers;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.version.Types1_20_3;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.version.Types1_20_5;
import com.replaymod.replaystudio.lib.viaversion.libs.fastutil.ints.IntArraySet;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_2to1_20_3.packet.ClientboundConfigurationPackets1_20_3;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_2to1_20_3.packet.ClientboundPacket1_20_3;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_2to1_20_3.packet.ClientboundPackets1_20_3;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_3to1_20_5.Protocol1_20_3To1_20_5;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_3to1_20_5.data.Attributes1_20_5;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_3to1_20_5.data.BannerPatterns1_20_5;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_3to1_20_5.data.DamageTypes1_20_3;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_3to1_20_5.packet.ClientboundConfigurationPackets1_20_5;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_3to1_20_5.packet.ClientboundPackets1_20_5;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20_3to1_20_5.storage.AcknowledgedMessagesStorage;
import com.replaymod.replaystudio.lib.viaversion.rewriter.EntityRewriter;
import com.replaymod.replaystudio.lib.viaversion.rewriter.entitydata.EntityDataHandler;
import com.replaymod.replaystudio.lib.viaversion.util.Key;
import com.replaymod.replaystudio.lib.viaversion.util.TagUtil;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public final class EntityPacketRewriter1_20_5
extends EntityRewriter<ClientboundPacket1_20_3, Protocol1_20_3To1_20_5> {
    private static final UUID CREATIVE_BLOCK_INTERACTION_RANGE = UUID.fromString("736565d2-e1a7-403d-a3f8-1aeb3e302542");
    private static final UUID CREATIVE_ENTITY_INTERACTION_RANGE = UUID.fromString("98491ef6-97b1-4584-ae82-71a8cc85cf73");
    private static final int CREATIVE_MODE_ID = 1;

    public EntityPacketRewriter1_20_5(Protocol1_20_3To1_20_5 protocol) {
        super(protocol);
    }

    @Override
    public void registerPackets() {
        this.registerTrackerWithData1_19(ClientboundPackets1_20_3.ADD_ENTITY, EntityTypes1_20_5.FALLING_BLOCK);
        this.registerSetEntityData(ClientboundPackets1_20_3.SET_ENTITY_DATA, Types1_20_3.ENTITY_DATA_LIST, Types1_20_5.ENTITY_DATA_LIST);
        this.registerRemoveEntities(ClientboundPackets1_20_3.REMOVE_ENTITIES);
        ((Protocol1_20_3To1_20_5)this.protocol).registerClientbound(ClientboundConfigurationPackets1_20_3.REGISTRY_DATA, wrapper -> {
            PacketWrapper knownPacksPacket = wrapper.create(ClientboundConfigurationPackets1_20_5.SELECT_KNOWN_PACKS);
            knownPacksPacket.write(Types.VAR_INT, 0);
            knownPacksPacket.send(Protocol1_20_3To1_20_5.class);
            CompoundTag registryData = wrapper.read(Types.COMPOUND_TAG);
            this.cacheDimensionData(wrapper.user(), registryData);
            this.trackBiomeSize(wrapper.user(), registryData);
            ListTag<CompoundTag> dimensionTypes = TagUtil.getRegistryEntries(registryData, "dimension_type");
            for (CompoundTag compoundTag : dimensionTypes) {
                CompoundTag elementTag = compoundTag.getCompoundTag("element");
                CompoundTag monsterSpawnLightLevel = elementTag.getCompoundTag("monster_spawn_light_level");
                if (monsterSpawnLightLevel == null) continue;
                CompoundTag value = (CompoundTag)monsterSpawnLightLevel.removeUnchecked("value");
                monsterSpawnLightLevel.putInt("min_inclusive", value.getInt("min_inclusive"));
                monsterSpawnLightLevel.putInt("max_inclusive", value.getInt("max_inclusive"));
            }
            ListTag<CompoundTag> biomes = TagUtil.getRegistryEntries(registryData, "worldgen/biome");
            for (CompoundTag biome : biomes) {
                CompoundTag effects = biome.getCompoundTag("element").getCompoundTag("effects");
                this.checkSoundTag(effects.getCompoundTag("mood_sound"), "sound");
                this.checkSoundTag(effects.getCompoundTag("additions_sound"), "sound");
                this.checkSoundTag(effects.getCompoundTag("music"), "sound");
                this.checkSoundTag(effects, "ambient_sound");
                CompoundTag particle = effects.getCompoundTag("particle");
                if (particle == null) continue;
                CompoundTag particleOptions = particle.getCompoundTag("options");
                String particleType = particleOptions.getString("type");
                this.updateParticleFormat(particleOptions, Key.stripMinecraftNamespace(particleType));
            }
            for (Map.Entry<String, Tag> entry : registryData.entrySet()) {
                CompoundTag entryTag = (CompoundTag)entry.getValue();
                String type = entryTag.getString("type");
                ListTag<CompoundTag> valueTag = entryTag.getListTag("value", CompoundTag.class);
                RegistryEntry[] registryEntries = new RegistryEntry[valueTag.stream().map(e -> e.getInt("id")).distinct().toArray().length];
                boolean requiresDummyValues = false;
                int highestId = -1;
                IntArraySet ids = new IntArraySet();
                for (CompoundTag tag : valueTag) {
                    String name = tag.getString("name");
                    int id = tag.getInt("id");
                    if (ids.add(id)) {
                        highestId = Math.max(highestId, id);
                        if (id >= registryEntries.length) {
                            registryEntries = Arrays.copyOf(registryEntries, Math.max(registryEntries.length * 2, id + 1));
                            requiresDummyValues = true;
                        }
                    }
                    registryEntries[id] = new RegistryEntry(name, tag.get("element"));
                }
                if (Key.stripMinecraftNamespace(type).equals("damage_type")) {
                    registryEntries = Arrays.copyOf(registryEntries, ++highestId + 1);
                    CompoundTag spitData = new CompoundTag();
                    spitData.putString("scaling", "when_caused_by_living_non_player");
                    spitData.putString("message_id", "mob");
                    spitData.putFloat("exhaustion", 0.1f);
                    registryEntries[highestId] = new RegistryEntry("minecraft:spit", spitData);
                    Set registryEntryKeys = Arrays.stream(registryEntries).map(e -> Key.stripMinecraftNamespace(e.key())).collect(Collectors.toSet());
                    for (String key : DamageTypes1_20_3.keys()) {
                        if (registryEntryKeys.contains(key)) continue;
                        registryEntries = Arrays.copyOf(registryEntries, ++highestId + 1);
                        registryEntries[highestId] = new RegistryEntry(Key.namespaced(key), DamageTypes1_20_3.get(key));
                    }
                }
                if (requiresDummyValues) {
                    int finalLength = highestId + 1;
                    if (registryEntries.length != finalLength) {
                        registryEntries = Arrays.copyOf(registryEntries, finalLength);
                    }
                    this.replaceNullValues(registryEntries);
                }
                PacketWrapper registryPacket = wrapper.create(ClientboundConfigurationPackets1_20_5.REGISTRY_DATA);
                registryPacket.write(Types.STRING, type);
                registryPacket.write(Types.REGISTRY_ENTRY_ARRAY, registryEntries);
                registryPacket.send(Protocol1_20_3To1_20_5.class);
            }
            wrapper.cancel();
            PacketWrapper packetWrapper = wrapper.create(ClientboundConfigurationPackets1_20_5.REGISTRY_DATA);
            packetWrapper.write(Types.STRING, "minecraft:wolf_variant");
            CompoundTag paleWolf = new CompoundTag();
            paleWolf.putString("wild_texture", "entity/wolf/wolf");
            paleWolf.putString("tame_texture", "entity/wolf/wolf_tame");
            paleWolf.putString("angry_texture", "entity/wolf/wolf_angry");
            paleWolf.put("biomes", new ListTag<StringTag>(StringTag.class));
            packetWrapper.write(Types.REGISTRY_ENTRY_ARRAY, new RegistryEntry[]{new RegistryEntry("minecraft:pale", paleWolf)});
            packetWrapper.send(Protocol1_20_3To1_20_5.class);
            PacketWrapper bannerPatternsPacket = wrapper.create(ClientboundConfigurationPackets1_20_5.REGISTRY_DATA);
            bannerPatternsPacket.write(Types.STRING, "minecraft:banner_pattern");
            RegistryEntry[] patternEntries = new RegistryEntry[BannerPatterns1_20_5.keys().length];
            String[] keys = BannerPatterns1_20_5.keys();
            for (int i = 0; i < keys.length; ++i) {
                CompoundTag pattern = new CompoundTag();
                String key = keys[i];
                String resourceLocation = EntityPacketRewriter1_20_5.jvmdowngrader$concat$lambda$registerPackets$2$1(key);
                pattern.putString("asset_id", key);
                pattern.putString("translation_key", EntityPacketRewriter1_20_5.jvmdowngrader$concat$lambda$registerPackets$2$2(key));
                patternEntries[i] = new RegistryEntry(resourceLocation, pattern);
            }
            bannerPatternsPacket.write(Types.REGISTRY_ENTRY_ARRAY, patternEntries);
            bannerPatternsPacket.send(Protocol1_20_3To1_20_5.class);
        });
        ((Protocol1_20_3To1_20_5)this.protocol).registerClientbound(ClientboundPackets1_20_3.LOGIN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.INT);
                this.map(Types.BOOLEAN);
                this.map(Types.STRING_ARRAY);
                this.map(Types.VAR_INT);
                this.map(Types.VAR_INT);
                this.map(Types.VAR_INT);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.handler(wrapper -> {
                    String dimensionKey = wrapper.read(Types.STRING);
                    DimensionData data = EntityPacketRewriter1_20_5.this.tracker(wrapper.user()).dimensionData(dimensionKey);
                    wrapper.write(Types.VAR_INT, data.id());
                });
                this.map(Types.STRING);
                this.map(Types.LONG);
                this.map(Types.BYTE);
                this.map(Types.BYTE);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.map(Types.OPTIONAL_GLOBAL_POSITION);
                this.map(Types.VAR_INT);
                this.handler(EntityPacketRewriter1_20_5.this.worldDataTrackerHandlerByKey1_20_5(3));
                this.handler(EntityPacketRewriter1_20_5.this.playerTrackerHandler());
                this.handler(wrapper -> {
                    AcknowledgedMessagesStorage storage = wrapper.user().get(AcknowledgedMessagesStorage.class);
                    if (storage.secureChatEnforced() != null) {
                        wrapper.write(Types.BOOLEAN, storage.isSecureChatEnforced());
                    } else {
                        wrapper.write(Types.BOOLEAN, Via.getConfig().enforceSecureChat());
                    }
                    storage.clear();
                    byte gamemode = wrapper.get(Types.BYTE, 0);
                    if (gamemode == 1) {
                        EntityPacketRewriter1_20_5.this.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20_3to1_20_5_rewriter_EntityPacketRewriter1_20_5$sendRangeAttributes(wrapper.user(), true);
                    }
                });
            }
        });
        ((Protocol1_20_3To1_20_5)this.protocol).registerClientbound(ClientboundPackets1_20_3.RESPAWN, wrapper -> {
            String dimensionKey = wrapper.read(Types.STRING);
            DimensionData data = this.tracker(wrapper.user()).dimensionData(dimensionKey);
            wrapper.write(Types.VAR_INT, data.id());
            wrapper.passthrough(Types.STRING);
            this.worldDataTrackerHandlerByKey1_20_5(0).handle(wrapper);
            wrapper.passthrough(Types.LONG);
            byte gamemode = wrapper.passthrough(Types.BYTE);
            this.sendRangeAttributes(wrapper.user(), gamemode == 1);
        });
        ((Protocol1_20_3To1_20_5)this.protocol).registerClientbound(ClientboundPackets1_20_3.UPDATE_MOB_EFFECT, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            wrapper.passthrough(Types.VAR_INT);
            byte amplifier = wrapper.read(Types.BYTE);
            wrapper.write(Types.VAR_INT, Integer.valueOf(amplifier));
            wrapper.passthrough(Types.VAR_INT);
            wrapper.passthrough(Types.BYTE);
            wrapper.read(Types.OPTIONAL_COMPOUND_TAG);
        });
        ((Protocol1_20_3To1_20_5)this.protocol).registerClientbound(ClientboundPackets1_20_3.UPDATE_ATTRIBUTES, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            int size = wrapper.passthrough(Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                String attributeIdentifier = wrapper.read(Types.STRING);
                int mappedId = Attributes1_20_5.keyToId(attributeIdentifier);
                wrapper.write(Types.VAR_INT, mappedId != -1 ? mappedId : 0);
                wrapper.passthrough(Types.DOUBLE);
                int modifierSize = wrapper.passthrough(Types.VAR_INT);
                for (int j = 0; j < modifierSize; ++j) {
                    wrapper.passthrough(Types.UUID);
                    wrapper.passthrough(Types.DOUBLE);
                    wrapper.passthrough(Types.BYTE);
                }
            }
        });
        ((Protocol1_20_3To1_20_5)this.protocol).registerClientbound(ClientboundPackets1_20_3.GAME_EVENT, wrapper -> {
            short event = wrapper.passthrough(Types.UNSIGNED_BYTE);
            if (event != 3) {
                return;
            }
            float value = wrapper.passthrough(Types.FLOAT).floatValue();
            this.sendRangeAttributes(wrapper.user(), value == 1.0f);
        });
    }

    private void updateParticleFormat(CompoundTag options, String particleType) {
        if ("block".equals(particleType) || "block_marker".equals(particleType) || "falling_dust".equals(particleType) || "dust_pillar".equals(particleType)) {
            this.moveTag(options, "value", "block_state");
        } else if ("item".equals(particleType)) {
            this.moveTag(options, "value", "item");
        } else if ("dust_color_transition".equals(particleType)) {
            this.moveTag(options, "fromColor", "from_color");
            this.moveTag(options, "toColor", "to_color");
        } else if ("entity_effect".equals(particleType)) {
            this.moveTag(options, "value", "color");
        }
    }

    private void moveTag(CompoundTag compoundTag, String from, String to) {
        Tag tag = compoundTag.remove(from);
        if (tag != null) {
            compoundTag.put(to, tag);
        }
    }

    private void checkSoundTag(@Nullable CompoundTag tag, String key) {
        if (tag == null) {
            return;
        }
        String sound = tag.getString(key);
        if (sound != null && ((Protocol1_20_3To1_20_5)this.protocol).getMappingData().soundId(sound) == -1) {
            CompoundTag directSoundValue = new CompoundTag();
            directSoundValue.putString("sound_id", sound);
            tag.put(key, directSoundValue);
        }
    }

    private void replaceNullValues(RegistryEntry[] entries) {
        RegistryEntry first = null;
        for (RegistryEntry registryEntry : entries) {
            if (registryEntry == null) continue;
            first = registryEntry;
            break;
        }
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] != null) continue;
            entries[i] = first.withKey(UUID.randomUUID().toString());
        }
    }

    private void sendRangeAttributes(UserConnection connection, boolean creativeMode) {
        PacketWrapper wrapper = PacketWrapper.create(ClientboundPackets1_20_5.UPDATE_ATTRIBUTES, connection);
        wrapper.write(Types.VAR_INT, this.tracker(connection).clientEntityId());
        wrapper.write(Types.VAR_INT, 2);
        this.writeAttribute(wrapper, "player.block_interaction_range", 4.5, creativeMode ? CREATIVE_BLOCK_INTERACTION_RANGE : null, 0.5);
        this.writeAttribute(wrapper, "player.entity_interaction_range", 3.0, creativeMode ? CREATIVE_ENTITY_INTERACTION_RANGE : null, 2.0);
        wrapper.scheduleSend(Protocol1_20_3To1_20_5.class);
    }

    private void writeAttribute(PacketWrapper wrapper, String attributeId, double base, @Nullable UUID modifierId, double amount) {
        wrapper.write(Types.VAR_INT, Attributes1_20_5.keyToId(attributeId));
        wrapper.write(Types.DOUBLE, base);
        if (modifierId != null) {
            wrapper.write(Types.VAR_INT, 1);
            wrapper.write(Types.UUID, modifierId);
            wrapper.write(Types.DOUBLE, amount);
            wrapper.write(Types.BYTE, (byte)0);
        } else {
            wrapper.write(Types.VAR_INT, 0);
        }
    }

    static int withAlpha(int rgb) {
        return 0xFF000000 | rgb & 0xFFFFFF;
    }

    @Override
    protected void registerRewrites() {
        this.filter().mapDataType(typeId -> {
            int id = typeId;
            if (id >= Types1_20_5.ENTITY_DATA_TYPES.particlesType.typeId()) {
                ++id;
            }
            if (id >= Types1_20_5.ENTITY_DATA_TYPES.wolfVariantType.typeId()) {
                ++id;
            }
            if (id >= Types1_20_5.ENTITY_DATA_TYPES.armadilloState.typeId()) {
                ++id;
            }
            return Types1_20_5.ENTITY_DATA_TYPES.byId(id);
        });
        this.registerEntityDataTypeHandler(Types1_20_5.ENTITY_DATA_TYPES.itemType, Types1_20_5.ENTITY_DATA_TYPES.blockStateType, Types1_20_5.ENTITY_DATA_TYPES.optionalBlockStateType, Types1_20_5.ENTITY_DATA_TYPES.particleType, null, Types1_20_5.ENTITY_DATA_TYPES.componentType, Types1_20_5.ENTITY_DATA_TYPES.optionalComponentType);
        this.registerBlockStateHandler(EntityTypes1_20_5.ABSTRACT_MINECART, 11);
        this.filter().type(EntityTypes1_20_5.LIVING_ENTITY).index(10).handler((event, meta) -> {
            int effectColor = (Integer)meta.value();
            if (effectColor == 0) {
                meta.setTypeAndValue(Types1_20_5.ENTITY_DATA_TYPES.particlesType, new Particle[0]);
                return;
            }
            Particle particle = new Particle(((Protocol1_20_3To1_20_5)this.protocol).getMappingData().getParticleMappings().mappedId("entity_effect"));
            particle.add(Types.INT, EntityPacketRewriter1_20_5.withAlpha(effectColor));
            meta.setTypeAndValue(Types1_20_5.ENTITY_DATA_TYPES.particlesType, new Particle[]{particle});
        });
        this.filter().type(EntityTypes1_20_5.LLAMA).removeIndex(20);
        this.filter().type(EntityTypes1_20_5.AREA_EFFECT_CLOUD).handler((event, meta) -> {
            EntityData colorData;
            int metaIndex = event.index();
            if (metaIndex == 9) {
                EntityData particleData = event.dataAtIndex(11);
                int color = (Integer)meta.value();
                if (particleData == null) {
                    if (color != 0) {
                        Particle particle = new Particle(((Protocol1_20_3To1_20_5)this.protocol).getMappingData().getParticleMappings().mappedId("entity_effect"));
                        particle.add(Types.INT, EntityPacketRewriter1_20_5.withAlpha(color));
                        event.createExtraData(new EntityData(10, Types1_20_5.ENTITY_DATA_TYPES.particleType, particle));
                    }
                } else {
                    this.addColor(particleData, color);
                }
                event.cancel();
                return;
            }
            if (metaIndex > 9) {
                event.setIndex(metaIndex - 1);
            }
            if (metaIndex == 11 && (colorData = event.dataAtIndex(9)) != null && colorData.dataType() == Types1_20_5.ENTITY_DATA_TYPES.varIntType) {
                this.addColor(meta, (Integer)colorData.value());
            }
        });
        this.filter().type(EntityTypes1_20_5.ARROW).index(10).handler((event, meta) -> {
            int color = (Integer)meta.value();
            if (color != -1) {
                meta.setValue(EntityPacketRewriter1_20_5.withAlpha(color));
            }
        });
        EntityDataHandler emptyItemHandler = (event, data) -> {
            Item item = (Item)data.value();
            if (item == null || item.isEmpty()) {
                event.cancel();
            }
        };
        this.filter().type(EntityTypes1_20_5.EGG).index(8).handler(emptyItemHandler);
        this.filter().type(EntityTypes1_20_5.SNOWBALL).index(8).handler(emptyItemHandler);
        this.filter().type(EntityTypes1_20_5.ENDER_PEARL).index(8).handler(emptyItemHandler);
        this.filter().type(EntityTypes1_20_5.EXPERIENCE_BOTTLE).index(8).handler(emptyItemHandler);
    }

    private void addColor(@Nullable EntityData particleMeta, int color) {
        if (particleMeta == null) {
            return;
        }
        Particle particle = (Particle)particleMeta.value();
        if (particle.id() == ((Protocol1_20_3To1_20_5)this.protocol).getMappingData().getParticleMappings().mappedId("entity_effect")) {
            particle.getArgument(0).setValue(EntityPacketRewriter1_20_5.withAlpha(color));
        }
    }

    @Override
    public void rewriteParticle(UserConnection connection, Particle particle) {
        super.rewriteParticle(connection, particle);
        if (particle.id() == ((Protocol1_20_3To1_20_5)this.protocol).getMappingData().getParticleMappings().mappedId("entity_effect")) {
            particle.add(Types.INT, 0);
        }
    }

    @Override
    public void onMappingDataLoaded() {
        this.mapTypes();
    }

    @Override
    public EntityType typeFromId(int type) {
        return EntityTypes1_20_5.getTypeFromId(type);
    }

    void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20_3to1_20_5_rewriter_EntityPacketRewriter1_20_5$sendRangeAttributes(UserConnection userConnection, boolean bl) {
        this.sendRangeAttributes(userConnection, bl);
    }

    private static String jvmdowngrader$concat$lambda$registerPackets$2$1(String string) {
        return "minecraft:" + string;
    }

    private static String jvmdowngrader$concat$lambda$registerPackets$2$2(String string) {
        return "block.minecraft.banner." + string;
    }
}

