/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.protocols.v1_20to1_20_2.rewriter;

import com.replaymod.replaystudio.lib.viaversion.api.connection.UserConnection;
import com.replaymod.replaystudio.lib.viaversion.api.data.ParticleMappings;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.ChunkPosition;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.blockentity.BlockEntity;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.chunks.Chunk;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.chunks.ChunkSection;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.chunks.DataPalette;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.chunks.PaletteType;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.Item;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.remapper.PacketHandlers;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.chunk.ChunkType1_18;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.chunk.ChunkType1_20_2;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_19_3to1_19_4.packet.ClientboundPackets1_19_4;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_19_3to1_19_4.rewriter.RecipeRewriter1_19_4;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20to1_20_2.Protocol1_20To1_20_2;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20to1_20_2.data.PotionEffects1_20_2;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20to1_20_2.packet.ServerboundPackets1_20_2;
import com.replaymod.replaystudio.lib.viaversion.rewriter.BlockRewriter;
import com.replaymod.replaystudio.lib.viaversion.rewriter.ItemRewriter;
import com.replaymod.replaystudio.lib.viaversion.util.MathUtil;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.NumberTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={7.class, 6.class, 5.class, 4.class, 3.class, 2.class, 1.class})
public final class BlockItemPacketRewriter1_20_2
extends ItemRewriter<ClientboundPackets1_19_4, ServerboundPackets1_20_2, Protocol1_20To1_20_2> {
    public BlockItemPacketRewriter1_20_2(Protocol1_20To1_20_2 protocol) {
        super(protocol, Types.ITEM1_13_2, Types.ITEM1_13_2_ARRAY);
    }

    @Override
    public void registerPackets() {
        BlockRewriter<ClientboundPackets1_19_4> blockRewriter = BlockRewriter.for1_14(this.protocol);
        blockRewriter.registerBlockEvent(ClientboundPackets1_19_4.BLOCK_EVENT);
        blockRewriter.registerBlockUpdate(ClientboundPackets1_19_4.BLOCK_UPDATE);
        blockRewriter.registerSectionBlocksUpdate1_20(ClientboundPackets1_19_4.SECTION_BLOCKS_UPDATE);
        blockRewriter.registerLevelEvent(ClientboundPackets1_19_4.LEVEL_EVENT, 1010, 2001);
        ((Protocol1_20To1_20_2)this.protocol).registerServerbound(ServerboundPackets1_20_2.SET_BEACON, wrapper -> {
            if (wrapper.passthrough(Types.BOOLEAN).booleanValue()) {
                wrapper.write(Types.VAR_INT, wrapper.read(Types.VAR_INT) + 1);
            }
            if (wrapper.passthrough(Types.BOOLEAN).booleanValue()) {
                wrapper.write(Types.VAR_INT, wrapper.read(Types.VAR_INT) + 1);
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.FORGET_LEVEL_CHUNK, wrapper -> {
            int x = wrapper.read(Types.INT);
            int z = wrapper.read(Types.INT);
            wrapper.write(Types.CHUNK_POSITION, new ChunkPosition(x, z));
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.TAG_QUERY, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            wrapper.write(Types.COMPOUND_TAG, wrapper.read(Types.NAMED_COMPOUND_TAG));
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.BLOCK_ENTITY_DATA, wrapper -> {
            wrapper.passthrough(Types.BLOCK_POSITION1_14);
            wrapper.passthrough(Types.VAR_INT);
            wrapper.write(Types.COMPOUND_TAG, this.handleBlockEntity(wrapper.read(Types.NAMED_COMPOUND_TAG)));
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.LEVEL_CHUNK_WITH_LIGHT, wrapper -> {
            Object tracker = ((Protocol1_20To1_20_2)this.protocol).getEntityRewriter().tracker(wrapper.user());
            ChunkType1_18 chunkType = new ChunkType1_18(tracker.currentWorldSectionHeight(), MathUtil.ceilLog2(((Protocol1_20To1_20_2)this.protocol).getMappingData().getBlockStateMappings().size()), MathUtil.ceilLog2(tracker.biomesSent()));
            Chunk chunk = wrapper.read(chunkType);
            ChunkType1_20_2 newChunkType = new ChunkType1_20_2(tracker.currentWorldSectionHeight(), MathUtil.ceilLog2(((Protocol1_20To1_20_2)this.protocol).getMappingData().getBlockStateMappings().mappedSize()), MathUtil.ceilLog2(tracker.biomesSent()));
            wrapper.write(newChunkType, chunk);
            for (ChunkSection section : chunk.getSections()) {
                DataPalette blockPalette = section.palette(PaletteType.BLOCKS);
                for (int i = 0; i < blockPalette.size(); ++i) {
                    int id = blockPalette.idByIndex(i);
                    blockPalette.setIdByIndex(i, ((Protocol1_20To1_20_2)this.protocol).getMappingData().getNewBlockStateId(id));
                }
            }
            for (BlockEntity blockEntity : chunk.blockEntities()) {
                this.handleBlockEntity(blockEntity.tag());
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.CONTAINER_SET_CONTENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.UNSIGNED_BYTE);
                this.map(Types.VAR_INT);
                this.handler(wrapper -> {
                    Item[] items;
                    for (Item item : items = wrapper.read(Types.ITEM1_13_2_ARRAY)) {
                        BlockItemPacketRewriter1_20_2.this.handleItemToClient(wrapper.user(), item);
                    }
                    wrapper.write(Types.ITEM1_20_2_ARRAY, items);
                    wrapper.write(Types.ITEM1_20_2, BlockItemPacketRewriter1_20_2.this.handleItemToClient(wrapper.user(), wrapper.read(Types.ITEM1_13_2)));
                });
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.CONTAINER_SET_SLOT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.UNSIGNED_BYTE);
                this.map(Types.VAR_INT);
                this.map(Types.SHORT);
                this.handler(wrapper -> wrapper.write(Types.ITEM1_20_2, BlockItemPacketRewriter1_20_2.this.handleItemToClient(wrapper.user(), wrapper.read(Types.ITEM1_13_2))));
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.UPDATE_ADVANCEMENTS, wrapper -> {
            wrapper.passthrough(Types.BOOLEAN);
            int size = wrapper.passthrough(Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.OPTIONAL_STRING);
                if (wrapper.passthrough(Types.BOOLEAN).booleanValue()) {
                    wrapper.passthrough(Types.COMPONENT);
                    wrapper.passthrough(Types.COMPONENT);
                    wrapper.write(Types.ITEM1_20_2, this.handleItemToClient(wrapper.user(), wrapper.read(Types.ITEM1_13_2)));
                    wrapper.passthrough(Types.VAR_INT);
                    int flags = wrapper.passthrough(Types.INT);
                    if ((flags & 1) != 0) {
                        wrapper.passthrough(Types.STRING);
                    }
                    wrapper.passthrough(Types.FLOAT);
                    wrapper.passthrough(Types.FLOAT);
                }
                wrapper.read(Types.STRING_ARRAY);
                int requirements = wrapper.passthrough(Types.VAR_INT);
                for (int array = 0; array < requirements; ++array) {
                    wrapper.passthrough(Types.STRING_ARRAY);
                }
                wrapper.passthrough(Types.BOOLEAN);
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.SET_EQUIPMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.handler(wrapper -> {
                    byte slot;
                    do {
                        slot = wrapper.passthrough(Types.BYTE);
                        wrapper.write(Types.ITEM1_20_2, BlockItemPacketRewriter1_20_2.this.handleItemToClient(wrapper.user(), wrapper.read(Types.ITEM1_13_2)));
                    } while ((slot & 0xFFFFFF80) != 0);
                });
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerServerbound(ServerboundPackets1_20_2.CONTAINER_CLICK, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.UNSIGNED_BYTE);
                this.map(Types.VAR_INT);
                this.map(Types.SHORT);
                this.map(Types.BYTE);
                this.map(Types.VAR_INT);
                this.handler(wrapper -> {
                    int length = wrapper.passthrough(Types.VAR_INT);
                    for (int i = 0; i < length; ++i) {
                        wrapper.passthrough(Types.SHORT);
                        wrapper.write(Types.ITEM1_13_2, BlockItemPacketRewriter1_20_2.this.handleItemToServer(wrapper.user(), wrapper.read(Types.ITEM1_20_2)));
                    }
                    wrapper.write(Types.ITEM1_13_2, BlockItemPacketRewriter1_20_2.this.handleItemToServer(wrapper.user(), wrapper.read(Types.ITEM1_20_2)));
                });
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.MERCHANT_OFFERS, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            int size = wrapper.passthrough(Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                wrapper.write(Types.ITEM1_20_2, this.handleItemToClient(wrapper.user(), wrapper.read(Types.ITEM1_13_2)));
                wrapper.write(Types.ITEM1_20_2, this.handleItemToClient(wrapper.user(), wrapper.read(Types.ITEM1_13_2)));
                wrapper.write(Types.ITEM1_20_2, this.handleItemToClient(wrapper.user(), wrapper.read(Types.ITEM1_13_2)));
                wrapper.passthrough(Types.BOOLEAN);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.FLOAT);
                wrapper.passthrough(Types.INT);
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerServerbound(ServerboundPackets1_20_2.SET_CREATIVE_MODE_SLOT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.SHORT);
                this.handler(wrapper -> wrapper.write(Types.ITEM1_13_2, BlockItemPacketRewriter1_20_2.this.handleItemToServer(wrapper.user(), wrapper.read(Types.ITEM1_20_2))));
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound(ClientboundPackets1_19_4.LEVEL_PARTICLES, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.map(Types.BOOLEAN);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.FLOAT);
                this.map(Types.FLOAT);
                this.map(Types.FLOAT);
                this.map(Types.FLOAT);
                this.map(Types.INT);
                this.handler(wrapper -> {
                    int id = wrapper.get(Types.VAR_INT, 0);
                    ParticleMappings mappings = Protocol1_20To1_20_2.MAPPINGS.getParticleMappings();
                    if (mappings.isBlockParticle(id)) {
                        int data = wrapper.read(Types.VAR_INT);
                        wrapper.write(Types.VAR_INT, ((Protocol1_20To1_20_2)BlockItemPacketRewriter1_20_2.this.protocol).getMappingData().getNewBlockStateId(data));
                    } else if (mappings.isItemParticle(id)) {
                        wrapper.write(Types.ITEM1_20_2, BlockItemPacketRewriter1_20_2.this.handleItemToClient(wrapper.user(), wrapper.read(Types.ITEM1_13_2)));
                    }
                });
            }
        });
        new RecipeRewriter1_19_4<ClientboundPackets1_19_4>(this.protocol){

            @Override
            public void handleCraftingShapeless(PacketWrapper wrapper) {
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.VAR_INT);
                this.handleIngredients(wrapper);
                Item result = wrapper.read(this.itemType());
                this.rewrite(wrapper.user(), result);
                wrapper.write(Types.ITEM1_20_2, result);
            }

            @Override
            public void handleSmelting(PacketWrapper wrapper) {
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.VAR_INT);
                this.handleIngredient(wrapper);
                Item result = wrapper.read(this.itemType());
                this.rewrite(wrapper.user(), result);
                wrapper.write(Types.ITEM1_20_2, result);
                wrapper.passthrough(Types.FLOAT);
                wrapper.passthrough(Types.VAR_INT);
            }

            @Override
            public void handleCraftingShaped(PacketWrapper wrapper) {
                int ingredients = wrapper.passthrough(Types.VAR_INT) * wrapper.passthrough(Types.VAR_INT);
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.VAR_INT);
                for (int i = 0; i < ingredients; ++i) {
                    this.handleIngredient(wrapper);
                }
                Item result = wrapper.read(this.itemType());
                this.rewrite(wrapper.user(), result);
                wrapper.write(Types.ITEM1_20_2, result);
                wrapper.passthrough(Types.BOOLEAN);
            }

            @Override
            public void handleStonecutting(PacketWrapper wrapper) {
                wrapper.passthrough(Types.STRING);
                this.handleIngredient(wrapper);
                Item result = wrapper.read(this.itemType());
                this.rewrite(wrapper.user(), result);
                wrapper.write(Types.ITEM1_20_2, result);
            }

            @Override
            public void handleSmithing(PacketWrapper wrapper) {
                this.handleIngredient(wrapper);
                this.handleIngredient(wrapper);
                Item result = wrapper.read(this.itemType());
                this.rewrite(wrapper.user(), result);
                wrapper.write(Types.ITEM1_20_2, result);
            }

            @Override
            public void handleSmithingTransform(PacketWrapper wrapper) {
                this.handleIngredient(wrapper);
                this.handleIngredient(wrapper);
                this.handleIngredient(wrapper);
                Item result = wrapper.read(this.itemType());
                this.rewrite(wrapper.user(), result);
                wrapper.write(Types.ITEM1_20_2, result);
            }

            @Override
            protected void handleIngredient(PacketWrapper wrapper) {
                Item[] items = wrapper.read(this.itemArrayType());
                wrapper.write(Types.ITEM1_20_2_ARRAY, items);
                for (Item item : items) {
                    this.rewrite(wrapper.user(), item);
                }
            }
        }.register(ClientboundPackets1_19_4.UPDATE_RECIPES);
    }

    @Override
    public @Nullable Item handleItemToClient(UserConnection connection, @Nullable Item item) {
        if (item == null) {
            return null;
        }
        if (item.tag() != null) {
            BlockItemPacketRewriter1_20_2.to1_20_2Effects(item);
        }
        return super.handleItemToClient(connection, item);
    }

    @Override
    public @Nullable Item handleItemToServer(UserConnection connection, @Nullable Item item) {
        if (item == null) {
            return null;
        }
        if (item.tag() != null) {
            BlockItemPacketRewriter1_20_2.to1_20_1Effects(item);
        }
        return super.handleItemToServer(connection, item);
    }

    public static void to1_20_2Effects(Item item) {
        Tag customPotionEffectsTag = item.tag().remove("CustomPotionEffects");
        if (customPotionEffectsTag instanceof ListTag) {
            ListTag effectsTag = (ListTag)customPotionEffectsTag;
            item.tag().put("custom_potion_effects", customPotionEffectsTag);
            for (Tag tag : effectsTag) {
                String key;
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag effectTag = (CompoundTag)tag;
                Tag idTag = effectTag.remove("Id");
                if (idTag instanceof NumberTag && (key = PotionEffects1_20_2.idToKey(((NumberTag)idTag).asInt() - 1)) != null) {
                    effectTag.put("id", new StringTag(key));
                }
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "Amplifier", "amplifier");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "Duration", "duration");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "Ambient", "ambient");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "ShowParticles", "show_particles");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "ShowIcon", "show_icon");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "HiddenEffect", "hidden_effect");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "FactorCalculationData", "factor_calculation_data");
            }
        }
    }

    public static void to1_20_1Effects(Item item) {
        Tag customPotionEffectsTag = item.tag().remove("custom_potion_effects");
        if (customPotionEffectsTag instanceof ListTag) {
            ListTag effectsTag = (ListTag)customPotionEffectsTag;
            item.tag().put("CustomPotionEffects", effectsTag);
            for (Tag tag : effectsTag) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag effectTag = (CompoundTag)tag;
                Tag tag2 = effectTag.remove("id");
                if (tag2 instanceof StringTag) {
                    StringTag idTag = (StringTag)tag2;
                    int id = PotionEffects1_20_2.keyToId(idTag.getValue());
                    effectTag.putInt("Id", id + 1);
                }
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "amplifier", "Amplifier");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "duration", "Duration");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "ambient", "Ambient");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "show_particles", "ShowParticles");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "show_icon", "ShowIcon");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "hidden_effect", "HiddenEffect");
                BlockItemPacketRewriter1_20_2.renameTag(effectTag, "factor_calculation_data", "FactorCalculationData");
            }
        }
    }

    private static void renameTag(CompoundTag tag, String entryName, String toEntryName) {
        Tag entry = tag.remove(entryName);
        if (entry != null) {
            tag.put(toEntryName, entry);
        }
    }

    private @Nullable CompoundTag handleBlockEntity(@Nullable CompoundTag tag) {
        Tag secondaryEffect;
        if (tag == null) {
            return null;
        }
        Tag primaryEffect = tag.remove("Primary");
        if (primaryEffect instanceof NumberTag && ((NumberTag)primaryEffect).asInt() != 0) {
            tag.put("primary_effect", new StringTag(PotionEffects1_20_2.idToKeyOrLuck(((NumberTag)primaryEffect).asInt() - 1)));
        }
        if ((secondaryEffect = tag.remove("Secondary")) instanceof NumberTag && ((NumberTag)secondaryEffect).asInt() != 0) {
            tag.put("secondary_effect", new StringTag(PotionEffects1_20_2.idToKeyOrLuck(((NumberTag)secondaryEffect).asInt() - 1)));
        }
        return tag;
    }
}

