/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.protocols.v1_20to1_20_2.storage;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.Unpooled;
import com.replaymod.replaystudio.lib.viaversion.api.connection.StorableObject;
import com.replaymod.replaystudio.lib.viaversion.api.connection.UserConnection;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketType;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_19_3to1_19_4.packet.ServerboundPackets1_19_4;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20to1_20_2.Protocol1_20To1_20_2;
import com.viaversion.nbt.tag.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={ClientInformation.class, QueuedPacket.class, BridgePhase.class})
public class ConfigurationState
implements StorableObject {
    private static final QueuedPacket[] EMPTY_PACKET_ARRAY = new QueuedPacket[0];
    private final List<QueuedPacket> packetQueue = new ArrayList<QueuedPacket>();
    private BridgePhase bridgePhase = BridgePhase.NONE;
    private QueuedPacket joinGamePacket;
    private boolean queuedJoinGame;
    private CompoundTag lastDimensionRegistry;
    private ClientInformation clientInformation;

    public BridgePhase bridgePhase() {
        return this.bridgePhase;
    }

    public void setBridgePhase(BridgePhase bridgePhase) {
        this.bridgePhase = bridgePhase;
    }

    public @Nullable CompoundTag lastDimensionRegistry() {
        return this.lastDimensionRegistry;
    }

    public boolean setLastDimensionRegistry(CompoundTag dimensionRegistry) {
        boolean equals = Objects.equals(this.lastDimensionRegistry, dimensionRegistry);
        this.lastDimensionRegistry = dimensionRegistry;
        return !equals;
    }

    public void setClientInformation(ClientInformation clientInformation) {
        this.clientInformation = clientInformation;
    }

    public void addPacketToQueue(PacketWrapper wrapper, boolean clientbound) {
        this.packetQueue.add(this.toQueuedPacket(wrapper, clientbound, false));
    }

    private QueuedPacket toQueuedPacket(PacketWrapper wrapper, boolean clientbound, boolean skipCurrentPipeline) {
        ByteBuf copy = Unpooled.buffer();
        PacketType packetType = wrapper.getPacketType();
        int packetId = wrapper.getId();
        wrapper.setId(-1);
        wrapper.writeToBuffer(copy);
        return new QueuedPacket(copy, clientbound, packetType, packetId, skipCurrentPipeline);
    }

    public void setJoinGamePacket(PacketWrapper wrapper) {
        this.joinGamePacket = this.toQueuedPacket(wrapper, true, true);
        this.queuedJoinGame = true;
    }

    @Override
    public boolean clearOnServerSwitch() {
        return false;
    }

    @Override
    public void onRemove() {
        for (QueuedPacket packet : this.packetQueue) {
            packet.buf().release();
        }
        if (this.joinGamePacket != null) {
            this.joinGamePacket.buf().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueuedPackets(UserConnection connection) {
        PacketWrapper clientInformationPacket;
        boolean hasJoinGamePacket;
        boolean bl = hasJoinGamePacket = this.joinGamePacket != null;
        if (hasJoinGamePacket) {
            this.packetQueue.add(0, this.joinGamePacket);
            this.joinGamePacket = null;
        }
        if ((clientInformationPacket = this.clientInformationPacket(connection)) != null) {
            this.packetQueue.add(hasJoinGamePacket ? 1 : 0, this.toQueuedPacket(clientInformationPacket, false, true));
        }
        QueuedPacket[] queuedPackets = this.packetQueue.toArray(EMPTY_PACKET_ARRAY);
        this.packetQueue.clear();
        for (QueuedPacket packet : queuedPackets) {
            try {
                PacketWrapper queuedWrapper = packet.packetType() != null ? PacketWrapper.create(packet.packetType(), packet.buf(), connection) : PacketWrapper.create(packet.packetId(), packet.buf(), connection);
                if (packet.clientbound()) {
                    queuedWrapper.send(Protocol1_20To1_20_2.class, packet.skipCurrentPipeline());
                    continue;
                }
                queuedWrapper.sendToServer(Protocol1_20To1_20_2.class, packet.skipCurrentPipeline());
            }
            finally {
                packet.buf().release();
            }
        }
    }

    public void clear() {
        this.packetQueue.clear();
        this.bridgePhase = BridgePhase.NONE;
        this.queuedJoinGame = false;
    }

    public boolean queuedOrSentJoinGame() {
        return this.queuedJoinGame;
    }

    public @Nullable PacketWrapper clientInformationPacket(UserConnection connection) {
        if (this.clientInformation == null) {
            return null;
        }
        PacketWrapper settingsPacket = PacketWrapper.create(ServerboundPackets1_19_4.CLIENT_INFORMATION, connection);
        settingsPacket.write(Types.STRING, this.clientInformation.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$language());
        settingsPacket.write(Types.BYTE, this.clientInformation.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$viewDistance());
        settingsPacket.write(Types.VAR_INT, this.clientInformation.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$chatVisibility());
        settingsPacket.write(Types.BOOLEAN, this.clientInformation.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$showChatColors());
        settingsPacket.write(Types.UNSIGNED_BYTE, this.clientInformation.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$modelCustomization());
        settingsPacket.write(Types.VAR_INT, this.clientInformation.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$mainHand());
        settingsPacket.write(Types.BOOLEAN, this.clientInformation.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$textFiltering());
        settingsPacket.write(Types.BOOLEAN, this.clientInformation.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$allowListing());
        return settingsPacket;
    }

    @NestHost(value=ConfigurationState.class)
    public static enum BridgePhase {
        NONE,
        PROFILE_SENT,
        CONFIGURATION,
        REENTERING_CONFIGURATION;

    }

    @NestHost(value=ConfigurationState.class)
    public static final class ClientInformation {
        private final String language;
        private final byte viewDistance;
        private final int chatVisibility;
        private final boolean showChatColors;
        private final short modelCustomization;
        private final int mainHand;
        private final boolean textFiltering;
        private final boolean allowListing;

        public ClientInformation(String language, byte viewDistance, int chatVisibility, boolean showChatColors, short modelCustomization, int mainHand, boolean textFiltering, boolean allowListing) {
            this.language = language;
            this.viewDistance = viewDistance;
            this.chatVisibility = chatVisibility;
            this.showChatColors = showChatColors;
            this.modelCustomization = modelCustomization;
            this.mainHand = mainHand;
            this.textFiltering = textFiltering;
            this.allowListing = allowListing;
        }

        int jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$mainHand() {
            return this.mainHand;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$set$mainHand(int n) {
            this.mainHand = n;
        }

        int jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$chatVisibility() {
            return this.chatVisibility;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$set$chatVisibility(int n) {
            this.chatVisibility = n;
        }

        boolean jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$textFiltering() {
            return this.textFiltering;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$set$textFiltering(boolean bl) {
            this.textFiltering = bl;
        }

        boolean jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$showChatColors() {
            return this.showChatColors;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$set$showChatColors(boolean bl) {
            this.showChatColors = bl;
        }

        String jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$language() {
            return this.language;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$set$language(String string) {
            this.language = string;
        }

        boolean jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$allowListing() {
            return this.allowListing;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$set$allowListing(boolean bl) {
            this.allowListing = bl;
        }

        short jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$modelCustomization() {
            return this.modelCustomization;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$set$modelCustomization(short s) {
            this.modelCustomization = s;
        }

        byte jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$get$viewDistance() {
            return this.viewDistance;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_protocols_v1_20to1_20_2_storage_ConfigurationState$ClientInformation$set$viewDistance(byte by) {
            this.viewDistance = by;
        }
    }

    @NestHost(value=ConfigurationState.class)
    public static final class QueuedPacket {
        private final ByteBuf buf;
        private final boolean clientbound;
        private final PacketType packetType;
        private final int packetId;
        private final boolean skipCurrentPipeline;

        QueuedPacket(ByteBuf buf, boolean clientbound, PacketType packetType, int packetId, boolean skipCurrentPipeline) {
            this.buf = buf;
            this.clientbound = clientbound;
            this.packetType = packetType;
            this.packetId = packetId;
            this.skipCurrentPipeline = skipCurrentPipeline;
        }

        public ByteBuf buf() {
            return this.buf;
        }

        public boolean clientbound() {
            return this.clientbound;
        }

        public int packetId() {
            return this.packetId;
        }

        public @Nullable PacketType packetType() {
            return this.packetType;
        }

        public boolean skipCurrentPipeline() {
            return this.skipCurrentPipeline;
        }

        public String toString() {
            return QueuedPacket.jvmdowngrader$concat$toString$1(this.buf, this.clientbound, this.packetType, this.packetId, this.skipCurrentPipeline);
        }

        private static String jvmdowngrader$concat$toString$1(ByteBuf byteBuf, boolean bl, PacketType packetType, int n, boolean bl2) {
            return "QueuedPacket{buf=" + byteBuf + ", clientbound=" + bl + ", packetType=" + packetType + ", packetId=" + n + ", skipCurrentPipeline=" + bl2 + "}";
        }
    }
}

