/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.rewriter;

import com.replaymod.replaystudio.lib.viaversion.api.connection.UserConnection;
import com.replaymod.replaystudio.lib.viaversion.api.data.FullMappings;
import com.replaymod.replaystudio.lib.viaversion.api.data.MappingData;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.data.StructuredData;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.data.StructuredDataContainer;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.data.StructuredDataKey;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.Item;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.Protocol;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.ClientboundPacketType;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.ServerboundPacketType;
import com.replaymod.replaystudio.lib.viaversion.api.rewriter.ComponentRewriter;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.replaymod.replaystudio.lib.viaversion.rewriter.ItemRewriter;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.Tag;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={ItemHandler.class})
public class StructuredItemRewriter<C extends ClientboundPacketType, S extends ServerboundPacketType, T extends Protocol<C, ?, ?, S>>
extends ItemRewriter<C, S, T> {
    public StructuredItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType) {
        super(protocol, itemType, itemArrayType, mappedItemType, mappedItemArrayType);
    }

    public StructuredItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType) {
        super(protocol, itemType, itemArrayType, itemType, itemArrayType);
    }

    @Override
    public Item handleItemToClient(UserConnection connection, Item item) {
        ComponentRewriter componentRewriter;
        if (item.isEmpty()) {
            return item;
        }
        MappingData mappingData = this.protocol.getMappingData();
        StructuredDataContainer dataContainer = item.dataContainer();
        if (mappingData != null) {
            FullMappings dataComponentMappings;
            if (mappingData.getItemMappings() != null) {
                item.setIdentifier(mappingData.getNewItemId(item.identifier()));
            }
            if ((dataComponentMappings = mappingData.getDataComponentSerializerMappings()) != null) {
                dataContainer.setIdLookup(this.protocol, true);
                dataContainer.updateIds(this.protocol, dataComponentMappings::getNewId);
            }
        }
        if ((componentRewriter = this.protocol.getComponentRewriter()) != null) {
            this.updateComponent(connection, item, StructuredDataKey.ITEM_NAME, "item_name");
            this.updateComponent(connection, item, StructuredDataKey.CUSTOM_NAME, "custom_name");
            StructuredData<Tag[]> loreData = dataContainer.getNonEmpty(StructuredDataKey.LORE);
            if (loreData != null) {
                for (Tag tag : loreData.value()) {
                    componentRewriter.processTag(connection, tag);
                }
            }
        }
        Int2IntFunction itemIdRewriter = null;
        Int2IntFunction blockIdRewriter = null;
        if (mappingData != null) {
            Int2IntFunction int2IntFunction = mappingData.getItemMappings() != null ? mappingData::getNewItemId : (itemIdRewriter = null);
            blockIdRewriter = mappingData.getBlockMappings() != null ? mappingData::getNewBlockId : null;
        }
        this.updateItemComponents(connection, dataContainer, this::handleItemToClient, itemIdRewriter, blockIdRewriter);
        return item;
    }

    @Override
    public Item handleItemToServer(UserConnection connection, Item item) {
        if (item.isEmpty()) {
            return item;
        }
        MappingData mappingData = this.protocol.getMappingData();
        StructuredDataContainer dataContainer = item.dataContainer();
        if (mappingData != null) {
            FullMappings dataComponentMappings;
            if (mappingData.getItemMappings() != null) {
                item.setIdentifier(mappingData.getOldItemId(item.identifier()));
            }
            if ((dataComponentMappings = mappingData.getDataComponentSerializerMappings()) != null) {
                dataContainer.setIdLookup(this.protocol, false);
                dataContainer.updateIds(this.protocol, id -> dataComponentMappings.inverse().getNewId(id));
            }
        }
        this.restoreTextComponents(item);
        Int2IntFunction itemIdRewriter = null;
        Int2IntFunction blockIdRewriter = null;
        if (mappingData != null) {
            Int2IntFunction int2IntFunction = mappingData.getItemMappings() != null ? mappingData::getOldItemId : (itemIdRewriter = null);
            blockIdRewriter = mappingData.getBlockMappings() != null ? mappingData::getOldBlockId : null;
        }
        this.updateItemComponents(connection, dataContainer, this::handleItemToServer, itemIdRewriter, blockIdRewriter);
        return item;
    }

    protected void updateItemComponents(UserConnection connection, StructuredDataContainer container, ItemHandler itemHandler, @Nullable Int2IntFunction idRewriter, @Nullable Int2IntFunction blockIdRewriter) {
        if (idRewriter != null) {
            container.updateIfPresent(StructuredDataKey.TRIM, value -> value.rewrite(idRewriter));
            container.updateIfPresent(StructuredDataKey.POT_DECORATIONS, value -> value.rewrite(idRewriter));
        }
        if (blockIdRewriter != null) {
            container.updateIfPresent(StructuredDataKey.TOOL, value -> value.rewrite(blockIdRewriter));
            container.updateIfPresent(StructuredDataKey.CAN_PLACE_ON, value -> value.rewrite(blockIdRewriter));
            container.updateIfPresent(StructuredDataKey.CAN_BREAK, value -> value.rewrite(blockIdRewriter));
        }
        for (Map.Entry<StructuredDataKey<?>, StructuredData<?>> entry : container.data().entrySet()) {
            StructuredData<?> data = entry.getValue();
            if (data.isEmpty()) continue;
            StructuredDataKey<?> key = entry.getKey();
            Class<?> outputClass = key.type().getOutputClass();
            if (outputClass == Item.class) {
                StructuredData<?> itemData = data;
                itemData.setValue(itemHandler.rewrite(connection, (Item)itemData.value()));
                continue;
            }
            if (outputClass != Item[].class) continue;
            StructuredData<?> itemArrayData = data;
            Item[] items = (Item[])itemArrayData.value();
            for (int i = 0; i < items.length; ++i) {
                items[i] = itemHandler.rewrite(connection, items[i]);
            }
        }
    }

    protected void updateComponent(UserConnection connection, Item item, StructuredDataKey<Tag> key, String backupKey) {
        StructuredData<Tag> name = item.dataContainer().getNonEmpty(key);
        if (name == null) {
            return;
        }
        Tag originalName = name.value().copy();
        this.protocol.getComponentRewriter().processTag(connection, name.value());
        if (!name.value().equals(originalName)) {
            this.saveTag(this.createCustomTag(item), originalName, backupKey);
        }
    }

    protected void restoreTextComponents(Item item) {
        StructuredDataContainer data = item.dataContainer();
        StructuredData<CompoundTag> customData = data.getNonEmpty(StructuredDataKey.CUSTOM_DATA);
        if (customData == null) {
            return;
        }
        if (customData.value().remove(this.nbtTagName("added_custom_name")) != null) {
            data.remove(StructuredDataKey.CUSTOM_NAME);
        } else {
            Tag itemName;
            Tag customName = this.removeBackupTag(customData.value(), "custom_name");
            if (customName != null) {
                data.set(StructuredDataKey.CUSTOM_NAME, customName);
            }
            if ((itemName = this.removeBackupTag(customData.value(), "item_name")) != null) {
                data.set(StructuredDataKey.ITEM_NAME, itemName);
            }
        }
    }

    protected CompoundTag createCustomTag(Item item) {
        StructuredDataContainer data = item.dataContainer();
        StructuredData<CompoundTag> customData = data.getNonEmpty(StructuredDataKey.CUSTOM_DATA);
        if (customData != null) {
            return customData.value();
        }
        CompoundTag tag = new CompoundTag();
        data.set(StructuredDataKey.CUSTOM_DATA, tag);
        return tag;
    }

    protected void saveTag(CompoundTag customData, Tag tag, String name) {
        String backupName = this.nbtTagName(name);
        if (!customData.contains(backupName)) {
            customData.put(backupName, tag);
        }
    }

    protected @Nullable Tag removeBackupTag(CompoundTag customData, String tagName) {
        return customData.remove(this.nbtTagName(tagName));
    }

    @FunctionalInterface
    @NestHost(value=StructuredItemRewriter.class)
    public static interface ItemHandler {
        public Item rewrite(UserConnection var1, Item var2);
    }
}

