/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.rewriter.entitydata;

import Lcom.replaymod.replaystudio.lib.viaversion.api.minecraft.entities.EntityType;;
import Lcom.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata.EntityDataType;;
import Lcom.replaymod.replaystudio.lib.viaversion.rewriter.entitydata.EntityDataHandler;;
import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entities.EntityType;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata.EntityData;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata.EntityDataType;
import com.replaymod.replaystudio.lib.viaversion.libs.fastutil.ints.Int2ObjectFunction;
import com.replaymod.replaystudio.lib.viaversion.rewriter.EntityRewriter;
import com.replaymod.replaystudio.lib.viaversion.rewriter.entitydata.EntityDataHandler;
import com.replaymod.replaystudio.lib.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="type", type=EntityType;.class), @RecordComponents.Value(name="filterFamily", type=Z.class), @RecordComponents.Value(name="dataType", type=EntityDataType;.class), @RecordComponents.Value(name="index", type=I.class), @RecordComponents.Value(name="handler", type=EntityDataHandler;.class)})
@NestMembers(value={Builder.class})
public final class EntityDataFilter
extends J_L_Record {
    private final @Nullable EntityType type;
    private final boolean filterFamily;
    private final @Nullable EntityDataType dataType;
    private final int index;
    private final EntityDataHandler handler;

    public EntityDataFilter(@Nullable EntityType type, boolean filterFamily, @Nullable EntityDataType dataType, int index, EntityDataHandler handler) {
        Preconditions.checkNotNull(handler, "MetaHandler cannot be null");
        this.type = type;
        this.filterFamily = filterFamily;
        this.dataType = dataType;
        this.index = index;
        this.handler = handler;
    }

    public int index() {
        return this.index;
    }

    public @Nullable EntityType type() {
        return this.type;
    }

    public @Nullable EntityDataType dataType() {
        return this.dataType;
    }

    public EntityDataHandler handler() {
        return this.handler;
    }

    public boolean filterFamily() {
        return this.filterFamily;
    }

    public boolean isFiltered(@Nullable EntityType type, EntityData metadata) {
        return !(this.index != -1 && metadata.id() != this.index || this.type != null && !this.matchesType(type) || this.dataType != null && metadata.dataType() != this.dataType);
    }

    private boolean matchesType(EntityType type) {
        if (type == null) {
            return false;
        }
        return this.filterFamily ? type.isOrHasParent(this.type) : this.type == type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityDataFilter that = (EntityDataFilter)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.filterFamily != that.filterFamily) {
            return false;
        }
        if (!this.handler.equals(that.handler)) {
            return false;
        }
        if (!Objects.equals(this.dataType, that.dataType)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    @Override
    public int hashCode() {
        int result = this.handler.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        result = 31 * result + this.index;
        result = 31 * result + (this.filterFamily ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return EntityDataFilter.jvmdowngrader$concat$toString$1(this.type, this.filterFamily, this.dataType, this.index, this.handler);
    }

    private static String jvmdowngrader$concat$toString$1(EntityType entityType, boolean bl, EntityDataType entityDataType, int n, EntityDataHandler entityDataHandler) {
        return "EntityDataFilter{type=" + entityType + ", filterFamily=" + bl + ", dataType=" + entityDataType + ", index=" + n + ", handler=" + entityDataHandler + "}";
    }

    @NestHost(value=EntityDataFilter.class)
    public static final class Builder {
        private final EntityRewriter<?, ?> rewriter;
        private EntityType type;
        private EntityDataType dataType;
        private int index = -1;
        private boolean filterFamily;
        private EntityDataHandler handler;

        public Builder(EntityRewriter<?, ?> rewriter) {
            this.rewriter = rewriter;
        }

        public Builder dataType(EntityDataType dataType) {
            Preconditions.checkArgument(this.dataType == null);
            this.dataType = dataType;
            return this;
        }

        public Builder type(EntityType type) {
            Preconditions.checkArgument(this.type == null);
            this.type = type;
            this.filterFamily = true;
            return this;
        }

        public Builder exactType(EntityType type) {
            Preconditions.checkArgument(this.type == null);
            this.type = type;
            this.filterFamily = false;
            return this;
        }

        public Builder index(int index) {
            Preconditions.checkArgument(this.index == -1);
            this.index = index;
            return this;
        }

        public Builder handlerNoRegister(EntityDataHandler handler) {
            Preconditions.checkArgument(this.handler == null);
            this.handler = handler;
            return this;
        }

        public void handler(EntityDataHandler handler) {
            Preconditions.checkArgument(this.handler == null);
            this.handler = handler;
            this.register();
        }

        public void mapDataType(Int2ObjectFunction<EntityDataType> updateFunction) {
            this.handler((event, meta) -> {
                EntityDataType mappedType = (EntityDataType)updateFunction.apply(meta.dataType().typeId());
                if (mappedType != null) {
                    meta.setDataType(mappedType);
                } else {
                    event.cancel();
                }
            });
        }

        public void cancel(int index) {
            this.index = index;
            this.handler((event, meta) -> event.cancel());
        }

        public void toIndex(int newIndex) {
            Preconditions.checkArgument(this.index != -1);
            this.handler((event, meta) -> event.setIndex(newIndex));
        }

        public void addIndex(int index) {
            Preconditions.checkArgument(this.index == -1);
            this.handler((event, meta) -> {
                if (event.index() >= index) {
                    event.setIndex(event.index() + 1);
                }
            });
        }

        public void removeIndex(int index) {
            Preconditions.checkArgument(this.index == -1);
            this.handler((event, meta) -> {
                int metaIndex = event.index();
                if (metaIndex == index) {
                    event.cancel();
                } else if (metaIndex > index) {
                    event.setIndex(metaIndex - 1);
                }
            });
        }

        public void register() {
            this.rewriter.registerFilter(this.build());
        }

        public EntityDataFilter build() {
            return new EntityDataFilter(this.type, this.filterFamily, this.dataType, this.index, this.handler);
        }
    }
}

