/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.util;

import com.replaymod.replaystudio.lib.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_CharSequence;
import java.util.regex.Pattern;

public final class Key {
    private static final Pattern PATTERN = Pattern.compile("([0-9a-z_.-]*:)?[0-9a-z_/.-]*");
    private static final int MINECRAFT_NAMESPACE_LENGTH = "minecraft:".length();

    public static String stripNamespace(String identifier) {
        int index = identifier.indexOf(58);
        if (index == -1) {
            return identifier;
        }
        return identifier.substring(index + 1);
    }

    public static String stripMinecraftNamespace(String identifier) {
        if (identifier.startsWith("minecraft:")) {
            return identifier.substring(MINECRAFT_NAMESPACE_LENGTH);
        }
        if (!J_L_CharSequence.isEmpty(identifier) && identifier.charAt(0) == ':') {
            return identifier.substring(1);
        }
        return identifier;
    }

    public static boolean equals(String firstIdentifier, String secondIdentifier) {
        return Key.stripMinecraftNamespace(firstIdentifier).equals(Key.stripMinecraftNamespace(secondIdentifier));
    }

    public static String namespaced(String identifier) {
        int index = identifier.indexOf(58);
        if (index == -1) {
            return Key.jvmdowngrader$concat$namespaced$1(identifier);
        }
        if (index == 0) {
            return Key.jvmdowngrader$concat$namespaced$2(identifier);
        }
        return identifier;
    }

    public static boolean isValid(String identifier) {
        return PATTERN.matcher(identifier).matches();
    }

    private static String jvmdowngrader$concat$namespaced$1(String string) {
        return "minecraft:" + string;
    }

    private static String jvmdowngrader$concat$namespaced$2(String string) {
        return "minecraft" + string;
    }
}

