/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.change;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.guava.collect.Iterables;
import com.replaymod.replaystudio.pathing.change.Change;
import com.replaymod.replaystudio.pathing.interpolation.Interpolator;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.PathSegment;
import com.replaymod.replaystudio.pathing.path.Timeline;
import lombok.NonNull;

public final class SetInterpolator
implements Change {
    private final int path;
    private final int index;
    private final Interpolator interpolator;
    private Interpolator oldInterpolator;
    private boolean applied;

    @NonNull
    public static SetInterpolator create(PathSegment segment, Interpolator interpolator) {
        Path path = segment.getPath();
        return new SetInterpolator(path.getTimeline().getPaths().indexOf(path), Iterables.indexOf(path.getSegments(), segment::equals), interpolator);
    }

    SetInterpolator(int path, int index, Interpolator interpolator) {
        this.path = path;
        this.index = index;
        this.interpolator = interpolator;
    }

    @Override
    public void apply(Timeline timeline) {
        Preconditions.checkState(!this.applied, "Already applied!");
        Path path = timeline.getPaths().get(this.path);
        PathSegment segment = Iterables.get(path.getSegments(), this.index);
        this.oldInterpolator = segment.getInterpolator();
        segment.setInterpolator(this.interpolator);
        this.applied = true;
    }

    @Override
    public void undo(Timeline timeline) {
        Preconditions.checkState(this.applied, "Not yet applied!");
        Path path = timeline.getPaths().get(this.path);
        PathSegment segment = Iterables.get(path.getSegments(), this.index);
        segment.setInterpolator(this.oldInterpolator);
        this.applied = false;
    }
}

