/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.impl;

import com.replaymod.replaystudio.pathing.change.Change;
import com.replaymod.replaystudio.pathing.impl.PathImpl;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.pathing.property.Property;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TimelineImpl
implements Timeline {
    private final List<Path> paths = new ArrayList<Path>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Deque<Change> undoStack = new ArrayDeque<Change>();
    private Deque<Change> redoStack = new ArrayDeque<Change>();

    @Override
    public List<Path> getPaths() {
        return this.paths;
    }

    @Override
    public Path createPath() {
        PathImpl path = new PathImpl(this);
        this.paths.add(path);
        return path;
    }

    @Override
    public <T> Optional<T> getValue(Property<T> property, long time) {
        for (Path path : this.paths) {
            Optional<T> value;
            if (!path.isActive() || !(value = path.getValue(property, time)).isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    @Override
    public void applyToGame(long time, Object replayHandler) {
        for (Property property : this.properties.values()) {
            this.applyToGame(time, replayHandler, property);
        }
    }

    private <T> void applyToGame(long time, Object replayHandler, Property<T> property) {
        Optional<T> value = this.getValue(property, time);
        if (value.isPresent()) {
            property.applyToGame(value.get(), replayHandler);
        }
    }

    @Override
    public void registerProperty(Property property) {
        String id = (property.getGroup() == null ? "" : property.getGroup().getId() + ":") + property.getId();
        this.properties.put(id, property);
    }

    @Override
    public Property getProperty(String id) {
        return this.properties.get(id);
    }

    @Override
    public void applyChange(Change change) {
        change.apply(this);
        this.pushChange(change);
    }

    @Override
    public void pushChange(Change change) {
        this.undoStack.push(change);
        this.redoStack.clear();
    }

    @Override
    public void undoLastChange() {
        Change change = this.undoStack.pop();
        change.undo(this);
        this.redoStack.push(change);
    }

    @Override
    public void redoLastChange() {
        Change change = this.redoStack.pop();
        change.apply(this);
        this.undoStack.push(change);
    }

    @Override
    public Change peekUndoStack() {
        return this.undoStack.peek();
    }

    @Override
    public Change peekRedoStack() {
        return this.redoStack.peek();
    }
}

