/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.interpolation;

import com.replaymod.replaystudio.pathing.interpolation.AbstractInterpolator;
import com.replaymod.replaystudio.pathing.interpolation.InterpolationParameters;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.PathSegment;
import com.replaymod.replaystudio.pathing.property.Property;
import com.replaymod.replaystudio.pathing.property.PropertyPart;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class PolynomialSplineInterpolator
extends AbstractInterpolator {
    private final int degree;
    private Map<Property<?>, Set<Keyframe>> framesToProperty = new HashMap();
    private Map<PropertyPart, Polynomials> polynomials = new HashMap<PropertyPart, Polynomials>();

    protected PolynomialSplineInterpolator(int degree) {
        this.degree = degree;
    }

    @Override
    protected Map<PropertyPart, InterpolationParameters> bakeInterpolation(Map<PropertyPart, InterpolationParameters> parameters) {
        this.framesToProperty.clear();
        for (PathSegment pathSegment : this.getSegments()) {
            for (Property property : this.getKeyframeProperties()) {
                if (pathSegment.getStartKeyframe().getValue(property).isPresent()) {
                    this.addToMap(this.framesToProperty, property, pathSegment.getStartKeyframe());
                }
                if (!pathSegment.getEndKeyframe().getValue(property).isPresent()) continue;
                this.addToMap(this.framesToProperty, property, pathSegment.getEndKeyframe());
            }
        }
        this.polynomials.clear();
        parameters = new HashMap<PropertyPart, InterpolationParameters>(parameters);
        for (Map.Entry entry : this.framesToProperty.entrySet()) {
            this.prepareProperty((Property)entry.getKey(), (Set)entry.getValue(), parameters);
        }
        return parameters;
    }

    private <U> void prepareProperty(Property<U> property, Set<Keyframe> keyframes, Map<PropertyPart, InterpolationParameters> parameters) {
        for (PropertyPart<U> part : property.getParts()) {
            if (!part.isInterpolatable()) continue;
            double[] time = new double[keyframes.size()];
            double[] values = new double[keyframes.size()];
            int i = 0;
            for (Keyframe keyframe : keyframes) {
                time[i] = keyframe.getTime();
                values[i++] = part.toDouble(keyframe.getValue(property).get());
            }
            Polynomials polynomials = this.calcPolynomials(part, time, values, parameters.get(part));
            double lastTime = time[time.length - 1];
            Polynomial lastPolynomial = polynomials.polynomials[polynomials.polynomials.length - 1];
            double lastValue = lastPolynomial.eval(lastTime) + polynomials.yOffset;
            lastPolynomial = lastPolynomial.derivative();
            double lastVelocity = lastPolynomial.eval(lastTime);
            double lastAcceleration = lastPolynomial.derivative().eval(lastTime);
            parameters.put(part, new InterpolationParameters(lastValue, lastVelocity, lastAcceleration));
            this.polynomials.put(part, polynomials);
        }
    }

    private void addToMap(Map<Property<?>, Set<Keyframe>> map, Property property, Keyframe keyframe) {
        Set<Keyframe> set = map.get(property);
        if (set == null) {
            set = new LinkedHashSet<Keyframe>();
            map.put(property, set);
        }
        set.add(keyframe);
    }

    protected <U> Polynomials calcPolynomials(PropertyPart<U> part, double[] xs, double[] ys, InterpolationParameters params) {
        double yOffset;
        int unknowns = this.degree + 1;
        int num = xs.length - 1;
        if (num == 0) {
            return new Polynomials(0.0, new Polynomial[]{new Polynomial(new double[]{ys[0]})});
        }
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] / 1000.0;
        }
        if (Double.isNaN(part.getUpperBound())) {
            double total = 0.0;
            for (double y : ys) {
                total += y;
            }
            yOffset = total / (double)ys.length;
            int i2 = 0;
            while (i2 < ys.length) {
                int n = i2++;
                ys[n] = ys[n] - yOffset;
            }
            if (params != null) {
                params = new InterpolationParameters(params.getValue() - yOffset, params.getVelocity(), params.getAcceleration());
            }
        } else {
            double bound = part.getUpperBound();
            double halfBound = bound / 2.0;
            double firstValue = params != null ? params.getValue() : ys[0];
            int offset = (int)Math.floor(firstValue / bound);
            double lastValue = this.mod(firstValue, bound);
            for (int i3 = 1; i3 < ys.length; ++i3) {
                double value = this.mod(ys[i3], bound);
                if (Math.abs(value - lastValue) > halfBound) {
                    offset = lastValue < halfBound ? --offset : ++offset;
                }
                ys[i3] = value + (double)offset * bound;
                lastValue = value;
            }
            yOffset = 0.0;
        }
        double[][] matrix = new double[num * unknowns][num * unknowns + 1];
        this.fillMatrix(matrix, xs, ys, num, params);
        PolynomialSplineInterpolator.solveMatrix(matrix);
        Polynomial[] polynomials = new Polynomial[num];
        for (int i4 = 0; i4 < num; ++i4) {
            double[] coefficients = new double[this.degree + 1];
            for (int j = 0; j <= this.degree; ++j) {
                coefficients[j] = matrix[i4 * unknowns + j][num * unknowns];
            }
            polynomials[i4] = new Polynomial(coefficients);
        }
        return new Polynomials(yOffset, polynomials);
    }

    private double mod(double val, double m) {
        double off = Math.floor(val / m);
        return val - off * m;
    }

    protected abstract void fillMatrix(double[][] var1, double[] var2, double[] var3, int var4, InterpolationParameters var5);

    protected static void solveMatrix(double[][] matrix) {
        int i;
        for (i = 0; i < matrix.length; ++i) {
            int j;
            double factor;
            if (matrix[i][i] == 0.0) {
                for (int j2 = i + 1; j2 < matrix.length; ++j2) {
                    if (matrix[j2][i] == 0.0) continue;
                    double[] s = matrix[j2];
                    matrix[j2] = matrix[i];
                    matrix[i] = s;
                    break;
                }
            }
            if ((factor = matrix[i][i]) != 1.0) {
                matrix[i][i] = 1.0;
                j = i + 1;
                while (j < matrix[i].length) {
                    double[] dArray = matrix[i];
                    int n = j++;
                    dArray[n] = dArray[n] / factor;
                }
            }
            for (j = i + 1; j < matrix.length; ++j) {
                factor = matrix[j][i];
                if (factor == 0.0) continue;
                matrix[j][i] = 0.0;
                for (int k = i + 1; k < matrix[j].length; ++k) {
                    matrix[j][k] = matrix[j][k] - matrix[i][k] * factor;
                }
            }
        }
        for (i = matrix.length - 1; i >= 0; --i) {
            for (int j = i - 1; j >= 0; --j) {
                if (matrix[j][i] == 0.0) continue;
                int k = matrix[j].length - 1;
                double[] dArray = matrix[j];
                int n = k;
                dArray[n] = dArray[n] - matrix[j][i] / matrix[i][i] * matrix[i][k];
                matrix[j][i] = 0.0;
            }
        }
    }

    @Override
    public <T> Optional<T> getValue(Property<T> property, long time) {
        Set<Keyframe> kfSet = this.framesToProperty.get(property);
        if (kfSet == null) {
            return Optional.empty();
        }
        Keyframe kfBefore = null;
        Keyframe kfAfter = null;
        int index = 0;
        for (Keyframe keyframe : kfSet) {
            if (keyframe.getTime() == time) {
                return keyframe.getValue(property);
            }
            if (keyframe.getTime() < time) {
                kfBefore = keyframe;
            } else if (keyframe.getTime() > time) {
                kfAfter = keyframe;
                --index;
                break;
            }
            ++index;
        }
        if (kfBefore == null || kfAfter == null) {
            return Optional.empty();
        }
        T interpolated = kfBefore.getValue(property).get();
        for (PropertyPart<T> part : property.getParts()) {
            if (!part.isInterpolatable()) continue;
            double value = this.polynomials.get(part).eval(time, index);
            if (!Double.isNaN(part.getUpperBound())) {
                value = this.mod(value, part.getUpperBound());
            }
            interpolated = part.fromDouble(interpolated, value);
        }
        return Optional.of(interpolated);
    }

    public static class Polynomial {
        public final double[] coefficients;

        public Polynomial(double[] coefficients) {
            this.coefficients = coefficients;
        }

        public double eval(double at) {
            double val = 0.0;
            for (double coefficient : this.coefficients) {
                val = val * at + coefficient;
            }
            return val;
        }

        public Polynomial derivative() {
            if (this.coefficients.length == 0) {
                return this;
            }
            Polynomial derived = new Polynomial(new double[this.coefficients.length - 1]);
            for (int i = 0; i < this.coefficients.length - 1; ++i) {
                derived.coefficients[i] = this.coefficients[i] * (double)(this.coefficients.length - 1 - i);
            }
            return derived;
        }
    }

    private static class Polynomials {
        private final double yOffset;
        private final Polynomial[] polynomials;

        private Polynomials(double yOffset, Polynomial[] polynomials) {
            this.yOffset = yOffset;
            this.polynomials = polynomials;
        }

        public double eval(double time, int index) {
            return this.polynomials[index].eval(time / 1000.0) + this.yOffset;
        }
    }
}

