/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.property;

import com.replaymod.replaystudio.pathing.property.Property;
import com.replaymod.replaystudio.pathing.property.PropertyGroup;
import com.replaymod.replaystudio.util.I18n;

public abstract class AbstractProperty<T>
implements Property<T> {
    private final String id;
    private final String localizationKey;
    private final PropertyGroup propertyGroup;
    private final T initialValue;

    public AbstractProperty(String id, String localizationKey, PropertyGroup propertyGroup, T initialValue) {
        this.id = id;
        this.localizationKey = localizationKey;
        this.propertyGroup = propertyGroup;
        this.initialValue = initialValue;
        if (propertyGroup != null) {
            propertyGroup.getProperties().add(this);
        }
    }

    @Override
    public String getLocalizedName() {
        return I18n.format(this.localizationKey, new Object[0]);
    }

    @Override
    public PropertyGroup getGroup() {
        return this.propertyGroup;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public T getNewValue() {
        return this.initialValue;
    }
}

