/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.property;

import com.replaymod.replaystudio.pathing.property.AbstractPropertyPart;
import com.replaymod.replaystudio.pathing.property.Property;
import org.apache.commons.lang3.tuple.Triple;

public class PropertyParts {
    private PropertyParts() {
    }

    public static enum TripleElement {
        LEFT,
        MIDDLE,
        RIGHT;

    }

    public static class ForFloatTriple
    extends AbstractPropertyPart<Triple<Float, Float, Float>> {
        private final TripleElement element;

        public ForFloatTriple(Property<Triple<Float, Float, Float>> property, boolean interpolatable, TripleElement element) {
            super(property, interpolatable);
            this.element = element;
        }

        public ForFloatTriple(Property<Triple<Float, Float, Float>> property, boolean interpolatable, float upperBound, TripleElement element) {
            super(property, interpolatable, upperBound);
            this.element = element;
        }

        @Override
        public double toDouble(Triple<Float, Float, Float> value) {
            switch (this.element) {
                case LEFT: {
                    return ((Float)value.getLeft()).floatValue();
                }
                case MIDDLE: {
                    return ((Float)value.getMiddle()).floatValue();
                }
                case RIGHT: {
                    return ((Float)value.getRight()).floatValue();
                }
            }
            throw new AssertionError((Object)this.element);
        }

        @Override
        public Triple<Float, Float, Float> fromDouble(Triple<Float, Float, Float> value, double d) {
            switch (this.element) {
                case LEFT: {
                    return Triple.of((Object)Float.valueOf((float)d), (Object)value.getMiddle(), (Object)value.getRight());
                }
                case MIDDLE: {
                    return Triple.of((Object)value.getLeft(), (Object)Float.valueOf((float)d), (Object)value.getRight());
                }
                case RIGHT: {
                    return Triple.of((Object)value.getLeft(), (Object)value.getMiddle(), (Object)Float.valueOf((float)d));
                }
            }
            throw new AssertionError((Object)this.element);
        }
    }

    public static class ForDoubleTriple
    extends AbstractPropertyPart<Triple<Double, Double, Double>> {
        private final TripleElement element;

        public ForDoubleTriple(Property<Triple<Double, Double, Double>> property, boolean interpolatable, TripleElement element) {
            super(property, interpolatable);
            this.element = element;
        }

        public ForDoubleTriple(Property<Triple<Double, Double, Double>> property, boolean interpolatable, double upperBound, TripleElement element) {
            super(property, interpolatable, upperBound);
            this.element = element;
        }

        @Override
        public double toDouble(Triple<Double, Double, Double> value) {
            switch (this.element) {
                case LEFT: {
                    return (Double)value.getLeft();
                }
                case MIDDLE: {
                    return (Double)value.getMiddle();
                }
                case RIGHT: {
                    return (Double)value.getRight();
                }
            }
            throw new AssertionError((Object)this.element);
        }

        @Override
        public Triple<Double, Double, Double> fromDouble(Triple<Double, Double, Double> value, double d) {
            switch (this.element) {
                case LEFT: {
                    return Triple.of((Object)d, (Object)value.getMiddle(), (Object)value.getRight());
                }
                case MIDDLE: {
                    return Triple.of((Object)value.getLeft(), (Object)d, (Object)value.getRight());
                }
                case RIGHT: {
                    return Triple.of((Object)value.getLeft(), (Object)value.getMiddle(), (Object)d);
                }
            }
            throw new AssertionError((Object)this.element);
        }
    }

    public static class ForInteger
    extends AbstractPropertyPart<Integer> {
        public ForInteger(Property<Integer> property, boolean interpolatable) {
            super(property, interpolatable);
        }

        public ForInteger(Property<Integer> property, boolean interpolatable, int upperBound) {
            super(property, interpolatable, upperBound);
        }

        @Override
        public double toDouble(Integer value) {
            return value.intValue();
        }

        @Override
        public Integer fromDouble(Integer value, double d) {
            return (int)Math.round(d);
        }
    }
}

