/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.ByteBufInputStream;
import com.github.steveice10.netty.buffer.ByteBufOutputStream;
import com.github.steveice10.netty.buffer.Unpooled;
import com.github.steveice10.opennbt.NBTIO;
import com.github.steveice10.opennbt.tag.TagCreateException;
import com.github.steveice10.opennbt.tag.TagRegistry;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetInput;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetOutput;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.data.StringOrNbtText;
import com.replaymod.replaystudio.util.IGlobalPosition;
import com.replaymod.replaystudio.util.IOConsumer;
import com.replaymod.replaystudio.util.IOSupplier;
import com.replaymod.replaystudio.util.IPosition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Packet {
    private final PacketTypeRegistry registry;
    private final int id;
    private final PacketType type;
    private final ByteBuf buf;

    public Packet(PacketTypeRegistry registry, PacketType type) {
        this(registry, type, Unpooled.buffer());
    }

    public Packet(PacketTypeRegistry registry, PacketType type, ByteBuf buf) {
        this(registry, registry.getId(type), type, buf);
    }

    public Packet(PacketTypeRegistry registry, int packetId, ByteBuf buf) {
        this(registry, packetId, registry.getType(packetId), buf);
    }

    public Packet(PacketTypeRegistry registry, int id, PacketType type, ByteBuf buf) {
        this.registry = registry;
        this.id = id;
        this.type = type;
        this.buf = buf;
    }

    public PacketTypeRegistry getRegistry() {
        return this.registry;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.registry.getVersion();
    }

    public int getId() {
        return this.id;
    }

    public PacketType getType() {
        return this.type;
    }

    public ByteBuf getBuf() {
        return this.buf;
    }

    public Packet retain() {
        this.buf.retain();
        return this;
    }

    public Packet copy() {
        return new Packet(this.registry, this.id, this.type, this.buf.retainedSlice());
    }

    public boolean release() {
        return this.buf.release();
    }

    public Reader reader() {
        return new Reader(this, this.buf);
    }

    public Writer overwrite() {
        this.buf.writerIndex(this.buf.readerIndex());
        return new Writer(this, this.buf);
    }

    public boolean atLeast(ProtocolVersion protocolVersion) {
        return this.registry.atLeast(protocolVersion);
    }

    public boolean atMost(ProtocolVersion protocolVersion) {
        return this.registry.atMost(protocolVersion);
    }

    public boolean olderThan(ProtocolVersion protocolVersion) {
        return this.registry.olderThan(protocolVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Packet packet = (Packet)o;
        return this.id == packet.id && this.registry.equals(packet.registry) && this.buf.equals(packet.buf);
    }

    public int hashCode() {
        return Objects.hash(this.registry, this.id, this.buf);
    }

    public static class Writer
    extends ByteBufNetOutput
    implements AutoCloseable {
        private final Packet packet;
        private final ByteBuf buf;

        private Writer(Packet packet, ByteBuf buf) {
            super(buf);
            this.packet = packet;
            this.buf = buf;
        }

        @Override
        public void close() {
        }

        public void writePosition(IPosition pos) throws IOException {
            Writer.writePosition(this.packet.registry, this, pos);
        }

        public static void writePosition(PacketTypeRegistry registry, NetOutput out, IPosition pos) throws IOException {
            long x = pos.getX() & 0x3FFFFFF;
            long y = pos.getY() & 0xFFF;
            long z = pos.getZ() & 0x3FFFFFF;
            if (registry.atLeast(ProtocolVersion.v1_14)) {
                out.writeLong(x << 38 | z << 12 | y);
            } else {
                out.writeLong(x << 38 | y << 26 | z);
            }
        }

        public void writeGlobalPosition(IGlobalPosition pos) throws IOException {
            Writer.writeGlobalPosition(this.packet.registry, this, pos);
        }

        public static void writeGlobalPosition(PacketTypeRegistry registry, NetOutput out, IGlobalPosition pos) throws IOException {
            out.writeString(pos.getDimension());
            Writer.writePosition(registry, out, pos.getPosition());
        }

        public void writeNBT(Tag tag) throws IOException {
            Writer.writeNBT(this.packet.registry, this, tag);
        }

        public static void writeNBT(PacketTypeRegistry registry, final NetOutput out, Tag tag) throws IOException {
            if (registry.atLeast(ProtocolVersion.v1_8)) {
                if (tag == null) {
                    out.writeByte(0);
                } else {
                    Writer.writeNbtInner(registry, new DataOutputStream(new OutputStream(){

                        @Override
                        public void write(int b) throws IOException {
                            out.writeByte(b);
                        }
                    }), tag);
                }
            } else {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                GZIPOutputStream gzip = new GZIPOutputStream(output);
                Writer.writeNbtInner(registry, new DataOutputStream(gzip), tag);
                gzip.close();
                output.close();
                byte[] bytes = output.toByteArray();
                out.writeShort(bytes.length);
                out.writeBytes(bytes);
            }
        }

        private static void writeNbtInner(PacketTypeRegistry registry, DataOutputStream out, Tag tag) throws IOException {
            out.writeByte(tag.getTagId());
            if (registry.olderThan(ProtocolVersion.v1_20_2)) {
                out.writeUTF("");
            }
            tag.write((DataOutput)out);
        }

        public void writeBitSet(BitSet bitSet) throws IOException {
            Writer.writeBitSet(this.packet.registry, this, bitSet);
        }

        public static void writeBitSet(PacketTypeRegistry registry, NetOutput out, BitSet bitSet) throws IOException {
            if (registry.atLeast(ProtocolVersion.v1_17)) {
                long[] longs = bitSet.toLongArray();
                out.writeVarInt(longs.length);
                out.writeLongs(longs);
            } else {
                long value;
                long[] longs = bitSet.toLongArray();
                if (longs.length == 0) {
                    value = 0L;
                } else if (longs.length == 1) {
                    value = longs[0];
                } else {
                    throw new IllegalArgumentException("Pre-1.17 bitset cannot encode more than 64 bits.");
                }
                if (registry.atLeast(ProtocolVersion.v1_9)) {
                    out.writeVarInt((int)value);
                } else {
                    out.writeShort((int)value);
                }
            }
        }

        public <T> void writeList(List<T> list, IOConsumer<T> entryWriter) throws IOException {
            Writer.writeList(this.packet.registry, this, list, entryWriter);
        }

        public static <T> void writeList(PacketTypeRegistry registry, NetOutput out, List<T> list, IOConsumer<T> entryWriter) throws IOException {
            out.writeVarInt(list.size());
            for (T entry : list) {
                entryWriter.consume(entry);
            }
        }

        public void writeText(StringOrNbtText value) throws IOException {
            if (this.packet.atLeast(ProtocolVersion.v1_20_3)) {
                if (value.nbt == null) {
                    this.writeByte(0);
                } else {
                    this.writeByte(value.nbt.getTagId());
                    value.nbt.write((DataOutput)new DataOutputStream(new ByteBufOutputStream(this.buf)));
                }
            } else {
                this.writeString(value.str);
            }
        }
    }

    public static class Reader
    extends ByteBufNetInput
    implements AutoCloseable {
        private final Packet packet;
        private final ByteBuf buf;
        private int orgReaderIndex;

        Reader(Packet packet, ByteBuf buf) {
            super(buf);
            this.packet = packet;
            this.buf = buf;
            this.orgReaderIndex = buf.readerIndex();
        }

        @Override
        public void close() {
            this.buf.readerIndex(this.orgReaderIndex);
        }

        public IPosition readPosition() throws IOException {
            return Reader.readPosition(this.packet.registry, this);
        }

        public static IPosition readPosition(PacketTypeRegistry registry, NetInput in) throws IOException {
            long z;
            long y;
            long x;
            long val = in.readLong();
            if (registry.atLeast(ProtocolVersion.v1_14)) {
                x = val >> 38;
                y = val;
                z = val >> 12;
            } else {
                x = val >> 38;
                y = val >> 26;
                z = val;
            }
            return new IPosition((int)(x << 38 >> 38), (int)(y << 52 >> 52), (int)(z << 38 >> 38));
        }

        public IGlobalPosition readGlobalPosition() throws IOException {
            return Reader.readGlobalPosition(this.packet.registry, this);
        }

        public static IGlobalPosition readGlobalPosition(PacketTypeRegistry registry, NetInput in) throws IOException {
            String dimension = in.readString();
            return new IGlobalPosition(dimension, Reader.readPosition(registry, in));
        }

        public CompoundTag readNBT() throws IOException {
            return Reader.readNBT(this.packet.registry, this);
        }

        public static CompoundTag readNBT(final PacketTypeRegistry registry, final NetInput in) throws IOException {
            if (registry.atLeast(ProtocolVersion.v1_8)) {
                final byte type = in.readByte();
                if (type == 0) {
                    return null;
                }
                return NBTIO.readTag((InputStream)new InputStream(){
                    private int read;

                    @Override
                    public int read() throws IOException {
                        int index;
                        if ((index = this.read++) == 0) {
                            return type & 0xFF;
                        }
                        if ((index == 1 || index == 2) && registry.atLeast(ProtocolVersion.v1_20_2)) {
                            return 0;
                        }
                        return in.readUnsignedByte();
                    }
                });
            }
            short length = in.readShort();
            if (length < 0) {
                return null;
            }
            return NBTIO.readTag((InputStream)new GZIPInputStream(new ByteArrayInputStream(in.readBytes(length))));
        }

        public BitSet readBitSet() throws IOException {
            return Reader.readBitSet(this.packet.registry, this);
        }

        public static BitSet readBitSet(PacketTypeRegistry registry, NetInput in) throws IOException {
            if (registry.atLeast(ProtocolVersion.v1_17)) {
                return BitSet.valueOf(in.readLongs(in.readVarInt()));
            }
            if (registry.atLeast(ProtocolVersion.v1_9)) {
                int value = in.readVarInt();
                return BitSet.valueOf(new long[]{value &= Integer.MAX_VALUE});
            }
            return BitSet.valueOf(new long[]{in.readUnsignedShort()});
        }

        public <T> List<T> readList(IOSupplier<T> entryReader) throws IOException {
            return Reader.readList(this.packet.registry, this, entryReader);
        }

        public static <T> List<T> readList(PacketTypeRegistry registry, NetInput in, IOSupplier<T> entryReader) throws IOException {
            int len = in.readVarInt();
            ArrayList<T> result = new ArrayList<T>(len);
            for (int i = 0; i < len; ++i) {
                result.add(entryReader.get());
            }
            return result;
        }

        public StringOrNbtText readText() throws IOException {
            if (this.packet.atLeast(ProtocolVersion.v1_20_3)) {
                Tag tag;
                byte id = this.readByte();
                if (id == 0) {
                    tag = null;
                } else {
                    try {
                        tag = TagRegistry.createInstance((int)id);
                    }
                    catch (TagCreateException e) {
                        throw new IOException("Failed to create tag.", e);
                    }
                    tag.read((DataInput)new DataInputStream(new ByteBufInputStream(this.buf)));
                }
                return new StringOrNbtText(tag);
            }
            return new StringOrNbtText(this.readString());
        }
    }
}

