/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PacketDestroyEntities {
    public static List<Integer> getEntityIds(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            if (packet.getType() == PacketType.DestroyEntity) {
                List<Integer> list = Collections.singletonList(in.readVarInt());
                return list;
            }
            int len = packet.atLeast(ProtocolVersion.v1_8) ? in.readVarInt() : (int)in.readByte();
            ArrayList<Integer> result = new ArrayList<Integer>(len);
            for (int i = 0; i < len; ++i) {
                result.add(packet.atLeast(ProtocolVersion.v1_8) ? in.readVarInt() : in.readInt());
            }
            ArrayList<Integer> arrayList = result;
            return arrayList;
        }
    }

    public static Collection<Packet> write(PacketTypeRegistry registry, int ... entityIds) throws IOException {
        if (registry.atLeast(ProtocolVersion.v1_17) && registry.olderThan(ProtocolVersion.v1_17_1)) {
            ArrayList<Packet> packets = new ArrayList<Packet>(entityIds.length);
            for (int entityId : entityIds) {
                packets.add(PacketDestroyEntities.write(registry, entityId));
            }
            return packets;
        }
        return Collections.singletonList(PacketDestroyEntities.writeDestroyEntities(registry, entityIds));
    }

    public static Packet write(PacketTypeRegistry registry, int entityId) throws IOException {
        if (registry.atLeast(ProtocolVersion.v1_17) && registry.olderThan(ProtocolVersion.v1_17_1)) {
            Packet packet = new Packet(registry, PacketType.DestroyEntity);
            try (Packet.Writer out = packet.overwrite();){
                out.writeVarInt(entityId);
            }
            return packet;
        }
        return PacketDestroyEntities.writeDestroyEntities(registry, entityId);
    }

    private static Packet writeDestroyEntities(PacketTypeRegistry registry, int ... entityIds) throws IOException {
        Packet packet = new Packet(registry, PacketType.DestroyEntities);
        try (Packet.Writer out = packet.overwrite();){
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                out.writeVarInt(entityIds.length);
            } else {
                out.writeByte(entityIds.length);
            }
            for (int entityId : entityIds) {
                if (packet.atLeast(ProtocolVersion.v1_8)) {
                    out.writeVarInt(entityId);
                    continue;
                }
                out.writeInt(entityId);
            }
        }
        return packet;
    }
}

