/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.util.Property;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

public class PacketLoginSuccess {
    private final UUID id;
    private final String name;
    private final List<Property> properties;
    private final boolean strictErrorHandling;

    public PacketLoginSuccess(UUID id, String name, List<Property> properties, boolean strictErrorHandling) {
        this.id = id;
        this.name = name;
        this.properties = properties;
        this.strictErrorHandling = strictErrorHandling;
    }

    public static PacketLoginSuccess read(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            UUID id = packet.atLeast(ProtocolVersion.v1_16) ? in.readUUID() : UUID.fromString(in.readString());
            String name = in.readString();
            List<Property> properties = null;
            if (packet.atLeast(ProtocolVersion.v1_19)) {
                properties = in.readList(() -> Property.read(in));
            }
            boolean strictErrorHandling = false;
            if (packet.atLeast(ProtocolVersion.v1_20_5)) {
                strictErrorHandling = in.readBoolean();
            }
            PacketLoginSuccess packetLoginSuccess = new PacketLoginSuccess(id, name, properties, strictErrorHandling);
            return packetLoginSuccess;
        }
    }

    public Packet write(PacketTypeRegistry registry) throws IOException {
        Packet packet = new Packet(registry, PacketType.LoginSuccess);
        try (Packet.Writer out = packet.overwrite();){
            if (packet.atLeast(ProtocolVersion.v1_16)) {
                out.writeUUID(this.id);
            } else {
                out.writeString(this.id.toString());
            }
            out.writeString(this.name);
            if (packet.atLeast(ProtocolVersion.v1_19)) {
                out.writeList(this.properties, it -> it.write(out));
            }
            if (packet.atLeast(ProtocolVersion.v1_20_5)) {
                out.writeBoolean(this.strictErrorHandling);
            }
        }
        return packet;
    }
}

