/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.registry;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.NumberTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.data.VersionedIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class Registries {
    public CompoundTag registriesTag;
    public Map<String, List<Pair<String, Tag>>> registriesMap;
    public List<VersionedIdentifier> enabledPacks;

    public Registries() {
    }

    public Registries(CompoundTag tag) {
        this.registriesTag = tag;
    }

    public Registries copy() {
        Registries copy = new Registries();
        copy.registriesTag = this.registriesTag != null ? this.registriesTag.clone() : null;
        copy.registriesMap = this.registriesMap != null ? new HashMap<String, List<Pair<String, Tag>>>(this.registriesMap) : null;
        copy.enabledPacks = this.enabledPacks != null ? new ArrayList<VersionedIdentifier>(this.enabledPacks) : null;
        return copy;
    }

    public Entry getEntry(String registryName, String entryName) {
        if (this.registriesTag != null) {
            CompoundTag registry = (CompoundTag)this.registriesTag.get(registryName);
            if (registry == null) {
                return null;
            }
            ListTag entries = (ListTag)registry.get("value");
            if (entries == null) {
                return null;
            }
            for (Tag entry : entries) {
                StringTag name = (StringTag)((CompoundTag)entry).get("name");
                if (name == null || !name.getValue().equals(entryName)) continue;
                NumberTag id = (NumberTag)((CompoundTag)entry).get("id");
                Tag value = ((CompoundTag)entry).get("element");
                return new Entry(id == null ? 0 : id.asInt(), name.getValue(), value);
            }
            return null;
        }
        if (this.registriesMap != null) {
            List<Pair<String, Tag>> registry = this.registriesMap.get(registryName);
            if (registry == null) {
                return null;
            }
            int id = 0;
            for (Pair<String, Tag> entry : registry) {
                if (((String)entry.getKey()).equals(entryName)) {
                    return new Entry(id, (String)entry.getKey(), (Tag)entry.getValue());
                }
                ++id;
            }
            return null;
        }
        return null;
    }

    public Entry getEntry(String registryName, int entryId) {
        if (this.registriesTag != null) {
            CompoundTag registry = (CompoundTag)this.registriesTag.get(registryName);
            if (registry == null) {
                return null;
            }
            ListTag entries = (ListTag)registry.get("value");
            if (entries == null) {
                return null;
            }
            for (Tag entry : entries) {
                NumberTag id = (NumberTag)((CompoundTag)entry).get("id");
                if (id == null || id.asInt() != entryId) continue;
                StringTag name = (StringTag)((CompoundTag)entry).get("name");
                Tag value = ((CompoundTag)entry).get("element");
                return new Entry(id.asInt(), name != null ? name.getValue() : "", value);
            }
            return null;
        }
        if (this.registriesMap != null) {
            List<Pair<String, Tag>> registry = this.registriesMap.get(registryName);
            if (registry == null) {
                return null;
            }
            if (entryId < 0 || entryId >= registry.size()) {
                return null;
            }
            Pair<String, Tag> entry = registry.get(entryId);
            return new Entry(entryId, (String)entry.getKey(), (Tag)entry.getValue());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Registries that = (Registries)o;
        return Objects.equals(this.registriesTag, that.registriesTag) && Objects.equals(this.registriesMap, that.registriesMap) && Objects.equals(this.enabledPacks, that.enabledPacks);
    }

    public int hashCode() {
        return Objects.hash(this.registriesTag, this.registriesMap, this.enabledPacks);
    }

    public void writeInternal(PacketTypeRegistry registry, NetOutput out) throws IOException {
        if (registry.atLeast(ProtocolVersion.v1_20_5)) {
            List<VersionedIdentifier> enabledPacks;
            Map<String, List<Object>> registriesMap = this.registriesMap;
            if (registriesMap == null) {
                registriesMap = Collections.emptyMap();
            }
            if ((enabledPacks = this.enabledPacks) == null) {
                enabledPacks = Collections.emptyList();
            }
            Packet.Writer.writeList(registry, out, new ArrayList<Map.Entry<String, List<Object>>>(registriesMap.entrySet()), registryEntry -> {
                out.writeString((String)registryEntry.getKey());
                Packet.Writer.writeList(registry, out, (List)registryEntry.getValue(), entry -> {
                    out.writeString((String)entry.getKey());
                    Tag value = (Tag)entry.getValue();
                    if (value != null) {
                        out.writeBoolean(true);
                        Packet.Writer.writeNBT(registry, out, value);
                    } else {
                        out.writeBoolean(false);
                    }
                });
            });
            Packet.Writer.writeList(registry, out, enabledPacks, entry -> entry.write(out));
        } else {
            Packet.Writer.writeNBT(registry, out, (Tag)this.registriesTag);
        }
    }

    public static Registries readInternal(PacketTypeRegistry registry, NetInput in) throws IOException {
        if (registry.atLeast(ProtocolVersion.v1_20_5)) {
            Registries registries = new Registries();
            registries.registriesMap = new HashMap<String, List<Pair<String, Tag>>>();
            Packet.Reader.readList(registry, in, () -> {
                String registryName = in.readString();
                List<Pair> registryEntries = Packet.Reader.readList(registry, in, () -> {
                    String key = in.readString();
                    CompoundTag value = in.readBoolean() ? Packet.Reader.readNBT(registry, in) : null;
                    return Pair.of((Object)key, (Object)value);
                });
                registries.registriesMap.put(registryName, registryEntries);
                return null;
            });
            registries.enabledPacks = Packet.Reader.readList(registry, in, () -> VersionedIdentifier.read(in));
            return registries;
        }
        return new Registries(Packet.Reader.readNBT(registry, in));
    }

    public static class Entry {
        public int id;
        public String name;
        public Tag value;

        public Entry(int id, String name, Tag value) {
            this.id = id;
            this.name = name;
            this.value = value;
        }

        public CompoundTag asCompoundOrEmpty() {
            if (this.value instanceof CompoundTag) {
                return (CompoundTag)this.value;
            }
            return new CompoundTag();
        }
    }
}

