/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.registry;

import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.data.VersionedIdentifier;
import com.replaymod.replaystudio.protocol.packets.PacketConfigRegistries;
import com.replaymod.replaystudio.protocol.packets.PacketConfigSelectKnownPacks;
import com.replaymod.replaystudio.protocol.packets.PacketCustomPayload;
import com.replaymod.replaystudio.protocol.packets.PacketEnabledPacksData;
import com.replaymod.replaystudio.protocol.registry.Registries;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class RegistriesBuilder {
    private List<VersionedIdentifier> enabledPacks;
    private Map<String, Map<String, Tag>> enabledPacksData;
    private Registries registries;

    public void readRegistriesPacket(Packet packet) throws IOException {
        if (this.registries == null) {
            this.registries = new Registries();
        }
        PacketConfigRegistries.read(packet, this.registries);
    }

    public void readKnownPacksPacket(Packet packet) throws IOException {
        this.enabledPacks = PacketConfigSelectKnownPacks.read(packet);
    }

    public void readEnabledPacksDataPacket(Packet packet) throws IOException {
        this.enabledPacksData = PacketEnabledPacksData.read(packet);
    }

    public Registries finish(Registries oldRegistries) {
        Registries result;
        if (this.registries != null) {
            result = this.registries;
            result.enabledPacks = this.enabledPacks;
            if (this.enabledPacksData != null && this.registries.registriesMap != null) {
                this.mergeEnabledPacksIntoRegistry();
            }
        } else {
            result = oldRegistries;
        }
        this.enabledPacks = null;
        this.registries = null;
        return result;
    }

    private void mergeEnabledPacksIntoRegistry() {
        for (Map.Entry<String, Map<String, Tag>> sourceRegistry : this.enabledPacksData.entrySet()) {
            Map<String, Tag> sourceEntries = sourceRegistry.getValue();
            List<Pair<String, Tag>> targetEntries = this.registries.registriesMap.get(sourceRegistry.getKey());
            if (targetEntries == null) continue;
            for (int i = 0; i < targetEntries.size(); ++i) {
                String id;
                Tag tag;
                Pair<String, Tag> entry = targetEntries.get(i);
                if (entry.getValue() != null || (tag = sourceEntries.get(id = (String)entry.getKey())) == null) continue;
                targetEntries.set(i, (Pair<String, Tag>)Pair.of((Object)id, (Object)tag));
            }
        }
    }

    public Registries update(Packet packet, Registries registries) throws IOException {
        switch (packet.getType()) {
            case ConfigSelectKnownPacks: {
                this.readKnownPacksPacket(packet);
                return registries;
            }
            case ConfigRegistries: {
                this.readRegistriesPacket(packet);
                return registries;
            }
            case ConfigFinish: {
                return this.finish(registries);
            }
            case ConfigCustomPayload: {
                switch (PacketCustomPayload.getId(packet)) {
                    case "replaymod:enabled_packs_data": {
                        this.readEnabledPacksDataPacket(packet);
                        return registries;
                    }
                }
            }
        }
        return registries;
    }

    public void copyFrom(RegistriesBuilder other) {
        this.enabledPacks = other.enabledPacks != null ? other.enabledPacks : null;
        this.registries = other.registries != null ? other.registries.copy() : null;
        this.enabledPacksData = other.enabledPacksData != null ? other.enabledPacksData : null;
    }
}

