/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.rar;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.Unpooled;
import com.github.steveice10.packetlib.io.stream.StreamNetInput;
import com.github.steveice10.packetlib.io.stream.StreamNetOutput;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.rar.analyse.ReplayAnalyzer;
import com.replaymod.replaystudio.rar.cache.ReadableCache;
import com.replaymod.replaystudio.rar.cache.WriteableCache;
import com.replaymod.replaystudio.rar.state.Replay;
import com.replaymod.replaystudio.replay.ReplayFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RandomAccessReplay {
    private static final String CACHE_ENTRY = "quickModeCache.bin";
    private static final String CACHE_INDEX_ENTRY = "quickModeCacheIndex.bin";
    private static final int CACHE_VERSION = 10;
    private static final Logger LOGGER = Logger.getLogger(RandomAccessReplay.class.getName());
    private final ReplayFile replayFile;
    private final PacketTypeRegistry registry;
    private int currentTimeStamp;
    private Replay state;
    private ReadableCache cache;

    public RandomAccessReplay(ReplayFile replayFile, PacketTypeRegistry registry) {
        this.replayFile = replayFile;
        this.registry = registry.withState(State.PLAY);
    }

    protected abstract void dispatch(Packet var1);

    public void load(Consumer<Double> progress) throws IOException {
        if (!this.tryLoadFromCache(progress)) {
            double progressSplit = 0.9;
            this.analyseReplay(d -> progress.accept(d * progressSplit));
            this.tryLoadFromCache(d -> progress.accept(d * (1.0 - progressSplit) + progressSplit));
        }
    }

    /*
     * Exception decompiling
     */
    private boolean tryLoadFromCache(Consumer<Double> progress) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Pair<Replay, ReadableCache> loadFromCache(InputStream rawCacheIn, InputStream rawIndexIn, Consumer<Double> progress) throws IOException {
        int len;
        long sysTimeStart = System.currentTimeMillis();
        StreamNetInput cacheIn = new StreamNetInput(rawCacheIn);
        StreamNetInput in = new StreamNetInput(rawIndexIn);
        if (in.readVarInt() != 10) {
            return null;
        }
        if (cacheIn.readVarInt() != 10) {
            return null;
        }
        if (in.readVarInt() != this.registry.getVersion().getOriginalVersion()) {
            return null;
        }
        if (cacheIn.readVarInt() != this.registry.getVersion().getOriginalVersion()) {
            return null;
        }
        Replay replay = new Replay(this.registry, in);
        int size = in.readVarInt();
        LOGGER.info("Creating quick mode buffer of size: " + size / 1024 + "KB");
        ByteBuf buf = Unpooled.buffer(size);
        int read = 0;
        while ((len = buf.writeBytes(rawCacheIn, Math.min(size - read, 4096))) > 0) {
            progress.accept((double)(read += len) / (double)size);
        }
        ReadableCache cache = new ReadableCache(buf);
        LOGGER.info("Loaded quick replay from cache in " + (System.currentTimeMillis() - sysTimeStart) + "ms");
        return Pair.of((Object)replay, (Object)cache);
    }

    private void analyseReplay(Consumer<Double> progress) throws IOException {
        double sysTimeStart = System.currentTimeMillis();
        try (ReplayInputStream in = this.replayFile.getPacketData(this.registry.withLoginSuccess());
             OutputStream cacheOut = this.replayFile.writeCache(CACHE_ENTRY);
             OutputStream cacheIndexOut = this.replayFile.writeCache(CACHE_INDEX_ENTRY);){
            StreamNetOutput out = new StreamNetOutput(cacheOut);
            out.writeVarInt(10);
            out.writeVarInt(this.registry.getVersion().getOriginalVersion());
            StreamNetOutput indexOut = new StreamNetOutput(cacheIndexOut);
            indexOut.writeVarInt(10);
            indexOut.writeVarInt(this.registry.getVersion().getOriginalVersion());
            WriteableCache cache = new WriteableCache(cacheOut);
            double duration = this.replayFile.getMetaData().getDuration();
            new ReplayAnalyzer(this.registry, indexOut, cache).analyse(in, time -> progress.accept((double)time / duration));
            indexOut.writeVarInt(cache.index());
        }
        LOGGER.info("Analysed replay in " + ((double)System.currentTimeMillis() - sysTimeStart) + "ms");
    }

    public void release() {
        if (this.state != null && this.cache != null) {
            try {
                this.state.unload(Packet::release, this.cache);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.state = null;
            this.cache.release();
            this.cache = null;
        }
    }

    public void reset() {
        this.currentTimeStamp = -1;
    }

    public void seek(int targetTime) throws IOException {
        if (targetTime > this.currentTimeStamp) {
            this.state.play(this::dispatch, this.currentTimeStamp, targetTime);
        } else {
            this.state.rewind(this::dispatch, this.currentTimeStamp, targetTime);
        }
        this.currentTimeStamp = targetTime;
    }
}

