/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.rar.state;

import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.packets.PacketJoinGame;
import com.replaymod.replaystudio.protocol.packets.PacketRespawn;
import com.replaymod.replaystudio.protocol.registry.DimensionType;
import com.replaymod.replaystudio.protocol.registry.Registries;
import com.replaymod.replaystudio.rar.PacketSink;
import com.replaymod.replaystudio.rar.RandomAccessState;
import com.replaymod.replaystudio.rar.cache.ReadableCache;
import com.replaymod.replaystudio.rar.cache.WriteableCache;
import com.replaymod.replaystudio.rar.containers.PacketStateTree;
import com.replaymod.replaystudio.rar.containers.TransientThings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class World
implements RandomAccessState {
    public final Info info;
    private final TransientThings transientThings;
    private final PacketStateTree viewPosition;
    private final PacketStateTree viewDistance;
    private final PacketStateTree simulationDistance;
    private final PacketStateTree worldTimes;
    private final PacketStateTree rainStrengths;
    private final PacketStateTree thunderStrengths;

    public World(PacketTypeRegistry registry, NetInput in) throws IOException {
        this.info = new Info(registry, in);
        this.transientThings = new TransientThings(registry, in.readVarInt());
        this.viewPosition = new PacketStateTree(registry, in.readVarInt());
        this.viewDistance = new PacketStateTree(registry, in.readVarInt());
        this.simulationDistance = new PacketStateTree(registry, in.readVarInt());
        this.worldTimes = new PacketStateTree(registry, in.readVarInt());
        this.rainStrengths = new PacketStateTree(registry, in.readVarInt());
        this.thunderStrengths = new PacketStateTree(registry, in.readVarInt());
    }

    @Override
    public void load(PacketSink sink, ReadableCache cache) throws IOException {
        this.viewPosition.load(sink, cache);
        this.viewDistance.load(sink, cache);
        this.simulationDistance.load(sink, cache);
        this.transientThings.load(sink, cache);
        this.worldTimes.load(sink, cache);
        this.rainStrengths.load(sink, cache);
        this.thunderStrengths.load(sink, cache);
    }

    @Override
    public void unload(PacketSink sink, ReadableCache cache) throws IOException {
        this.viewPosition.unload(sink, cache);
        this.viewDistance.unload(sink, cache);
        this.simulationDistance.unload(sink, cache);
        this.transientThings.unload(sink, cache);
        this.worldTimes.unload(sink, cache);
        this.rainStrengths.unload(sink, cache);
        this.thunderStrengths.unload(sink, cache);
    }

    @Override
    public void play(PacketSink sink, int currentTimeStamp, int targetTime) throws IOException {
        this.viewPosition.play(sink, currentTimeStamp, targetTime);
        this.viewDistance.play(sink, currentTimeStamp, targetTime);
        this.simulationDistance.play(sink, currentTimeStamp, targetTime);
        this.transientThings.play(sink, currentTimeStamp, targetTime);
        this.worldTimes.play(sink, currentTimeStamp, targetTime);
        this.rainStrengths.play(sink, currentTimeStamp, targetTime);
        this.thunderStrengths.play(sink, currentTimeStamp, targetTime);
    }

    @Override
    public void rewind(PacketSink sink, int currentTimeStamp, int targetTime) throws IOException {
        this.viewPosition.rewind(sink, currentTimeStamp, targetTime);
        this.viewDistance.rewind(sink, currentTimeStamp, targetTime);
        this.simulationDistance.rewind(sink, currentTimeStamp, targetTime);
        this.transientThings.rewind(sink, currentTimeStamp, targetTime);
        this.worldTimes.rewind(sink, currentTimeStamp, targetTime);
        this.rainStrengths.rewind(sink, currentTimeStamp, targetTime);
        this.thunderStrengths.rewind(sink, currentTimeStamp, targetTime);
    }

    public static final class Info {
        public final List<String> dimensions;
        public final Registries registries;
        public final String dimension;
        public final DimensionType dimensionType;
        public final long seed;
        public final int difficulty;
        public final boolean debugWorld;
        public final boolean flatWorld;

        public Info(List<String> dimensions, Registries registries, String dimension, DimensionType dimensionType, long seed, int difficulty, boolean debugWorld, boolean flatWorld) {
            this.dimensions = dimensions;
            this.registries = registries;
            this.dimension = dimension;
            this.dimensionType = dimensionType;
            this.seed = seed;
            this.difficulty = difficulty;
            this.debugWorld = debugWorld;
            this.flatWorld = flatWorld;
        }

        public Info(PacketJoinGame packet, Registries registries) {
            this(packet.dimensions, registries, packet.dimension, packet.dimensionType, packet.seed, packet.difficulty, packet.debugWorld, packet.flatWorld);
        }

        public Info(List<String> dimensions, Registries registries, PacketRespawn packet) {
            this(dimensions, registries, packet.dimension, packet.dimensionType, packet.seed, packet.difficulty, packet.debugWorld, packet.flatWorld);
        }

        public Info(Info info, PacketRespawn packet) {
            this(info.dimensions, info.registries, packet);
        }

        public Info(PacketTypeRegistry registry, NetInput in) throws IOException {
            this(registry.atLeast(ProtocolVersion.v1_16) ? Packet.Reader.readList(registry, in, in::readString) : null, registry.atLeast(ProtocolVersion.v1_16) ? Registries.readInternal(registry, in) : new Registries(), in.readString(), new DimensionType(Objects.requireNonNull(Packet.Reader.readNBT(registry, in)), in.readString(), in.readVarInt()), in.readLong(), in.readByte(), in.readBoolean(), in.readBoolean());
        }

        public void write(PacketTypeRegistry registry, NetOutput out) throws IOException {
            if (registry.atLeast(ProtocolVersion.v1_16)) {
                Packet.Writer.writeList(registry, out, this.dimensions, out::writeString);
                this.registries.writeInternal(registry, out);
            }
            out.writeString(this.dimension);
            Packet.Writer.writeNBT(registry, out, (Tag)this.dimensionType.getTag());
            out.writeString(this.dimensionType.getName());
            out.writeVarInt(this.dimensionType.getId());
            out.writeLong(this.seed);
            out.writeByte(this.difficulty);
            out.writeBoolean(this.debugWorld);
            out.writeBoolean(this.flatWorld);
        }

        public boolean isRespawnSufficient(Info other) {
            return Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.registries, other.registries) && !this.dimension.equals(other.dimension);
        }

        public PacketJoinGame toPacketJoinGame() {
            PacketJoinGame joinGame = new PacketJoinGame();
            joinGame.entityId = -1789435;
            joinGame.gameMode = (byte)3;
            joinGame.prevGameMode = (byte)3;
            joinGame.dimensions = this.dimensions;
            joinGame.registries = this.registries;
            joinGame.dimensionType = this.dimensionType;
            joinGame.dimension = this.dimension;
            joinGame.seed = this.seed;
            joinGame.difficulty = this.difficulty;
            joinGame.debugWorld = this.debugWorld;
            joinGame.flatWorld = this.flatWorld;
            return joinGame;
        }

        public PacketRespawn toRespawnPacket() {
            PacketRespawn respawn = new PacketRespawn();
            respawn.gameMode = (byte)3;
            respawn.prevGameMode = (byte)3;
            respawn.dimensionType = this.dimensionType;
            respawn.dimension = this.dimension;
            respawn.seed = this.seed;
            respawn.difficulty = this.difficulty;
            respawn.debugWorld = this.debugWorld;
            respawn.flatWorld = this.flatWorld;
            return respawn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return this.seed == info.seed && this.difficulty == info.difficulty && this.debugWorld == info.debugWorld && this.flatWorld == info.flatWorld && Objects.equals(this.dimensions, info.dimensions) && Objects.equals(this.registries, info.registries) && this.dimension.equals(info.dimension) && this.dimensionType.equals(info.dimensionType);
        }

        public int hashCode() {
            return Objects.hash(this.dimensions, this.registries, this.dimension, this.dimensionType, this.seed, this.difficulty, this.debugWorld, this.flatWorld);
        }
    }

    public static class Builder {
        private final WriteableCache cache;
        private final PacketTypeRegistry registry;
        public final Info info;
        public final TransientThings.Builder transientThings;
        public final PacketStateTree.Builder viewPosition = new PacketStateTree.Builder();
        public final PacketStateTree.Builder viewDistance = new PacketStateTree.Builder();
        public final PacketStateTree.Builder simulationDistance = new PacketStateTree.Builder();
        public final PacketStateTree.Builder worldTimes = new PacketStateTree.Builder();
        public final PacketStateTree.Builder rainStrengths = new PacketStateTree.Builder();
        public final PacketStateTree.Builder thunderStrengths = new PacketStateTree.Builder();

        public Builder(PacketTypeRegistry registry, WriteableCache cache, Info info) throws IOException {
            this.registry = registry;
            this.cache = cache;
            this.info = info;
            this.transientThings = new TransientThings.Builder(registry, cache, info.dimensionType);
        }

        public void build(NetOutput out, int time) throws IOException {
            this.info.write(this.registry, out);
            out.writeVarInt(this.transientThings.build(time));
            out.writeVarInt(this.viewPosition.build(this.cache));
            out.writeVarInt(this.viewDistance.build(this.cache));
            out.writeVarInt(this.simulationDistance.build(this.cache));
            out.writeVarInt(this.worldTimes.build(this.cache));
            out.writeVarInt(this.rainStrengths.build(this.cache));
            out.writeVarInt(this.thunderStrengths.build(this.cache));
        }
    }
}

