/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.replay;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.replaymod.replaystudio.Studio;
import com.replaymod.replaystudio.data.Marker;
import com.replaymod.replaystudio.data.ModInfo;
import com.replaymod.replaystudio.data.ReplayAssetEntry;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.io.ReplayOutputStream;
import com.replaymod.replaystudio.lib.guava.base.Optional;
import com.replaymod.replaystudio.lib.guava.io.Closeables;
import com.replaymod.replaystudio.pathing.PathingRegistry;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.pathing.serialize.TimelineSerialization;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public abstract class AbstractReplayFile
implements ReplayFile {
    private static final String ENTRY_META_DATA = "metaData.json";
    protected static final String ENTRY_RECORDING = "recording.tmcpr";
    private static final String ENTRY_RESOURCE_PACK = "resourcepack/%s.zip";
    private static final String ENTRY_RESOURCE_PACK_INDEX = "resourcepack/index.json";
    private static final String ENTRY_THUMB_OLD = "thumb";
    private static final String ENTRY_THUMB = "thumb.jpg";
    private static final String ENTRY_VISIBILITY_OLD = "visibility";
    private static final String ENTRY_VISIBILITY = "visibility.json";
    private static final String ENTRY_MARKERS = "markers.json";
    private static final String ENTRY_ASSET = "asset/%s_%s.%s";
    private static final Pattern PATTERN_ASSETS = Pattern.compile("asset/.*");
    private static final String ENTRY_MODS = "mods.json";
    private static final byte[] THUMB_MAGIC_NUMBERS = new byte[]{0, 1, 1, 2, 3, 5, 8};
    protected final Studio studio;

    public AbstractReplayFile(Studio studio) throws IOException {
        this.studio = studio;
    }

    @Override
    public ReplayMetaData getMetaData() throws IOException {
        Optional<InputStream> in = this.get(ENTRY_META_DATA);
        if (!in.isPresent()) {
            return null;
        }
        try (InputStreamReader is = new InputStreamReader(in.get());){
            ReplayMetaData replayMetaData = (ReplayMetaData)new Gson().fromJson((Reader)is, ReplayMetaData.class);
            return replayMetaData;
        }
    }

    @Override
    public void writeMetaData(PacketTypeRegistry registry, ReplayMetaData metaData) throws IOException {
        metaData.setFileFormat("MCPR");
        if (registry != null) {
            metaData.setFileFormatVersion(14);
            metaData.setProtocolVersion(registry.getVersion().getOriginalVersion());
        }
        if (metaData.getGenerator() == null) {
            metaData.setGenerator("ReplayStudio v" + this.studio.getVersion());
        }
        try (OutputStream out = this.write(ENTRY_META_DATA);){
            String json = new Gson().toJson((Object)metaData);
            out.write(json.getBytes());
        }
    }

    @Override
    public ReplayInputStream getPacketData(PacketTypeRegistry registry) throws IOException {
        Optional<InputStream> in = this.get(ENTRY_RECORDING);
        if (!in.isPresent()) {
            return null;
        }
        ReplayMetaData metaData = this.getMetaData();
        return new ReplayInputStream(registry, in.get(), metaData.getFileFormatVersion(), metaData.getRawProtocolVersionOr0());
    }

    @Override
    public ReplayOutputStream writePacketData() throws IOException {
        return new ReplayOutputStream(this.write(ENTRY_RECORDING));
    }

    @Override
    public Map<Integer, String> getResourcePackIndex() throws IOException {
        Optional<InputStream> in = this.get(ENTRY_RESOURCE_PACK_INDEX);
        if (!in.isPresent()) {
            return null;
        }
        HashMap<Integer, String> index = new HashMap<Integer, String>();
        try (InputStreamReader is = new InputStreamReader(in.get());){
            JsonObject array = (JsonObject)new Gson().fromJson((Reader)is, JsonObject.class);
            for (Map.Entry e : array.entrySet()) {
                try {
                    index.put(Integer.parseInt((String)e.getKey()), ((JsonElement)e.getValue()).getAsString());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return index;
    }

    @Override
    public void writeResourcePackIndex(Map<Integer, String> index) throws IOException {
        try (OutputStream out = this.write(ENTRY_RESOURCE_PACK_INDEX);){
            String json = new Gson().toJson(index);
            out.write(json.getBytes());
        }
    }

    @Override
    public Optional<InputStream> getResourcePack(String hash) throws IOException {
        return this.get(String.format(ENTRY_RESOURCE_PACK, hash));
    }

    @Override
    public OutputStream writeResourcePack(String hash) throws IOException {
        return this.write(String.format(ENTRY_RESOURCE_PACK, hash));
    }

    @Override
    public Map<String, Timeline> getTimelines(PathingRegistry pathingRegistry) throws IOException {
        return new TimelineSerialization(pathingRegistry, this).load();
    }

    @Override
    public void writeTimelines(PathingRegistry pathingRegistry, Map<String, Timeline> timelines) throws IOException {
        new TimelineSerialization(pathingRegistry, this).save(timelines);
    }

    @Override
    public Optional<InputStream> getThumbBytes() throws IOException {
        Optional<InputStream> maybeThumb = this.get(ENTRY_THUMB);
        if (maybeThumb.isPresent()) {
            return Optional.of(maybeThumb.get());
        }
        maybeThumb = this.get(ENTRY_THUMB_OLD);
        if (maybeThumb.isPresent()) {
            PushbackInputStream in = new PushbackInputStream(maybeThumb.get(), THUMB_MAGIC_NUMBERS.length);
            byte[] buf = new byte[THUMB_MAGIC_NUMBERS.length];
            new DataInputStream(in).readFully(buf);
            if (!Arrays.equals(buf, THUMB_MAGIC_NUMBERS)) {
                in.unread(buf);
            }
            return Optional.of(in);
        }
        return Optional.absent();
    }

    @Override
    public void writeThumbBytes(byte[] image) throws IOException {
        try (OutputStream out = this.write(ENTRY_THUMB);){
            out.write(image);
        }
    }

    @Override
    public Optional<Set<UUID>> getInvisiblePlayers() throws IOException {
        Optional<InputStream> in = this.get(ENTRY_VISIBILITY);
        if (!in.isPresent() && !(in = this.get(ENTRY_VISIBILITY_OLD)).isPresent()) {
            return Optional.absent();
        }
        HashSet<UUID> uuids = new HashSet<UUID>();
        try (InputStreamReader is = new InputStreamReader(in.get());){
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)is, JsonObject.class);
            for (JsonElement e : json.getAsJsonArray("hidden")) {
                uuids.add(UUID.fromString(e.getAsString()));
            }
        }
        return Optional.of(uuids);
    }

    @Override
    public void writeInvisiblePlayers(Set<UUID> uuids) throws IOException {
        try (OutputStream out = this.write(ENTRY_VISIBILITY);){
            JsonObject root = new JsonObject();
            JsonArray array = new JsonArray();
            root.add("hidden", (JsonElement)array);
            for (UUID uuid : uuids) {
                array.add((JsonElement)new JsonPrimitive(uuid.toString()));
            }
            String json = new Gson().toJson((JsonElement)root);
            out.write(json.getBytes());
        }
    }

    @Override
    public Optional<Set<Marker>> getMarkers() throws IOException {
        Optional<InputStream> in = this.get(ENTRY_MARKERS);
        if (in.isPresent()) {
            try (InputStreamReader is = new InputStreamReader(in.get());){
                JsonArray json = (JsonArray)new Gson().fromJson((Reader)is, JsonArray.class);
                HashSet<Marker> markers = new HashSet<Marker>();
                for (JsonElement element : json) {
                    JsonObject obj = element.getAsJsonObject();
                    JsonObject value = obj.getAsJsonObject("value");
                    JsonObject position = value.getAsJsonObject("position");
                    Marker marker = new Marker();
                    marker.setTime(obj.get("realTimestamp").getAsInt());
                    marker.setX(position.get("x").getAsDouble());
                    marker.setY(position.get("y").getAsDouble());
                    marker.setZ(position.get("z").getAsDouble());
                    marker.setYaw(position.get("yaw").getAsFloat());
                    marker.setPitch(position.get("pitch").getAsFloat());
                    marker.setRoll(position.get("roll").getAsFloat());
                    if (value.has("name")) {
                        marker.setName(value.get("name").getAsString());
                    }
                    markers.add(marker);
                }
                Optional optional = Optional.of(markers);
                return optional;
            }
        }
        return Optional.absent();
    }

    @Override
    public void writeMarkers(Set<Marker> markers) throws IOException {
        try (OutputStream out = this.write(ENTRY_MARKERS);){
            JsonArray root = new JsonArray();
            for (Marker marker : markers) {
                JsonObject entry = new JsonObject();
                JsonObject value = new JsonObject();
                JsonObject position = new JsonObject();
                entry.add("realTimestamp", (JsonElement)new JsonPrimitive((Number)marker.getTime()));
                value.add("name", (JsonElement)(marker.getName() == null ? null : new JsonPrimitive(marker.getName())));
                position.add("x", (JsonElement)new JsonPrimitive((Number)marker.getX()));
                position.add("y", (JsonElement)new JsonPrimitive((Number)marker.getY()));
                position.add("z", (JsonElement)new JsonPrimitive((Number)marker.getZ()));
                position.add("yaw", (JsonElement)new JsonPrimitive((Number)Float.valueOf(marker.getYaw())));
                position.add("pitch", (JsonElement)new JsonPrimitive((Number)Float.valueOf(marker.getPitch())));
                position.add("roll", (JsonElement)new JsonPrimitive((Number)Float.valueOf(marker.getRoll())));
                value.add("position", (JsonElement)position);
                entry.add("value", (JsonElement)value);
                root.add((JsonElement)entry);
            }
            out.write(new Gson().toJson((JsonElement)root).getBytes());
        }
    }

    @Override
    public Collection<ReplayAssetEntry> getAssets() throws IOException {
        Map<String, InputStream> entries = this.getAll(PATTERN_ASSETS);
        entries.values().forEach(Closeables::closeQuietly);
        ArrayList<ReplayAssetEntry> list = new ArrayList<ReplayAssetEntry>();
        for (String key : entries.keySet()) {
            int delim = key.indexOf(95);
            UUID uuid = UUID.fromString(key.substring(0, delim));
            String name = key.substring(delim + 1, key.lastIndexOf(46));
            String extension = key.substring(key.lastIndexOf(46));
            list.add(new ReplayAssetEntry(uuid, extension, name));
        }
        return list;
    }

    @Override
    public Optional<InputStream> getAsset(UUID uuid) throws IOException {
        Map<String, InputStream> entries = this.getAll(Pattern.compile("asset/" + Pattern.quote(uuid.toString()) + "_.*"));
        if (entries.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(entries.values().iterator().next());
    }

    @Override
    public OutputStream writeAsset(ReplayAssetEntry asset) throws IOException {
        return this.write(String.format(ENTRY_ASSET, asset.getUuid().toString(), asset.getName(), asset.getFileExtension()));
    }

    @Override
    public void removeAsset(UUID uuid) throws IOException {
        Collection<ReplayAssetEntry> assets = this.getAssets();
        for (ReplayAssetEntry asset : assets) {
            if (!asset.getUuid().equals(uuid)) continue;
            this.remove(String.format(ENTRY_ASSET, asset.getUuid().toString(), asset.getName(), asset.getFileExtension()));
        }
    }

    @Override
    public Collection<ModInfo> getModInfo() throws IOException {
        Optional<InputStream> in = this.get(ENTRY_MODS);
        if (in.isPresent()) {
            try (InputStreamReader is = new InputStreamReader(in.get());){
                JsonArray json = ((JsonObject)new Gson().fromJson((Reader)is, JsonObject.class)).getAsJsonArray("requiredMods");
                ArrayList<ModInfo> modInfoList = new ArrayList<ModInfo>();
                for (JsonElement element : json) {
                    JsonObject obj = element.getAsJsonObject();
                    modInfoList.add(new ModInfo(obj.get("modID").getAsString(), obj.get("modName").getAsString(), obj.get("modVersion").getAsString()));
                }
                ArrayList<ModInfo> arrayList = modInfoList;
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void writeModInfo(Collection<ModInfo> modInfo) throws IOException {
        try (OutputStream out = this.write(ENTRY_MODS);){
            JsonObject root = new JsonObject();
            JsonArray array = new JsonArray();
            for (ModInfo mod : modInfo) {
                JsonObject entry = new JsonObject();
                entry.addProperty("modID", mod.getId());
                entry.addProperty("modName", mod.getName());
                entry.addProperty("modVersion", mod.getVersion());
                array.add((JsonElement)entry);
            }
            root.add("requiredMods", (JsonElement)array);
            out.write(new Gson().toJson((JsonElement)root).getBytes());
        }
    }
}

