/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.replay;

import com.replaymod.replaystudio.Studio;
import com.replaymod.replaystudio.lib.guava.base.Charsets;
import com.replaymod.replaystudio.lib.guava.base.Optional;
import com.replaymod.replaystudio.lib.guava.io.Closeables;
import com.replaymod.replaystudio.lib.guava.io.Files;
import com.replaymod.replaystudio.replay.AbstractReplayFile;
import com.replaymod.replaystudio.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipReplayFile
extends AbstractReplayFile {
    private static final String ENTRY_RECORDING_HASH = "recording.tmcpr.crc32";
    private final File input;
    private final File output;
    private final File cache;
    private final File tmpFiles;
    private final File changedFiles;
    private final File removedFiles;
    private final File sourceFile;
    private CRC32 recordingCrc;
    private boolean shouldSaveInputFile;
    private final Map<String, OutputStream> outputStreams = new HashMap<String, OutputStream>();
    private final Map<String, File> changedEntries = new HashMap<String, File>();
    private final Set<String> removedEntries = new HashSet<String>();
    private ZipFile zipFile;

    public ZipReplayFile(Studio studio, File file) throws IOException {
        this(studio, file, file);
    }

    public ZipReplayFile(Studio studio, File input, File output) throws IOException {
        this(studio, input, output, new File(output.getParentFile(), output.getName() + ".cache"));
    }

    public ZipReplayFile(Studio studio, File input, File output, File cache) throws IOException {
        super(studio);
        Optional<InputStream> mcprIn;
        this.tmpFiles = new File(output.getParentFile(), output.getName() + ".tmp");
        this.changedFiles = new File(this.tmpFiles, "changed");
        this.removedFiles = new File(this.tmpFiles, "removed");
        this.sourceFile = new File(this.tmpFiles, "source");
        if (input != null && input.exists()) {
            this.shouldSaveInputFile = true;
        } else if (input == null && this.sourceFile.exists() && !(input = new File(new String(java.nio.file.Files.readAllBytes(this.sourceFile.toPath()), Charsets.UTF_8))).exists()) {
            throw new IOException("Recovered source file no longer exists.");
        }
        this.output = output;
        this.input = input;
        this.cache = cache;
        if (input != null && input.exists()) {
            this.zipFile = new ZipFile(input);
        }
        if (this.changedFiles.exists()) {
            Files.fileTreeTraverser().breadthFirstTraversal(this.changedFiles).filter(Files.isFile()).forEach(f -> this.changedEntries.put(this.changedFiles.toURI().relativize(f.toURI()).getPath(), (File)f));
        }
        if (this.removedFiles.exists()) {
            Files.fileTreeTraverser().breadthFirstTraversal(this.removedFiles).filter(Files.isFile()).transform(f -> this.removedFiles.toURI().relativize(f.toURI()).getPath()).forEach(this.removedEntries::add);
        }
        String cacheHash = null;
        String mcprHash = null;
        Optional<InputStream> cacheIn = this.getCache(ENTRY_RECORDING_HASH);
        if (cacheIn.isPresent()) {
            try (InputStream in2 = cacheIn.get();
                 InputStreamReader rin = new InputStreamReader(in2);
                 BufferedReader brin = new BufferedReader(rin);){
                cacheHash = brin.readLine();
            }
            catch (IOException in2) {
                // empty catch block
            }
        }
        if ((mcprIn = this.get(ENTRY_RECORDING_HASH)).isPresent()) {
            try (InputStream in = mcprIn.get();
                 InputStreamReader rin = new InputStreamReader(in);
                 BufferedReader brin = new BufferedReader(rin);){
                mcprHash = brin.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!Objects.equals(cacheHash, mcprHash)) {
            this.delete(cache);
            this.createCache(mcprHash);
        }
    }

    private void createCache(String hash) throws IOException {
        if (hash == null) {
            return;
        }
        try (OutputStream out = this.writeCache(ENTRY_RECORDING_HASH);
             OutputStreamWriter writer = new OutputStreamWriter(out);){
            writer.write(hash);
        }
    }

    private void saveInputFile() throws IOException {
        if (this.shouldSaveInputFile) {
            Files.createParentDirs(this.sourceFile);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.sourceFile));){
                ((OutputStream)out).write(this.input.getCanonicalPath().getBytes(Charsets.UTF_8));
            }
            this.shouldSaveInputFile = false;
        }
    }

    @Override
    public Optional<InputStream> get(String entry) throws IOException {
        if (this.changedEntries.containsKey(entry)) {
            return Optional.of(new BufferedInputStream(new FileInputStream(this.changedEntries.get(entry))));
        }
        if (this.zipFile == null || this.removedEntries.contains(entry)) {
            return Optional.absent();
        }
        ZipEntry zipEntry = this.zipFile.getEntry(entry);
        if (zipEntry == null) {
            return Optional.absent();
        }
        return Optional.of(new BufferedInputStream(this.zipFile.getInputStream(zipEntry)));
    }

    @Override
    public Optional<InputStream> getCache(String entry) throws IOException {
        Path path = this.cache.toPath().resolve(entry);
        if (!java.nio.file.Files.exists(path, new LinkOption[0])) {
            return Optional.absent();
        }
        BufferedInputStream rawIn = new BufferedInputStream(java.nio.file.Files.newInputStream(path, new OpenOption[0]));
        try {
            return Optional.of(new GZIPInputStream(rawIn));
        }
        catch (IOException e) {
            Closeables.closeQuietly(rawIn);
            return Optional.absent();
        }
    }

    @Override
    public Map<String, InputStream> getAll(Pattern pattern) throws IOException {
        String name;
        HashMap<String, InputStream> streams = new HashMap<String, InputStream>();
        for (Map.Entry<String, File> entry : this.changedEntries.entrySet()) {
            name = entry.getKey();
            if (!pattern.matcher(name).matches()) continue;
            streams.put(name, new BufferedInputStream(new FileInputStream(this.changedEntries.get(name))));
        }
        if (this.zipFile != null) {
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                name = zipEntry.getName();
                if (!pattern.matcher(name).matches() || streams.containsKey(name) || this.removedEntries.contains(name)) continue;
                streams.put(name, new BufferedInputStream(this.zipFile.getInputStream(zipEntry)));
            }
        }
        return streams;
    }

    @Override
    public OutputStream write(String entry) throws IOException {
        this.saveInputFile();
        File file = this.changedEntries.get(entry);
        if (file == null) {
            file = new File(this.changedFiles, entry);
            Files.createParentDirs(file);
            this.changedEntries.put(entry, file);
        }
        OutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        Closeables.close(this.outputStreams.put(entry, out), true);
        if (this.removedEntries.remove(entry)) {
            java.nio.file.Files.deleteIfExists(new File(this.removedFiles, entry).toPath());
        }
        if ("recording.tmcpr".equals(entry)) {
            try (OutputStream os = this.write(ENTRY_RECORDING_HASH);
                 OutputStreamWriter writer = new OutputStreamWriter(os);){
                writer.write("invalid");
            }
            this.recordingCrc = new CRC32();
            final BufferedOutputStream inner = out;
            out = new OutputStream(){

                @Override
                public void write(int i) throws IOException {
                    ZipReplayFile.this.recordingCrc.update(i);
                    inner.write(i);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    ZipReplayFile.this.recordingCrc.update(b, off, len);
                    inner.write(b, off, len);
                }

                @Override
                public void flush() throws IOException {
                    inner.flush();
                }

                @Override
                public void close() throws IOException {
                    inner.close();
                    String crc = "" + ZipReplayFile.this.recordingCrc.getValue();
                    ZipReplayFile.this.recordingCrc = null;
                    try (OutputStream out = ZipReplayFile.this.write(ZipReplayFile.ENTRY_RECORDING_HASH);
                         OutputStreamWriter writer = new OutputStreamWriter(out);){
                        writer.write(crc);
                    }
                    ZipReplayFile.this.delete(ZipReplayFile.this.cache);
                    ZipReplayFile.this.createCache(String.valueOf(crc));
                }
            };
        }
        return out;
    }

    @Override
    public OutputStream writeCache(String entry) throws IOException {
        Path path = this.cache.toPath().resolve(entry);
        java.nio.file.Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return new GZIPOutputStream(new BufferedOutputStream(java.nio.file.Files.newOutputStream(path, new OpenOption[0])));
    }

    @Override
    public void remove(String entry) throws IOException {
        this.saveInputFile();
        Closeables.close(this.outputStreams.remove(entry), true);
        File file = this.changedEntries.remove(entry);
        if (file != null && file.exists()) {
            this.delete(file);
        }
        this.removedEntries.add(entry);
        File removedFile = new File(this.removedFiles, entry);
        Files.createParentDirs(removedFile);
        Files.touch(removedFile);
    }

    @Override
    public void removeCache(String entry) throws IOException {
        Path path = this.cache.toPath().resolve(entry);
        java.nio.file.Files.deleteIfExists(path);
    }

    @Override
    public void save() throws IOException {
        if (this.zipFile != null && this.changedEntries.isEmpty() && this.removedEntries.isEmpty()) {
            return;
        }
        File outputFile = java.nio.file.Files.createTempFile("replaystudio", "replayfile", new FileAttribute[0]).toFile();
        this.saveTo(outputFile);
        this.close();
        if (this.output.exists()) {
            this.delete(this.output);
        }
        java.nio.file.Files.move(outputFile.toPath(), this.output.toPath(), new CopyOption[0]);
        this.zipFile = new ZipFile(this.output);
    }

    @Override
    public void saveTo(File target) throws IOException {
        for (OutputStream out : this.outputStreams.values()) {
            Closeables.close(out, false);
        }
        this.outputStreams.clear();
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(target)));){
            if (this.zipFile != null) {
                for (ZipEntry zipEntry : Collections.list(this.zipFile.entries())) {
                    if (this.changedEntries.containsKey(zipEntry.getName()) || this.removedEntries.contains(zipEntry.getName())) continue;
                    ZipEntry zipEntry2 = new ZipEntry(zipEntry);
                    zipEntry2.setCompressedSize(-1L);
                    out.putNextEntry(zipEntry2);
                    Utils.copy(this.zipFile.getInputStream(zipEntry2), out);
                }
            }
            for (Map.Entry entry : this.changedEntries.entrySet()) {
                out.putNextEntry(new ZipEntry((String)entry.getKey()));
                Utils.copy(new BufferedInputStream(new FileInputStream((File)entry.getValue())), out);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
        for (OutputStream out : this.outputStreams.values()) {
            Closeables.close(out, true);
        }
        this.outputStreams.clear();
        this.changedEntries.clear();
        this.removedEntries.clear();
        this.delete(this.tmpFiles);
    }

    private void delete(File file) throws IOException {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                this.delete(child);
            }
        }
        java.nio.file.Files.deleteIfExists(file.toPath());
    }
}

