/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.util;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;

public class ThreadLocalOutputStream
extends OutputStream {
    private OutputStream def;
    private final ThreadLocal<OutputStream> outputs = new ThreadLocal();

    public ThreadLocalOutputStream(OutputStream def) {
        this.def = Preconditions.checkNotNull(def);
    }

    public OutputStream getDefault() {
        return this.def;
    }

    public void setDefault(OutputStream def) {
        this.def = Preconditions.checkNotNull(def);
    }

    public void setOutput(OutputStream output) {
        this.outputs.set(output);
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream out = this.outputs.get();
        if (out == null) {
            out = this.def;
        }
        out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        OutputStream out = this.outputs.get();
        if (out == null) {
            out = this.def;
        }
        out.write(b, off, len);
    }
}

