/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.util;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.Unpooled;
import com.github.steveice10.netty.util.ReferenceCountUtil;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetInput;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetOutput;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.util.ByteBufExtNetInput;
import com.replaymod.replaystudio.util.ByteBufExtNetOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Utils {
    public static int readInt(InputStream in) throws IOException {
        int b3;
        int b2;
        int b1;
        int b0 = in.read();
        if ((b0 | (b1 = in.read()) | (b2 = in.read()) | (b3 = in.read())) < 0) {
            return -1;
        }
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    public static void writeInt(OutputStream out, int x) throws IOException {
        out.write(x >>> 24 & 0xFF);
        out.write(x >>> 16 & 0xFF);
        out.write(x >>> 8 & 0xFF);
        out.write(x & 0xFF);
    }

    public static boolean containsOnlyNull(Object[] array) {
        for (Object o : array) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static long within(long i, long min, long max) {
        if (i > max) {
            return max;
        }
        if (i < min) {
            return min;
        }
        return i;
    }

    public static InputStream notCloseable(final InputStream source) {
        return new InputStream(){
            boolean closed;

            @Override
            public void close() throws IOException {
                this.closed = true;
            }

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    return -1;
                }
                return source.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.closed) {
                    return -1;
                }
                return source.read(b, off, len);
            }

            @Override
            public int available() throws IOException {
                return source.available();
            }

            @Override
            public long skip(long n) throws IOException {
                if (this.closed) {
                    return 0L;
                }
                return source.skip(n);
            }

            @Override
            public synchronized void mark(int readlimit) {
                source.mark(readlimit);
            }

            @Override
            public synchronized void reset() throws IOException {
                source.reset();
            }

            @Override
            public boolean markSupported() {
                return source.markSupported();
            }

            @Override
            public int read(byte[] b) throws IOException {
                if (this.closed) {
                    return -1;
                }
                return source.read(b);
            }
        };
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) > -1) {
            out.write(buffer, 0, read);
        }
        in.close();
    }

    public static ByteBuf readRetainedSlice(NetInput in, int len) throws IOException {
        if (in instanceof ByteBufExtNetInput) {
            ByteBuf inBuf = ((ByteBufExtNetInput)in).getBuf();
            return inBuf.readRetainedSlice(len);
        }
        return Unpooled.wrappedBuffer(in.readBytes(len));
    }

    public static void writeBytes(NetOutput out, ByteBuf buf) throws IOException {
        if (out instanceof ByteBufExtNetOutput) {
            ByteBuf outBuf = ((ByteBufExtNetOutput)out).getBuf();
            outBuf.writeBytes(buf);
            return;
        }
        byte[] bytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), bytes);
        out.writeBytes(bytes);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Packet readCompressedPacket(PacketTypeRegistry registry, NetInput in) throws IOException {
        Packet packet;
        ByteBuf byteBuf = null;
        try {
            int prefix = in.readVarInt();
            int len = prefix >> 1;
            if ((prefix & 1) == 1) {
                int fullLen = in.readVarInt();
                byteBuf = Unpooled.buffer(fullLen);
                Inflater inflater = new Inflater();
                inflater.setInput(in.readBytes(len));
                inflater.inflate(byteBuf.array(), byteBuf.arrayOffset(), fullLen);
                byteBuf.writerIndex(fullLen);
            } else {
                byteBuf = Utils.readRetainedSlice(in, len);
            }
            int id = new ByteBufNetInput(byteBuf).readVarInt();
            int stateId = id >> 24;
            int packetId = id << 24 >> 24;
            packet = new Packet(registry.withState(State.values()[4 - stateId]), packetId, byteBuf.retain());
        }
        catch (IOException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release(byteBuf);
                throw throwable;
            }
        }
        ReferenceCountUtil.release(byteBuf);
        return packet;
    }

    public static void writeCompressedPacket(NetOutput out, Packet packet) throws IOException {
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            int compressedSize;
            int stateId = 4 - packet.getType().getState().ordinal();
            new ByteBufNetOutput(byteBuf).writeVarInt(stateId << 24 | packet.getId());
            byteBuf.writeBytes(packet.getBuf());
            int rawIndex = byteBuf.readerIndex();
            int size = byteBuf.readableBytes();
            byteBuf.ensureWritable(size);
            Deflater deflater = new Deflater();
            deflater.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), size);
            deflater.finish();
            for (compressedSize = 0; !deflater.finished() && compressedSize < size; compressedSize += deflater.deflate(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.writerIndex() + compressedSize, size - compressedSize)) {
            }
            if (compressedSize < size) {
                byteBuf.readerIndex(rawIndex + size);
                byteBuf.writerIndex(rawIndex + size + compressedSize);
                out.writeVarInt(compressedSize << 1 | 1);
                out.writeVarInt(size);
            } else {
                byteBuf.readerIndex(rawIndex);
                byteBuf.writerIndex(rawIndex + size);
                out.writeVarInt(size << 1);
            }
            Utils.writeBytes(out, byteBuf);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ReferenceCountUtil.release(byteBuf);
        }
    }
}

