/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.simplepathing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.replaymod.pathing.properties.CameraProperties;
import com.replaymod.pathing.properties.SpectatorProperty;
import com.replaymod.pathing.properties.TimestampProperty;
import com.replaymod.replaystudio.pathing.PathingRegistry;
import com.replaymod.replaystudio.pathing.change.AddKeyframe;
import com.replaymod.replaystudio.pathing.change.Change;
import com.replaymod.replaystudio.pathing.change.CombinedChange;
import com.replaymod.replaystudio.pathing.change.RemoveKeyframe;
import com.replaymod.replaystudio.pathing.change.SetInterpolator;
import com.replaymod.replaystudio.pathing.change.UpdateKeyframeProperties;
import com.replaymod.replaystudio.pathing.impl.TimelineImpl;
import com.replaymod.replaystudio.pathing.interpolation.CatmullRomSplineInterpolator;
import com.replaymod.replaystudio.pathing.interpolation.CubicSplineInterpolator;
import com.replaymod.replaystudio.pathing.interpolation.Interpolator;
import com.replaymod.replaystudio.pathing.interpolation.LinearInterpolator;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.PathSegment;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.pathing.property.Property;
import com.replaymod.replaystudio.util.EntityPositionTracker;
import com.replaymod.replaystudio.util.Location;
import com.replaymod.simplepathing.InterpolatorType;
import com.replaymod.simplepathing.ReplayModSimplePathing;
import com.replaymod.simplepathing.properties.ExplicitInterpolationProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;

public class SPTimeline
implements PathingRegistry {
    private final Timeline timeline;
    private final Path timePath;
    private final Path positionPath;
    private EntityPositionTracker entityTracker;
    private InterpolatorType defaultInterpolatorType;

    public SPTimeline() {
        this(SPTimeline.createInitialTimeline());
    }

    public SPTimeline(Timeline timeline) {
        this.timeline = timeline;
        this.timePath = timeline.getPaths().get(SPPath.TIME.ordinal());
        this.positionPath = timeline.getPaths().get(SPPath.POSITION.ordinal());
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public Path getTimePath() {
        return this.timePath;
    }

    public Path getPositionPath() {
        return this.positionPath;
    }

    public EntityPositionTracker getEntityTracker() {
        return this.entityTracker;
    }

    public Path getPath(SPPath path) {
        switch (path.ordinal()) {
            case 0: {
                return this.getTimePath();
            }
            case 1: {
                return this.getPositionPath();
            }
        }
        throw new IllegalArgumentException("Unknown path " + String.valueOf((Object)path));
    }

    public Keyframe getKeyframe(SPPath path, long keyframe) {
        return this.getPath(path).getKeyframe(keyframe);
    }

    public void setEntityTracker(EntityPositionTracker entityTracker) {
        Preconditions.checkState((this.entityTracker == null ? 1 : 0) != 0, (Object)"Entity tracker already set");
        this.entityTracker = entityTracker;
    }

    public void setDefaultInterpolatorType(InterpolatorType defaultInterpolatorType) {
        Validate.isTrue((defaultInterpolatorType != InterpolatorType.DEFAULT ? 1 : 0) != 0, (String)"Must not be DEFAULT", (Object[])new Object[0]);
        InterpolatorType prevType = this.defaultInterpolatorType;
        this.defaultInterpolatorType = (InterpolatorType)((Object)Validate.notNull((Object)((Object)defaultInterpolatorType)));
        if (prevType != null && prevType != this.defaultInterpolatorType) {
            this.timeline.pushChange(this.updateInterpolators());
        }
    }

    public Change setDefaultInterpolator(Interpolator interpolator) {
        Preconditions.checkState((this.defaultInterpolatorType != null ? 1 : 0) != 0, (Object)"Default interpolator type not set.");
        Validate.isInstanceOf(this.defaultInterpolatorType.getInterpolatorClass(), (Object)interpolator);
        this.registerPositionInterpolatorProperties(interpolator);
        CombinedChange change = CombinedChange.create((Change[])this.positionPath.getSegments().stream().filter(s -> !s.getStartKeyframe().getValue(ExplicitInterpolationProperty.PROPERTY).isPresent()).filter(s -> !this.isSpectatorSegment((PathSegment)s)).map(s -> SetInterpolator.create(s, interpolator)).toArray(Change[]::new));
        change.apply(this.timeline);
        return CombinedChange.createFromApplied(change, this.updateInterpolators());
    }

    public boolean isTimeKeyframe(long time) {
        return this.timePath.getKeyframe(time) != null;
    }

    public boolean isPositionKeyframe(long time) {
        return this.positionPath.getKeyframe(time) != null;
    }

    public boolean isSpectatorKeyframe(long time) {
        Keyframe keyframe = this.positionPath.getKeyframe(time);
        return keyframe != null && keyframe.getValue(SpectatorProperty.PROPERTY).isPresent();
    }

    public void addPositionKeyframe(long time, double posX, double posY, double posZ, float yaw, float pitch, float roll, int spectated) {
        ReplayModSimplePathing.LOGGER.debug("Adding position keyframe at {} pos {}/{}/{} rot {}/{}/{} entId {}", (Object)time, (Object)posX, (Object)posY, (Object)posZ, (Object)Float.valueOf(yaw), (Object)Float.valueOf(pitch), (Object)Float.valueOf(roll), (Object)spectated);
        Path path = this.positionPath;
        Preconditions.checkState((this.positionPath.getKeyframe(time) == null ? 1 : 0) != 0, (Object)"Keyframe already exists");
        Change change = AddKeyframe.create(path, time);
        change.apply(this.timeline);
        Keyframe keyframe = path.getKeyframe(time);
        UpdateKeyframeProperties.Builder builder = UpdateKeyframeProperties.create(path, keyframe);
        builder.setValue(CameraProperties.POSITION, Triple.of((Object)posX, (Object)posY, (Object)posZ));
        builder.setValue(CameraProperties.ROTATION, Triple.of((Object)Float.valueOf(yaw), (Object)Float.valueOf(pitch), (Object)Float.valueOf(roll)));
        if (spectated != -1) {
            builder.setValue(SpectatorProperty.PROPERTY, spectated);
        }
        UpdateKeyframeProperties updateChange = builder.done();
        updateChange.apply(this.timeline);
        change = CombinedChange.createFromApplied(change, updateChange);
        if (path.getSegments().size() == 1) {
            PathSegment segment = path.getSegments().iterator().next();
            Interpolator interpolator = this.createDefaultInterpolator();
            SetInterpolator setInterpolator = SetInterpolator.create(segment, interpolator);
            setInterpolator.apply(this.timeline);
            change = CombinedChange.createFromApplied(change, setInterpolator);
        }
        change = CombinedChange.createFromApplied(change, this.updateInterpolators());
        Change specPosUpdate = this.updateSpectatorPositions();
        specPosUpdate.apply(this.timeline);
        change = CombinedChange.createFromApplied(change, specPosUpdate);
        this.timeline.pushChange(change);
    }

    public Change updatePositionKeyframe(long time, double posX, double posY, double posZ, float yaw, float pitch, float roll) {
        ReplayModSimplePathing.LOGGER.debug("Updating position keyframe at {} to pos {}/{}/{} rot {}/{}/{}", (Object)time, (Object)posX, (Object)posY, (Object)posZ, (Object)Float.valueOf(yaw), (Object)Float.valueOf(pitch), (Object)Float.valueOf(roll));
        Keyframe keyframe = this.positionPath.getKeyframe(time);
        Preconditions.checkState((keyframe != null ? 1 : 0) != 0, (Object)"Keyframe does not exists");
        Preconditions.checkState((!keyframe.getValue(SpectatorProperty.PROPERTY).isPresent() ? 1 : 0) != 0, (Object)"Cannot update spectator keyframe");
        UpdateKeyframeProperties change = UpdateKeyframeProperties.create(this.positionPath, keyframe).setValue(CameraProperties.POSITION, Triple.of((Object)posX, (Object)posY, (Object)posZ)).setValue(CameraProperties.ROTATION, Triple.of((Object)Float.valueOf(yaw), (Object)Float.valueOf(pitch), (Object)Float.valueOf(roll))).done();
        change.apply(this.timeline);
        return change;
    }

    public void removePositionKeyframe(long time) {
        ReplayModSimplePathing.LOGGER.debug("Removing position keyframe at {}", (Object)time);
        Path path = this.positionPath;
        Keyframe keyframe = path.getKeyframe(time);
        Preconditions.checkState((keyframe != null ? 1 : 0) != 0, (Object)"No keyframe at that time");
        Change change = RemoveKeyframe.create(path, keyframe);
        change.apply(this.timeline);
        change = CombinedChange.createFromApplied(change, this.updateInterpolators());
        Change specPosUpdate = this.updateSpectatorPositions();
        specPosUpdate.apply(this.timeline);
        change = CombinedChange.createFromApplied(change, specPosUpdate);
        this.timeline.pushChange(change);
    }

    public void addTimeKeyframe(long time, int replayTime) {
        ReplayModSimplePathing.LOGGER.debug("Adding time keyframe at {} time {}", (Object)time, (Object)replayTime);
        Path path = this.timePath;
        Preconditions.checkState((path.getKeyframe(time) == null ? 1 : 0) != 0, (Object)"Keyframe already exists");
        Change change = AddKeyframe.create(path, time);
        change.apply(this.timeline);
        Keyframe keyframe = path.getKeyframe(time);
        UpdateKeyframeProperties updateChange = UpdateKeyframeProperties.create(path, keyframe).setValue(TimestampProperty.PROPERTY, replayTime).done();
        updateChange.apply(this.timeline);
        change = CombinedChange.createFromApplied(change, updateChange);
        if (path.getSegments().size() == 1) {
            PathSegment segment = path.getSegments().iterator().next();
            LinearInterpolator interpolator = new LinearInterpolator();
            interpolator.registerProperty(TimestampProperty.PROPERTY);
            SetInterpolator setInterpolator = SetInterpolator.create(segment, interpolator);
            setInterpolator.apply(this.timeline);
            change = CombinedChange.createFromApplied(change, setInterpolator);
        }
        Change specPosUpdate = this.updateSpectatorPositions();
        specPosUpdate.apply(this.timeline);
        change = CombinedChange.createFromApplied(change, specPosUpdate);
        this.timeline.pushChange(change);
    }

    public Change updateTimeKeyframe(long time, int replayTime) {
        ReplayModSimplePathing.LOGGER.debug("Updating time keyframe at {} to time {}", (Object)time, (Object)replayTime);
        Keyframe keyframe = this.timePath.getKeyframe(time);
        Preconditions.checkState((keyframe != null ? 1 : 0) != 0, (Object)"Keyframe does not exists");
        UpdateKeyframeProperties change = UpdateKeyframeProperties.create(this.timePath, keyframe).setValue(TimestampProperty.PROPERTY, replayTime).done();
        change.apply(this.timeline);
        return change;
    }

    public void removeTimeKeyframe(long time) {
        ReplayModSimplePathing.LOGGER.debug("Removing time keyframe at {}", (Object)time);
        Path path = this.timePath;
        Keyframe keyframe = path.getKeyframe(time);
        Preconditions.checkState((keyframe != null ? 1 : 0) != 0, (Object)"No keyframe at that time");
        Change change = RemoveKeyframe.create(path, keyframe);
        change.apply(this.timeline);
        Change specPosUpdate = this.updateSpectatorPositions();
        specPosUpdate.apply(this.timeline);
        change = CombinedChange.createFromApplied(change, specPosUpdate);
        this.timeline.pushChange(change);
    }

    public Change setInterpolatorToDefault(long time) {
        ReplayModSimplePathing.LOGGER.debug("Setting interpolator of position keyframe at {} to the default", (Object)time);
        Keyframe keyframe = this.positionPath.getKeyframe(time);
        Preconditions.checkState((keyframe != null ? 1 : 0) != 0, (Object)"Keyframe does not exists");
        UpdateKeyframeProperties change = UpdateKeyframeProperties.create(this.positionPath, keyframe).removeProperty(ExplicitInterpolationProperty.PROPERTY).done();
        change.apply(this.timeline);
        return CombinedChange.createFromApplied(change, this.updateInterpolators());
    }

    public Change setInterpolator(long time, Interpolator interpolator) {
        ReplayModSimplePathing.LOGGER.debug("Setting interpolator of position keyframe at {} to {}", (Object)time, (Object)interpolator);
        Keyframe keyframe = this.positionPath.getKeyframe(time);
        Preconditions.checkState((keyframe != null ? 1 : 0) != 0, (Object)"Keyframe does not exists");
        PathSegment segment = this.positionPath.getSegments().stream().filter(s -> s.getStartKeyframe() == keyframe).findFirst().orElseThrow(() -> new IllegalStateException("Keyframe has no following segment."));
        this.registerPositionInterpolatorProperties(interpolator);
        CombinedChange change = CombinedChange.create(UpdateKeyframeProperties.create(this.positionPath, keyframe).setValue(ExplicitInterpolationProperty.PROPERTY, ObjectUtils.NULL).done(), SetInterpolator.create(segment, interpolator));
        change.apply(this.timeline);
        return CombinedChange.createFromApplied(change, this.updateInterpolators());
    }

    public Change moveKeyframe(SPPath spPath, long oldTime, long newTime) {
        Change interpolatorUpdateChange;
        ReplayModSimplePathing.LOGGER.debug("Moving keyframe on {} from {} to {}", (Object)spPath, (Object)oldTime, (Object)newTime);
        Path path = this.getPath(spPath);
        Keyframe keyframe = path.getKeyframe(oldTime);
        Preconditions.checkState((keyframe != null ? 1 : 0) != 0, (Object)"No keyframe at specified time");
        Optional<Interpolator> firstInterpolator = path.getSegments().stream().findFirst().map(PathSegment::getInterpolator);
        Optional<Interpolator> lostInterpolator = path.getSegments().stream().filter(s -> {
            if (Iterables.getLast(path.getKeyframes()) == keyframe) {
                return s.getEndKeyframe() == keyframe;
            }
            return s.getStartKeyframe() == keyframe;
        }).findFirst().map(PathSegment::getInterpolator);
        RemoveKeyframe removeChange = RemoveKeyframe.create(path, keyframe);
        removeChange.apply(this.timeline);
        AddKeyframe addChange = AddKeyframe.create(path, newTime);
        addChange.apply(this.timeline);
        UpdateKeyframeProperties.Builder builder = UpdateKeyframeProperties.create(path, path.getKeyframe(newTime));
        for (Property property : keyframe.getProperties()) {
            this.copyProperty(property, keyframe, builder);
        }
        UpdateKeyframeProperties propertyChange = builder.done();
        propertyChange.apply(this.timeline);
        Keyframe newKf = path.getKeyframe(newTime);
        Change restoreInterpolatorChange = Iterables.getLast(path.getKeyframes()) != newKf ? lostInterpolator.flatMap(interpolator -> path.getSegments().stream().filter(s -> s.getStartKeyframe() == newKf).findFirst().map(segment -> SetInterpolator.create(segment, interpolator))).orElseGet(() -> CombinedChange.create(new Change[0])) : path.getSegments().stream().filter(s -> s.getEndKeyframe() == newKf).findFirst().flatMap(segment -> lostInterpolator.map(interpolator -> {
            if (newKf.getValue(ExplicitInterpolationProperty.PROPERTY).isPresent()) {
                return CombinedChange.create(SetInterpolator.create(segment, interpolator), UpdateKeyframeProperties.create(path, segment.getStartKeyframe()).setValue(ExplicitInterpolationProperty.PROPERTY, ObjectUtils.NULL).done());
            }
            return SetInterpolator.create(segment, interpolator);
        })).orElseGet(() -> CombinedChange.create(new Change[0]));
        restoreInterpolatorChange.apply(this.timeline);
        if (spPath == SPPath.POSITION) {
            interpolatorUpdateChange = this.updateInterpolators();
        } else {
            if (path.getSegments().size() == 1) {
                assert (firstInterpolator.isPresent()) : "One segment should have existed before as well";
                interpolatorUpdateChange = SetInterpolator.create(path.getSegments().iterator().next(), firstInterpolator.get());
            } else {
                interpolatorUpdateChange = CombinedChange.create(new Change[0]);
            }
            interpolatorUpdateChange.apply(this.timeline);
        }
        Change spectatorChange = this.updateSpectatorPositions();
        spectatorChange.apply(this.timeline);
        return CombinedChange.createFromApplied(removeChange, addChange, propertyChange, restoreInterpolatorChange, interpolatorUpdateChange, spectatorChange);
    }

    private <T> void copyProperty(Property<T> property, Keyframe from, UpdateKeyframeProperties.Builder to) {
        from.getValue(property).ifPresent(value -> to.setValue(property, value));
    }

    private Change updateInterpolators() {
        Collection<PathSegment> pathSegments = this.positionPath.getSegments();
        HashMap<PathSegment, Interpolator> updates = new HashMap<PathSegment, Interpolator>();
        LinearInterpolator interpolator = null;
        for (PathSegment segment2 : pathSegments) {
            if (this.isSpectatorSegment(segment2)) {
                if (interpolator == null) {
                    interpolator = new LinearInterpolator();
                    interpolator.registerProperty(SpectatorProperty.PROPERTY);
                }
                updates.put(segment2, interpolator);
                continue;
            }
            interpolator = null;
        }
        pathSegments.stream().filter(s -> !s.getStartKeyframe().getValue(ExplicitInterpolationProperty.PROPERTY).isPresent()).filter(s -> !this.isSpectatorSegment((PathSegment)s)).filter(s -> !s.getInterpolator().getClass().equals(this.defaultInterpolatorType.getInterpolatorClass())).forEach(segment -> updates.put(segment, this.createDefaultInterpolator()));
        Interpolator lastInterpolator = null;
        Set used = Collections.newSetFromMap(new IdentityHashMap());
        for (PathSegment pathSegment : pathSegments) {
            if (this.isSpectatorSegment(pathSegment)) {
                lastInterpolator = null;
                continue;
            }
            Interpolator currentInterpolator = updates.getOrDefault(pathSegment, pathSegment.getInterpolator());
            if (lastInterpolator == currentInterpolator) continue;
            if (!used.add(interpolator)) {
                currentInterpolator = this.cloneInterpolator(currentInterpolator);
                updates.put(pathSegment, currentInterpolator);
            }
            lastInterpolator = currentInterpolator;
        }
        lastInterpolator = null;
        String lastInterpolatorSerialized = null;
        for (PathSegment segment4 : pathSegments) {
            if (this.isSpectatorSegment(segment4)) {
                lastInterpolator = null;
                lastInterpolatorSerialized = null;
                continue;
            }
            Interpolator currentInterpolator = updates.getOrDefault(segment4, segment4.getInterpolator());
            String serialized = this.serializeInterpolator(currentInterpolator);
            if (lastInterpolator != currentInterpolator && serialized.equals(lastInterpolatorSerialized)) {
                updates.put(segment4, lastInterpolator);
                continue;
            }
            lastInterpolator = currentInterpolator;
            lastInterpolatorSerialized = serialized;
        }
        CombinedChange combinedChange = CombinedChange.create((Change[])updates.entrySet().stream().map(e -> SetInterpolator.create((PathSegment)e.getKey(), (Interpolator)e.getValue())).toArray(Change[]::new));
        combinedChange.apply(this.timeline);
        return combinedChange;
    }

    private boolean isSpectatorSegment(PathSegment segment) {
        return segment.getStartKeyframe().getValue(SpectatorProperty.PROPERTY).isPresent() && segment.getEndKeyframe().getValue(SpectatorProperty.PROPERTY).isPresent();
    }

    private Change updateSpectatorPositions() {
        if (this.entityTracker == null) {
            return CombinedChange.create(new Change[0]);
        }
        ArrayList<UpdateKeyframeProperties> changes = new ArrayList<UpdateKeyframeProperties>();
        this.timePath.updateAll();
        for (Keyframe keyframe : this.positionPath.getKeyframes()) {
            Location expected;
            Optional<Integer> time;
            Optional<Integer> spectator = keyframe.getValue(SpectatorProperty.PROPERTY);
            if (!spectator.isPresent() || !(time = this.timePath.getValue(TimestampProperty.PROPERTY, keyframe.getTime())).isPresent() || (expected = this.entityTracker.getEntityPositionAtTimestamp(spectator.get(), time.get().intValue())) == null) continue;
            Triple<Double, Double, Double> pos = keyframe.getValue(CameraProperties.POSITION).orElse((Triple<Double, Double, Double>)Triple.of((Object)0.0, (Object)0.0, (Object)0.0));
            Triple<Float, Float, Float> rot = keyframe.getValue(CameraProperties.ROTATION).orElse((Triple<Float, Float, Float>)Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
            Location actual = new Location((Double)pos.getLeft(), (Double)pos.getMiddle(), (Double)pos.getRight(), ((Float)rot.getLeft()).floatValue(), ((Float)rot.getRight()).floatValue());
            if (expected.equals(actual)) continue;
            changes.add(UpdateKeyframeProperties.create(this.positionPath, keyframe).setValue(CameraProperties.POSITION, Triple.of((Object)expected.getX(), (Object)expected.getY(), (Object)expected.getZ())).setValue(CameraProperties.ROTATION, Triple.of((Object)Float.valueOf(expected.getYaw()), (Object)Float.valueOf(expected.getPitch()), (Object)Float.valueOf(0.0f))).done());
        }
        return CombinedChange.create(changes.toArray(new Change[changes.size()]));
    }

    private Interpolator createDefaultInterpolator() {
        return this.registerPositionInterpolatorProperties(this.defaultInterpolatorType.newInstance());
    }

    private Interpolator registerPositionInterpolatorProperties(Interpolator interpolator) {
        interpolator.registerProperty(CameraProperties.POSITION);
        interpolator.registerProperty(CameraProperties.ROTATION);
        return interpolator;
    }

    @Override
    public Timeline createTimeline() {
        return SPTimeline.createTimelineStatic();
    }

    private static Timeline createInitialTimeline() {
        Timeline timeline = SPTimeline.createTimelineStatic();
        timeline.createPath();
        timeline.createPath();
        return timeline;
    }

    private static Timeline createTimelineStatic() {
        TimelineImpl timeline = new TimelineImpl();
        timeline.registerProperty(TimestampProperty.PROPERTY);
        timeline.registerProperty(CameraProperties.POSITION);
        timeline.registerProperty(CameraProperties.ROTATION);
        timeline.registerProperty(SpectatorProperty.PROPERTY);
        timeline.registerProperty(ExplicitInterpolationProperty.PROPERTY);
        return timeline;
    }

    @Override
    public void serializeInterpolator(JsonWriter writer, Interpolator interpolator) throws IOException {
        if (interpolator instanceof LinearInterpolator) {
            writer.value("linear");
        } else if (interpolator instanceof CubicSplineInterpolator) {
            writer.value("cubic-spline");
        } else if (interpolator instanceof CatmullRomSplineInterpolator) {
            writer.beginObject();
            writer.name("type").value("catmull-rom-spline");
            writer.name("alpha").value(((CatmullRomSplineInterpolator)interpolator).getAlpha());
            writer.endObject();
        } else {
            throw new IOException("Unknown interpolator type: " + String.valueOf(interpolator));
        }
    }

    @Override
    public Interpolator deserializeInterpolator(JsonReader reader) throws IOException {
        JsonObject args;
        String type;
        switch (reader.peek()) {
            case STRING: {
                type = reader.nextString();
                args = null;
                break;
            }
            case BEGIN_OBJECT: {
                args = new JsonParser().parse(reader).getAsJsonObject();
                type = args.get("type").getAsString();
                break;
            }
            default: {
                throw new IOException("Unexpected token: " + String.valueOf(reader.peek()));
            }
        }
        switch (type) {
            case "linear": {
                return new LinearInterpolator();
            }
            case "cubic-spline": {
                return new CubicSplineInterpolator();
            }
            case "catmull-rom-spline": {
                if (args == null || !args.has("alpha")) {
                    throw new IOException("Missing alpha value for catmull-rom-spline.");
                }
                return new CatmullRomSplineInterpolator(args.get("alpha").getAsDouble());
            }
        }
        throw new IOException("Unknown interpolation type: " + type);
    }

    private Interpolator cloneInterpolator(Interpolator interpolator) {
        Interpolator cloned = this.deserializeInterpolator(this.serializeInterpolator(interpolator));
        interpolator.getKeyframeProperties().forEach(cloned::registerProperty);
        return cloned;
    }

    private String serializeInterpolator(Interpolator interpolator) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonWriter jsonWriter = new JsonWriter((Writer)new PrintWriter(baos));
        try {
            jsonWriter.beginArray();
            this.serializeInterpolator(jsonWriter, interpolator);
            jsonWriter.endArray();
            jsonWriter.flush();
        }
        catch (IOException e) {
            CrashReport crash = CrashReport.forThrowable((Throwable)e, (String)"Serializing interpolator");
            CrashReportCategory category = crash.addCategory("Serializing interpolator");
            category.setDetail("Interpolator", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Interpolator)interpolator));
            throw new ReportedException(crash);
        }
        return baos.toString();
    }

    private Interpolator deserializeInterpolator(String json) {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
        try {
            jsonReader.beginArray();
            return this.deserializeInterpolator(jsonReader);
        }
        catch (IOException e) {
            CrashReport crash = CrashReport.forThrowable((Throwable)e, (String)"De-serializing interpolator");
            CrashReportCategory category = crash.addCategory("De-serializing interpolator");
            category.setDetail("Interpolator", json::toString);
            throw new ReportedException(crash);
        }
    }

    public static enum SPPath {
        TIME,
        POSITION;

    }
}

