/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.IGuiSlider;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.function.Draggable;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractGuiSlider<T extends AbstractGuiSlider<T>>
extends AbstractGuiElement<T>
implements Clickable,
Draggable,
IGuiSlider<T> {
    protected static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"widget/slider");
    protected static final ResourceLocation HANDLE_TEXTURE = ResourceLocation.parse((String)"widget/slider_handle");
    private Runnable onValueChanged;
    private int value;
    private int steps;
    private String text = "";
    private boolean dragging;

    public AbstractGuiSlider() {
    }

    public AbstractGuiSlider(GuiContainer container) {
        super(container);
    }

    @Override
    protected ReadableDimension calcMinSize() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean mouseClick(ReadablePoint position, int button) {
        Point pos = new Point(position);
        if (this.getContainer() != null) {
            this.getContainer().convertFor(this, pos);
        }
        if (this.isMouseHovering((ReadablePoint)pos) && this.isEnabled()) {
            this.updateValue((ReadablePoint)pos);
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDrag(ReadablePoint position, int button, long timeSinceLastCall) {
        if (this.dragging) {
            Point pos = new Point(position);
            if (this.getContainer() != null) {
                this.getContainer().convertFor(this, pos);
            }
            this.updateValue((ReadablePoint)pos);
        }
        return this.dragging;
    }

    @Override
    public boolean mouseRelease(ReadablePoint position, int button) {
        if (this.dragging) {
            this.dragging = false;
            Point pos = new Point(position);
            if (this.getContainer() != null) {
                this.getContainer().convertFor(this, pos);
            }
            this.updateValue((ReadablePoint)pos);
            return true;
        }
        return false;
    }

    protected boolean isMouseHovering(ReadablePoint pos) {
        return pos.getX() > 0 && pos.getY() > 0 && pos.getX() < this.getLastSize().getWidth() && pos.getY() < this.getLastSize().getHeight();
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        int width = size.getWidth();
        int height = size.getHeight();
        ReadablePoint offset = renderer.getOpenGlOffset();
        renderer.getContext().blitSprite(TEXTURE, offset.getX(), offset.getY(), width, height);
        int sliderX = (width - 8) * this.value / this.steps;
        renderer.getContext().blitSprite(HANDLE_TEXTURE, offset.getX() + sliderX, offset.getY(), 8, 20);
        int color = 0xE0E0E0;
        if (!this.isEnabled()) {
            color = 0xA0A0A0;
        } else if (this.isMouseHovering((ReadablePoint)new Point(renderInfo.mouseX, renderInfo.mouseY))) {
            color = 0xFFFFA0;
        }
        renderer.drawCenteredString(width / 2, height / 2 - 4, color, this.text);
    }

    protected void updateValue(ReadablePoint position) {
        if (this.getLastSize() == null) {
            return;
        }
        int width = this.getLastSize().getWidth() - 8;
        int pos = Math.max(0, Math.min(width, position.getX() - 4));
        this.setValue(this.steps * pos / width);
    }

    public void onValueChanged() {
        if (this.onValueChanged != null) {
            this.onValueChanged.run();
        }
    }

    @Override
    public T setText(String text) {
        this.text = text;
        return (T)((AbstractGuiSlider)this.getThis());
    }

    @Override
    public T setI18nText(String text, Object ... args) {
        return (T)this.setText(I18n.get((String)text, (Object[])args));
    }

    @Override
    public T setValue(int value) {
        this.value = value;
        this.onValueChanged();
        return (T)((AbstractGuiSlider)this.getThis());
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public int getSteps() {
        return this.steps;
    }

    @Override
    public T setSteps(int steps) {
        this.steps = steps;
        return (T)((AbstractGuiSlider)this.getThis());
    }

    @Override
    public T onValueChanged(Runnable runnable) {
        this.onValueChanged = runnable;
        return (T)((AbstractGuiSlider)this.getThis());
    }
}

