/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element.advanced;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.advanced.IGuiProgressBar;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.versions.MCVer;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;

public abstract class AbstractGuiProgressBar<T extends AbstractGuiProgressBar<T>>
extends AbstractGuiElement<T>
implements IGuiProgressBar<T> {
    private static final int BORDER = 2;
    private float progress;
    private String label = "%d%%";

    public AbstractGuiProgressBar() {
    }

    public AbstractGuiProgressBar(GuiContainer container) {
        super(container);
    }

    @Override
    public T setProgress(float progress) {
        this.progress = progress;
        return (T)((AbstractGuiProgressBar)this.getThis());
    }

    @Override
    public T setLabel(String label) {
        this.label = label;
        return (T)((AbstractGuiProgressBar)this.getThis());
    }

    @Override
    public T setI18nLabel(String label, Object ... args) {
        return (T)this.setLabel(I18n.get((String)label, (Object[])args));
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        Font fontRenderer = MCVer.getFontRenderer();
        int width = size.getWidth();
        int height = size.getHeight();
        int barTotalWidth = width - 4;
        int barDoneWidth = (int)((float)barTotalWidth * this.progress);
        renderer.drawRect(0, 0, width, height, ReadableColor.BLACK);
        renderer.drawRect(2, 2, barTotalWidth, height - 4, ReadableColor.WHITE);
        renderer.drawRect(2, 2, barDoneWidth, height - 4, ReadableColor.GREY);
        String text = String.format(this.label, (int)(this.progress * 100.0f));
        int n = width / 2;
        int n2 = size.getHeight() / 2;
        Objects.requireNonNull(fontRenderer);
        renderer.drawCenteredString(n, n2 - 9 / 2, ReadableColor.BLACK, text);
    }

    @Override
    public ReadableDimension calcMinSize() {
        return new Dimension(0, 0);
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

