/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.versions;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.DynamicTexture;

public class Image
implements AutoCloseable {
    private NativeImage inner;

    public Image(int width, int height) {
        this(new NativeImage(NativeImage.Format.RGBA, width, height, true));
    }

    public Image(NativeImage inner) {
        this.inner = inner;
    }

    public NativeImage getInner() {
        return this.inner;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.inner != null) {
            this.inner.close();
            this.inner = null;
        }
    }

    public int getWidth() {
        return this.inner.getWidth();
    }

    public int getHeight() {
        return this.inner.getHeight();
    }

    public void setRGBA(int x, int y, int r, int g, int b, int a) {
        this.inner.setPixelRGBA(x, y, (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF);
    }

    public static Image read(Path path) throws IOException {
        return Image.read(Files.newInputStream(path, new OpenOption[0]));
    }

    public static Image read(InputStream in) throws IOException {
        byte[] bytes;
        try (InputStream in_ = in;){
            bytes = in.readAllBytes();
        }
        in = new ByteArrayInputStream(bytes);
        if (bytes[0] != -119 || bytes[1] != 80 || bytes[2] != 78 || bytes[3] != 71) {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
            in = new ByteArrayInputStream(out.toByteArray());
        }
        return new Image(NativeImage.read((InputStream)in));
    }

    public void writePNG(File file) throws IOException {
        this.inner.writeToFile(file);
    }

    public void writePNG(OutputStream outputStream) throws IOException {
        Path tmp = Files.createTempFile("tmp", ".png", new FileAttribute[0]);
        try {
            this.inner.writeToFile(tmp);
            Files.copy(tmp, outputStream);
        }
        finally {
            Files.delete(tmp);
        }
    }

    public Image scaledSubRect(int x, int y, int width, int height, int scaledWidth, int scaledHeight) {
        NativeImage dst = new NativeImage(this.inner.format(), scaledWidth, scaledHeight, false);
        this.inner.resizeSubRectTo(x, y, width, height, dst);
        return new Image(dst);
    }

    @Deprecated
    public BufferedImage toBufferedImage() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writePNG(out);
            return ImageIO.read(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DynamicTexture toTexture() {
        return new DynamicTexture(this.inner);
    }
}

