/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.versions;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MCVer {
    private static final ArrayDeque<ScissorBounds> scissorStateStack = new ArrayDeque();
    private static ScissorBounds scissorState = ScissorBounds.DISABLED;

    public static Minecraft getMinecraft() {
        return Minecraft.getInstance();
    }

    public static void pushScissorState() {
        scissorStateStack.push(scissorState);
    }

    public static void popScissorState() {
        MCVer.setScissorBounds(scissorStateStack.pop());
    }

    public static void setScissorBounds(int x, int y, int width, int height) {
        MCVer.setScissorBounds(new ScissorBounds(x, y, width, height));
    }

    public static void setScissorDisabled() {
        MCVer.setScissorBounds(ScissorBounds.DISABLED);
    }

    private static void setScissorBounds(ScissorBounds newState) {
        boolean wasEnabled;
        ScissorBounds oldState = scissorState;
        if (Objects.equals(oldState, newState)) {
            return;
        }
        scissorState = newState;
        boolean isEnabled = newState != ScissorBounds.DISABLED;
        boolean bl = wasEnabled = oldState != ScissorBounds.DISABLED;
        if (isEnabled) {
            if (!wasEnabled) {
                GL11.glEnable((int)3089);
            }
            GL11.glScissor((int)MCVer.scissorState.x, (int)MCVer.scissorState.y, (int)MCVer.scissorState.width, (int)MCVer.scissorState.height);
        } else {
            GL11.glDisable((int)3089);
        }
    }

    public static Window newScaledResolution(Minecraft mc) {
        return mc.getWindow();
    }

    public static void addDetail(CrashReportCategory category, String name, Callable<String> callable) {
        category.setDetail(name, callable::call);
    }

    public static void drawRect(int right, int bottom, int left, int top) {
        MCVer.drawRect(left, top, right - left, bottom - top, ReadableColor.WHITE, ReadableColor.WHITE, ReadableColor.WHITE, ReadableColor.WHITE);
    }

    public static void drawRect(int x, int y, int width, int height, ReadableColor tl, ReadableColor tr, ReadableColor bl, ReadableColor br) {
        MultiBufferSource.BufferSource provider = MCVer.getMinecraft().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = provider.getBuffer(RenderType.gui());
        vertexConsumer.addVertex((float)x, (float)(y + height), 0.0f).setColor(bl.getRed(), bl.getGreen(), bl.getBlue(), bl.getAlpha());
        vertexConsumer.addVertex((float)(x + width), (float)(y + height), 0.0f).setColor(br.getRed(), br.getGreen(), br.getBlue(), br.getAlpha());
        vertexConsumer.addVertex((float)(x + width), (float)y, 0.0f).setColor(tr.getRed(), tr.getGreen(), tr.getBlue(), tr.getAlpha());
        vertexConsumer.addVertex((float)x, (float)y, 0.0f).setColor(tl.getRed(), tl.getGreen(), tl.getBlue(), tl.getAlpha());
        provider.endBatch();
    }

    public static void bindTexture(ResourceLocation identifier) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)identifier);
    }

    public static Font getFontRenderer() {
        return MCVer.getMinecraft().font;
    }

    public static void setClipboardString(String text) {
        MCVer.getMinecraft().keyboardHandler.setClipboard(text);
    }

    public static String getClipboardString() {
        return MCVer.getMinecraft().keyboardHandler.getClipboard();
    }

    public static Component literalText(String str) {
        return Component.literal((String)str);
    }

    public static ResourceLocation identifier(String id) {
        return ResourceLocation.parse((String)id);
    }

    public static ResourceLocation identifier(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    private static class ScissorBounds {
        private static final ScissorBounds DISABLED = new ScissorBounds(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        private ScissorBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScissorBounds that = (ScissorBounds)o;
            return this.x == that.x && this.y == that.y && this.width == that.width && this.height == that.height;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.width, this.height);
        }
    }

    public static abstract class Keyboard {
        public static final int KEY_ESCAPE = 256;
        public static final int KEY_HOME = 268;
        public static final int KEY_END = 269;
        public static final int KEY_UP = 265;
        public static final int KEY_DOWN = 264;
        public static final int KEY_LEFT = 263;
        public static final int KEY_RIGHT = 262;
        public static final int KEY_BACK = 259;
        public static final int KEY_DELETE = 261;
        public static final int KEY_RETURN = 257;
        public static final int KEY_TAB = 258;
        public static final int KEY_A = 65;
        public static final int KEY_C = 67;
        public static final int KEY_V = 86;
        public static final int KEY_X = 88;

        public static void enableRepeatEvents(boolean enabled) {
        }
    }
}

