/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.versions.mixin;

import de.johni0702.minecraft.gui.versions.callbacks.MouseCallback;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public abstract class MixinMouseListener {
    @Accessor
    abstract int getActiveButton();

    @Inject(method={"lambda$onPress$0([ZLnet/minecraft/client/gui/screens/Screen;DDI)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void mouseDown(boolean[] result, Screen screen, double x, double y, int button, CallbackInfo ci) {
        if (MouseCallback.EVENT.invoker().mouseDown(x, y, button)) {
            result[0] = true;
            ci.cancel();
        }
    }

    @Inject(method={"lambda$onPress$1([ZLnet/minecraft/client/gui/screens/Screen;DDI)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void mouseUp(boolean[] result, Screen screen, double x, double y, int button, CallbackInfo ci) {
        if (MouseCallback.EVENT.invoker().mouseUp(x, y, button)) {
            result[0] = true;
            ci.cancel();
        }
    }

    @Inject(method={"lambda$handleAccumulatedMovement$11(Lnet/minecraft/client/gui/screens/Screen;DDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseDrag(Screen screen, double x, double y, double dx, double dy, CallbackInfo ci) {
        if (MouseCallback.EVENT.invoker().mouseDrag(x, y, this.getActiveButton(), dx, dy)) {
            ci.cancel();
        }
    }

    @Redirect(method={"onScroll(JDD)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;mouseScrolled(DDDD)Z"))
    private boolean mouseScroll(Screen element, double x, double y, double horizontal, double vertical) {
        if (MouseCallback.EVENT.invoker().mouseScroll(x, y, horizontal, vertical)) {
            return true;
        }
        return element.mouseScrolled(x, y, horizontal, vertical);
    }
}

