/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.menu;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.weido.create_bb.data.menu.BogeyStyleMenuState;
import com.weido.create_bb.data.menu.Entry.StyleEntry;
import com.weido.create_bb.data.menu.Entry.StyleEntryManager;
import com.weido.create_bb.data.menu.Input.AxleCountScrollInput;
import com.weido.create_bb.data.menu.Input.LengthScrollInput;
import com.weido.create_bb.data.menu.Input.SizeScrollInput;
import com.weido.create_bb.data.menu.Input.SpeedScrollInput;
import com.weido.create_bb.data.menu.Input.TypeButton;
import com.weido.create_bb.data.menu.Input.ValveGearScrollInput;
import com.weido.create_bb.data.menu.Input.VariantScrollInput;
import com.weido.create_bb.data.packets.BogieStylePacket;
import com.weido.create_bb.registry.BlocksBogiesGuiTextures;
import java.util.Set;
import java.util.stream.Collectors;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class BogieStyleSelectionScreen
extends AbstractSimiScreen {
    private final BlocksBogiesGuiTextures background = BlocksBogiesGuiTextures.BOGIE_MENU;
    private final BlockPos targetPos;
    private static final float MIN_SCALE = 10.0f;
    private static final float MAX_SCALE = 96.0f;
    private static boolean firstTime = true;
    private boolean isDragging = false;
    private boolean isMoving = false;
    private int previewX;
    private int previewY;
    private float previewOffsetX = 0.0f;
    private float previewOffsetY = 0.0f;
    private float previewScale = 26.0f;
    private float rotationX = -20.0f;
    private float rotationY = 45.0f;
    private float totalRotationY = 45.0f;
    private float wheelAngle = 0.0f;
    private float prevWheelAngle = 0.0f;
    private double lastMouseX;
    private double lastMouseY;
    private TypeButton typeButton;
    private ScrollInput variantScroll;
    private ScrollInput valvegearScroll;
    private ScrollInput axleCountScroll;
    private ScrollInput speedScroll;
    private ScrollInput sizeScroll;
    private ScrollInput lengthScroll;
    private StyleEntry.Type currentType = StyleEntry.Type.TRUCK;
    int previewPosRight = 299;
    int previewPosBottom = 211;
    int previewWidth = 296;
    int previewHeight = 129;
    StyleEntry selectedBogey;

    public BogieStyleSelectionScreen(BlockPos pos) {
        this.targetPos = pos;
    }

    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.init();
        this.previewX = this.guiLeft + this.background.getWidth() - this.previewPosRight;
        this.previewY = this.guiTop + this.background.getHeight() - this.previewPosBottom;
        this.currentType = firstTime ? StyleEntry.Type.TRUCK : BogeyStyleMenuState.getLastType();
        int buttonHeight = 18;
        int buttonLeftPos = this.guiLeft + 7;
        int buttonRightPos = this.guiLeft + this.background.getWidth() - 149;
        int buttonTopPos = this.guiTop + this.background.getHeight() - 75;
        int buttonBottomPos = this.guiTop + this.background.getHeight() - 53;
        IconButton confirmButton = (IconButton)new IconButton(this.guiLeft + this.background.getWidth() - 25, this.guiTop + this.background.getHeight() - 24, (ScreenElement)AllIcons.I_CONFIRM).withCallback(this::onClose);
        this.typeButton = (TypeButton)new TypeButton(buttonRightPos, buttonBottomPos).withCallback(() -> {
            this.currentType = this.currentType == StyleEntry.Type.TRUCK ? StyleEntry.Type.DRIVER : StyleEntry.Type.TRUCK;
            this.updateValidOptions();
            this.updateSelectedBogey();
            this.updateSizeSelection();
        });
        this.variantScroll = new VariantScrollInput(buttonLeftPos, buttonTopPos, 142, buttonHeight).setState(firstTime ? 0 : BogeyStyleMenuState.getLastVariant());
        this.valvegearScroll = new ValveGearScrollInput(buttonRightPos, buttonTopPos, 142, buttonHeight).setState(firstTime ? 0 : BogeyStyleMenuState.getLastValvegear());
        this.axleCountScroll = new AxleCountScrollInput(buttonLeftPos, buttonBottomPos, 78, buttonHeight).setState(firstTime ? 2 : BogeyStyleMenuState.getLastAxleCount());
        this.sizeScroll = new SizeScrollInput(this.guiLeft + this.background.getWidth() - 58, buttonBottomPos, 51, buttonHeight);
        this.lengthScroll = new LengthScrollInput(this.guiLeft + this.background.getWidth() - 213, buttonBottomPos, 60, buttonHeight).setState(firstTime ? 0 : BogeyStyleMenuState.getLastBogieLength());
        this.speedScroll = new SpeedScrollInput(buttonLeftPos - 1, this.guiTop + 127, 31, 15).setState(5);
        this.addRenderableWidget((GuiEventListener)confirmButton);
        this.addRenderableWidget((GuiEventListener)this.typeButton);
        this.addRenderableWidget((GuiEventListener)this.variantScroll);
        this.addRenderableWidget((GuiEventListener)this.valvegearScroll);
        this.addRenderableWidget((GuiEventListener)this.axleCountScroll);
        this.addRenderableWidget((GuiEventListener)this.speedScroll);
        this.addRenderableWidget((GuiEventListener)this.sizeScroll);
        this.addRenderableWidget((GuiEventListener)this.lengthScroll);
        this.updateValidOptions();
        this.updateSelectedBogey();
        this.setupScrollCallbacks();
        this.updateSizeSelection();
        this.sizeScroll.setState(firstTime ? 1 : BogeyStyleMenuState.getLastSize());
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.background.render(graphics, this.guiLeft, this.guiTop);
    }

    protected void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.selectedBogey != null && this.minecraft != null && this.minecraft.level != null) {
            int previewX = this.guiLeft + this.background.getWidth() - this.previewPosRight;
            int previewY = this.guiTop + this.background.getHeight() - this.previewPosBottom;
            graphics.enableScissor(previewX, previewY, previewX + this.previewWidth, previewY + this.previewHeight);
            this.renderModelPreview(graphics, partialTicks);
            graphics.disableScissor();
        }
        BlocksBogiesGuiTextures.NUMBER_BACKGROUND.render(graphics, this.speedScroll.getX(), this.speedScroll.getY());
    }

    public void renderWindowForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
        MutableComponent title = Component.translatable((String)"create_bb.menu.title");
        int titleX = this.guiLeft + this.background.getWidth() / 2 - this.font.width((FormattedText)title) / 2;
        int titleY = this.guiTop + 4;
        graphics.drawString(this.font, (Component)title, titleX, titleY, 5841956, false);
        this.renderAllText(graphics);
    }

    public void tick() {
        super.tick();
        this.prevWheelAngle = this.wheelAngle;
        this.wheelAngle = (this.wheelAngle + (float)(-this.speedScroll.getState())) % 360.0f;
    }

    public void onClose() {
        firstTime = false;
        BogeyStyleMenuState.saveState(this.currentType, this.variantScroll.getState(), this.valvegearScroll.getState(), this.axleCountScroll.getState(), this.sizeScroll.getState(), this.lengthScroll.getState());
        BogieStylePacket.Serverbound packet = new BogieStylePacket.Serverbound(this.selectedBogey.bogeyStyle(), ((SizeScrollInput)this.sizeScroll).getCurrentSize(), this.targetPos);
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)packet);
        super.onClose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int speedX = this.speedScroll.getX();
        int speedY = this.speedScroll.getY();
        int numberWidth = BlocksBogiesGuiTextures.NUMBER_BACKGROUND.getWidth();
        int numberHeight = BlocksBogiesGuiTextures.NUMBER_BACKGROUND.getHeight();
        if (mouseX >= (double)speedX && mouseX <= (double)(speedX + numberWidth) && mouseY >= (double)speedY && mouseY <= (double)(speedY + numberHeight)) {
            return this.speedScroll.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        int previewX = this.guiLeft + this.background.getWidth() - this.previewPosRight;
        int previewY = this.guiTop + this.background.getHeight() - this.previewPosBottom;
        if (mouseX >= (double)previewX && mouseX <= (double)(previewX + this.previewWidth) && mouseY >= (double)previewY && mouseY <= (double)(previewY + this.previewHeight)) {
            this.previewScale = (float)Mth.clamp((double)((double)this.previewScale + verticalAmount * 2.0), (double)10.0, (double)96.0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.previewX && mouseX <= (double)(this.previewX + this.previewWidth) && mouseY >= (double)this.previewY && mouseY <= (double)(this.previewY + this.previewHeight)) {
            if (button == 0) {
                this.isDragging = true;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            } else if (button == 1) {
                this.isMoving = true;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            }
            if (this.minecraft != null) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212994);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging || this.isMoving) {
            if (this.minecraft != null) {
                double scaleFactor = this.minecraft.getWindow().getGuiScale();
                double centerX = ((double)this.previewX + (double)this.previewWidth / 2.0) * scaleFactor;
                double centerY = ((double)this.previewY + (double)this.previewHeight / 2.0) * scaleFactor;
                if (this.isDragging) {
                    float deltaX = (float)((mouseX - this.lastMouseX) * 0.5);
                    float deltaY = (float)((mouseY - this.lastMouseY) * 0.5);
                    if (BogieStyleSelectionScreen.hasShiftDown()) {
                        this.totalRotationY += deltaX;
                        this.rotationY = (float)Math.round(this.totalRotationY / 90.0f) * 90.0f;
                        this.rotationX = 0.0f;
                    } else {
                        this.totalRotationY += deltaX;
                        this.rotationY = this.totalRotationY % 360.0f;
                        this.rotationX = Mth.clamp((float)(this.rotationX - deltaY), (float)-22.5f, (float)22.5f);
                    }
                } else {
                    this.previewOffsetX += (float)(mouseX - this.lastMouseX);
                    this.previewOffsetY += (float)(mouseY - this.lastMouseY);
                }
                GLFW.glfwSetCursorPos((long)this.minecraft.getWindow().getWindow(), (double)centerX, (double)centerY);
                this.lastMouseX = centerX / scaleFactor;
                this.lastMouseY = centerY / scaleFactor;
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging || this.isMoving) {
            this.isDragging = false;
            this.isMoving = false;
            if (this.minecraft != null) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212993);
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void updateValidOptions() {
        Set<StyleEntry.ValveGear> validValveGears;
        if (this.currentType == StyleEntry.Type.TRUCK) {
            validValveGears = Set.of(StyleEntry.ValveGear.NONE);
            this.valvegearScroll.setState(0);
        } else {
            validValveGears = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == StyleEntry.Type.DRIVER).map(StyleEntry::valveGear).collect(Collectors.toSet());
        }
        ((ValveGearScrollInput)this.valvegearScroll).updateOptions(validValveGears);
        StyleEntry.ValveGear currentValveGear = ((ValveGearScrollInput)this.valvegearScroll).valveGears[this.valvegearScroll.getState()];
        Set<StyleEntry.Variant> validVariants = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == this.currentType).filter(entry -> entry.valveGear() == currentValveGear).map(StyleEntry::variant).collect(Collectors.toSet());
        ((VariantScrollInput)this.variantScroll).updateOptions(validVariants);
        StyleEntry.Variant variant = ((VariantScrollInput)this.variantScroll).variants[this.variantScroll.getState()];
        if (!validVariants.contains((Object)variant)) {
            this.variantScroll.setState(0);
            variant = ((VariantScrollInput)this.variantScroll).variants[0];
        }
        StyleEntry.Variant currentVariant = variant;
        Set validAxleCounts = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == this.currentType).filter(entry -> entry.variant() == currentVariant).filter(entry -> entry.valveGear() == currentValveGear).map(StyleEntry::axleCount).collect(Collectors.toSet());
        int minAxles = validAxleCounts.stream().min(Integer::compareTo).orElse(2);
        int maxAxles = validAxleCounts.stream().max(Integer::compareTo).orElse(2);
        ((AxleCountScrollInput)this.axleCountScroll).updateOptions(minAxles, maxAxles);
        int currentAxleCount = this.axleCountScroll.getState();
        Set<BogeySizes.BogeySize> validSizes = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == this.currentType).filter(entry -> entry.variant() == currentVariant).filter(entry -> entry.valveGear() == currentValveGear).filter(entry -> entry.axleCount() == currentAxleCount).flatMap(entry -> entry.bogeyStyle().validSizes().stream()).collect(Collectors.toSet());
        BogeySizes.BogeySize currentSize = ((SizeScrollInput)this.sizeScroll).getCurrentSize();
        ((SizeScrollInput)this.sizeScroll).updateOptions(validSizes);
        if (!validSizes.contains(currentSize)) {
            BogeySizes.BogeySize fallbackSize = validSizes.stream().findFirst().orElse(BogeySizes.SMALL);
            this.sizeScroll.setState(validSizes.stream().toList().indexOf(fallbackSize));
        } else {
            this.sizeScroll.setState(validSizes.stream().toList().indexOf(currentSize));
        }
        Set<StyleEntry.Length> validLengths = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == this.currentType).filter(entry -> entry.variant() == currentVariant).filter(entry -> entry.valveGear() == currentValveGear).filter(entry -> entry.axleCount() == currentAxleCount).map(StyleEntry::length).collect(Collectors.toSet());
        ((LengthScrollInput)this.lengthScroll).updateOptions(validLengths);
        StyleEntry.Length currentLength = ((LengthScrollInput)this.lengthScroll).bogieLength[this.lengthScroll.getState()];
        if (!validLengths.contains((Object)currentLength)) {
            this.lengthScroll.setState(0);
        }
        this.updateSelectedBogey();
    }

    private void updateSelectedBogey() {
        VariantScrollInput variantInput = (VariantScrollInput)this.variantScroll;
        ValveGearScrollInput valveGearInput = (ValveGearScrollInput)this.valvegearScroll;
        LengthScrollInput lengthInput = (LengthScrollInput)this.lengthScroll;
        StyleEntry.Variant variant = variantInput.variants[this.variantScroll.getState()];
        StyleEntry.ValveGear valveGear = valveGearInput.valveGears[this.valvegearScroll.getState()];
        StyleEntry.Length length = lengthInput.bogieLength[this.lengthScroll.getState()];
        int axleCount = this.axleCountScroll.getState();
        this.selectedBogey = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.variant() == variant && entry.valveGear() == valveGear && entry.type() == this.currentType && entry.axleCount() == axleCount && entry.length() == length).findFirst().orElseGet(() -> StyleEntry.getOrCreate(AllBogeyStyles.STANDARD, variant, valveGear, this.currentType, axleCount, length));
    }

    private void renderButtonText(GuiGraphics graphics, TypeButton button, Component text) {
        int textWidth = this.font.width((FormattedText)text);
        int buttonX = button.getX();
        int buttonY = button.getY();
        graphics.drawString(this.font, text, buttonX + (button.getWidth() - textWidth) / 2, buttonY + 5, 0xFFFFFF, true);
    }

    private void renderScrollText(GuiGraphics graphics, ScrollInput scroll, Component text) {
        int textWidth = this.font.width((FormattedText)text);
        int scrollX = scroll.getX();
        int scrollY = scroll.getY();
        graphics.drawString(this.font, text, scrollX + (scroll.getWidth() - textWidth) / 2 + 1, scrollY + 5, 0xFFFFFF, true);
    }

    private void renderScrollNumber(GuiGraphics graphics, ScrollInput scroll, Component text) {
        int textWidth = this.font.width((FormattedText)text);
        int scrollX = scroll.getX();
        int scrollY = scroll.getY();
        graphics.drawString(this.font, text, scrollX + 1 + (scroll.getWidth() - textWidth) / 2, scrollY + 4, 5841956, false);
    }

    private void renderModelPreview(GuiGraphics graphics, float partialTicks) {
        int speedX = this.speedScroll.getX();
        int speedY = this.speedScroll.getY();
        int numberWidth = BlocksBogiesGuiTextures.NUMBER_BACKGROUND.getWidth();
        int numberHeight = BlocksBogiesGuiTextures.NUMBER_BACKGROUND.getHeight();
        graphics.enableScissor(this.previewX, this.previewY, speedX + 1, this.previewY + this.previewHeight);
        this.renderModel(graphics, partialTicks);
        graphics.disableScissor();
        graphics.enableScissor(speedX + numberWidth - 1, this.previewY, this.previewX + this.previewWidth, this.previewY + this.previewHeight);
        this.renderModel(graphics, partialTicks);
        graphics.disableScissor();
        graphics.enableScissor(speedX, this.previewY, speedX + numberWidth, speedY + 1);
        this.renderModel(graphics, partialTicks);
        graphics.disableScissor();
        graphics.enableScissor(speedX, speedY + numberHeight - 1, speedX + numberWidth, this.previewY + this.previewHeight);
        this.renderModel(graphics, partialTicks);
        graphics.disableScissor();
    }

    private void renderModel(GuiGraphics graphics, float partialTicks) {
        if (this.selectedBogey == null || this.minecraft == null || this.minecraft.level == null) {
            return;
        }
        BogeyStyle style = this.selectedBogey.bogeyStyle();
        BogeySizes.BogeySize renderSize = ((SizeScrollInput)this.sizeScroll).getCurrentSize();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int backgroundWidth = this.background.getWidth();
        poseStack.translate((float)this.guiLeft + (float)backgroundWidth / 2.0f + this.previewOffsetX, (float)(this.guiTop + this.background.getHeight() - 151) + this.previewOffsetY, 1500.0f);
        poseStack.scale(1.0f, 1.0f, -1.0f);
        poseStack.translate(0.0f, 0.0f, 1000.0f);
        poseStack.scale(this.previewScale, this.previewScale, this.previewScale);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(this.rotationX));
        poseStack.mulPose(Axis.YP.rotationDegrees(this.rotationY));
        Lighting.setupForEntityInInventory();
        MultiBufferSource.BufferSource bufferSource = this.minecraft.renderBuffers().bufferSource();
        int light = 0xF000F0;
        int overlay = OverlayTexture.NO_OVERLAY;
        float interpolatedAngle = this.lerpAngle(partialTicks, this.prevWheelAngle, this.wheelAngle);
        BlockState bogeyState = (BlockState)style.getBlockForSize(renderSize).defaultBlockState().setValue((Property)AbstractBogeyBlock.AXIS, (Comparable)Direction.Axis.Z);
        ((SuperByteBuffer)CachedBuffers.block((BlockState)bogeyState).translate(-0.5f, -0.5f, -0.5f)).light(light).overlay(overlay).renderInto(poseStack, bufferSource.getBuffer(RenderType.cutoutMipped()));
        style.render(renderSize, partialTicks, poseStack, (MultiBufferSource)bufferSource, light, overlay, interpolatedAngle, null, false);
        bufferSource.endBatch();
        poseStack.popPose();
        RenderSystem.clear((int)256, (boolean)false);
    }

    private void renderAllText(GuiGraphics graphics) {
        VariantScrollInput variantInput = (VariantScrollInput)this.variantScroll;
        ValveGearScrollInput valveGearInput = (ValveGearScrollInput)this.valvegearScroll;
        LengthScrollInput lengthInput = (LengthScrollInput)this.lengthScroll;
        MutableComponent typeText = Component.translatable((String)"create_bb.menu.type").append(this.currentType.getDisplayText());
        this.renderButtonText(graphics, this.typeButton, (Component)typeText);
        MutableComponent variantText = Component.translatable((String)"create_bb.menu.variant").append(variantInput.variants[this.variantScroll.getState()].getDisplayText());
        this.renderScrollText(graphics, this.variantScroll, (Component)variantText);
        this.disabledScroll(graphics, this.variantScroll, variantInput.variants.length);
        MutableComponent valveGearText = Component.translatable((String)"create_bb.menu.valve_gear").append(valveGearInput.valveGears[this.valvegearScroll.getState()].getDisplayText());
        this.renderScrollText(graphics, this.valvegearScroll, (Component)valveGearText);
        this.disabledScroll(graphics, this.valvegearScroll, valveGearInput.valveGears.length);
        MutableComponent axleText = Component.translatable((String)"create_bb.menu.axle_count").append(String.valueOf(this.axleCountScroll.getState()));
        this.renderScrollText(graphics, this.axleCountScroll, (Component)axleText);
        this.disabledScroll(graphics, this.axleCountScroll, ((AxleCountScrollInput)this.axleCountScroll).getMaxAxles() == ((AxleCountScrollInput)this.axleCountScroll).getMinAxles() ? 1 : 0);
        MutableComponent speedText = Component.literal((String)String.valueOf(this.speedScroll.getState()));
        this.renderScrollNumber(graphics, this.speedScroll, (Component)speedText);
        String sizeKey = ((SizeScrollInput)this.sizeScroll).getCurrentSize() == BogeySizes.LARGE ? (this.currentType == StyleEntry.Type.DRIVER ? "create_bb.menu.size.extra_large" : "create_bb.menu.size.large") : (this.currentType == StyleEntry.Type.DRIVER ? "create_bb.menu.size.large" : "create_bb.menu.size.small");
        MutableComponent sizeText = Component.translatable((String)sizeKey);
        this.renderScrollText(graphics, this.sizeScroll, (Component)sizeText);
        this.disabledScroll(graphics, this.sizeScroll, ((SizeScrollInput)this.sizeScroll).getSizes().length);
        Component lengthText = lengthInput.bogieLength[this.lengthScroll.getState()].getDisplayText();
        this.renderScrollText(graphics, this.lengthScroll, lengthText);
        this.disabledScroll(graphics, this.lengthScroll, lengthInput.bogieLength.length);
    }

    private void disabledScroll(GuiGraphics graphics, ScrollInput scrollInput, int optionsLength) {
        if (optionsLength == 1) {
            graphics.fill(scrollInput.getX(), scrollInput.getY(), scrollInput.getX() + scrollInput.getWidth(), scrollInput.getY() + scrollInput.getHeight(), -2144128205);
        }
    }

    private void setupScrollCallbacks() {
        ScrollInput[] scrolls;
        for (ScrollInput scroll : scrolls = new ScrollInput[]{this.variantScroll, this.valvegearScroll, this.axleCountScroll, this.sizeScroll, this.lengthScroll}) {
            scroll.calling(state -> {
                this.updateSelectedBogey();
                this.updateValidOptions();
            });
        }
    }

    private void updateSizeSelection() {
        ((SizeScrollInput)this.sizeScroll).setDriver(this.currentType == StyleEntry.Type.DRIVER);
    }

    private float lerpAngle(float partialTicks, float start, float end) {
        float delta = (end - start + 540.0f) % 360.0f - 180.0f;
        return start + delta * partialTicks;
    }
}

